/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.slu.entity;

import javax.annotation.Nullable;
import net.mcreator.slu.init.SluModItems;
import net.mcreator.slu.procedures.AbyssWatcherInitialSpawnCodeProcedure;
import net.mcreator.slu.procedures.AbyssWatcherLoyaltyCodeProcedure;
import net.mcreator.slu.procedures.BossAiCodeProcedure;
import net.mcreator.slu.procedures.BossDieCodeProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.SpawnPlacementRegisterEvent;

public class BossAbyssWatcherEntity
extends Monster {
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);

    public BossAbyssWatcherEntity(EntityType<BossAbyssWatcherEntity> type, Level world) {
        super(type, world);
        this.xpReward = 30;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)SluModItems.CINDER_KING_GREATSWORD.get()));
        this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)SluModItems.FARRON_DAGGER.get()));
        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)SluModItems.WATCHER_HELMET.get()));
        this.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)SluModItems.WATCHER_CHESTPLATE.get()));
        this.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)SluModItems.WATCHER_LEGGINGS.get()));
        this.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)SluModItems.WATCHER_BOOTS.get()));
        this.refreshDimensions();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 4.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = BossAbyssWatcherEntity.this.getX();
                double y = BossAbyssWatcherEntity.this.getY();
                double z = BossAbyssWatcherEntity.this.getZ();
                BossAbyssWatcherEntity entity = BossAbyssWatcherEntity.this;
                Level world = BossAbyssWatcherEntity.this.level();
                return super.canUse() && AbyssWatcherLoyaltyCodeProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = BossAbyssWatcherEntity.this.getX();
                double y = BossAbyssWatcherEntity.this.getY();
                double z = BossAbyssWatcherEntity.this.getZ();
                BossAbyssWatcherEntity entity = BossAbyssWatcherEntity.this;
                Level world = BossAbyssWatcherEntity.this.level();
                return super.canContinueToUse() && AbyssWatcherLoyaltyCodeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = BossAbyssWatcherEntity.this.getX();
                double y = BossAbyssWatcherEntity.this.getY();
                double z = BossAbyssWatcherEntity.this.getZ();
                BossAbyssWatcherEntity entity = BossAbyssWatcherEntity.this;
                Level world = BossAbyssWatcherEntity.this.level();
                return super.canUse() && AbyssWatcherLoyaltyCodeProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = BossAbyssWatcherEntity.this.getX();
                double y = BossAbyssWatcherEntity.this.getY();
                double z = BossAbyssWatcherEntity.this.getZ();
                BossAbyssWatcherEntity entity = BossAbyssWatcherEntity.this;
                Level world = BossAbyssWatcherEntity.this.level();
                return super.canContinueToUse() && AbyssWatcherLoyaltyCodeProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = BossAbyssWatcherEntity.this.getX();
                double y = BossAbyssWatcherEntity.this.getY();
                double z = BossAbyssWatcherEntity.this.getZ();
                BossAbyssWatcherEntity entity = BossAbyssWatcherEntity.this;
                Level world = BossAbyssWatcherEntity.this.level();
                return super.canUse() && AbyssWatcherLoyaltyCodeProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = BossAbyssWatcherEntity.this.getX();
                double y = BossAbyssWatcherEntity.this.getY();
                double z = BossAbyssWatcherEntity.this.getZ();
                BossAbyssWatcherEntity entity = BossAbyssWatcherEntity.this;
                Level world = BossAbyssWatcherEntity.this.level();
                return super.canContinueToUse() && AbyssWatcherLoyaltyCodeProcedure.execute((Entity)entity);
            }
        }.setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return super.getPassengerRidingPosition(entity).add(0.0, (double)-0.35f, 0.0);
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("slu:real_heavy_walking")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.iron_golem.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.iron_golem.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public void die(DamageSource source) {
        super.die(source);
        BossDieCodeProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), source, (Entity)this);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        AbyssWatcherInitialSpawnCodeProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ());
        return retval;
    }

    public void baseTick() {
        super.baseTick();
        BossAiCodeProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public boolean canChangeDimensions() {
        return false;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.6f);
    }

    public static void init(SpawnPlacementRegisterEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.24);
        builder = builder.add(Attributes.MAX_HEALTH, 130.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 1.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 48.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 3.0);
        return builder;
    }
}

