/*
 * Decompiled with CFR 0.152.
 */
package me.choketa.crazyeggs.eggs.eggs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import me.choketa.crazyeggs.CrazyEggs;
import me.choketa.crazyeggs.eggs.EggPermissions;
import me.choketa.crazyeggs.eggs.EggRecipe;
import me.choketa.crazyeggs.utils.ColorUtils;
import me.choketa.crazyeggs.utils.Pair;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class PluginEgg {
    public final boolean isOld;
    private final String name;
    private final String simpleName;
    private ItemStack eggItem;
    private final File file;
    private YamlConfiguration customFile;
    private final Map<String, Object> cache;
    private final NamespacedKey key;
    private List<Pair<Sound, Pair<Float, Float>>> impactSounds;
    private List<Pair<Particle, Integer>> particles;
    private List<PotionEffect> potionEffects;

    public PluginEgg(String name) {
        this.name = name;
        this.simpleName = name.replace("_", "").toLowerCase();
        this.file = new File(String.valueOf(CrazyEggs.getPlugin().getDataFolder()) + "/eggs", name + ".yml");
        this.isOld = this.file.exists();
        if (!this.isOld) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                CrazyEggs.getPlugin().getLogger().warning("Unable to create file for " + name);
            }
        }
        this.cache = new HashMap<String, Object>();
        this.customFile = YamlConfiguration.loadConfiguration((File)this.file);
        this.customFile.options().copyDefaults(true);
        if (!this.isOld) {
            this.setDefaults();
        }
        this.save();
        for (String str : this.customFile.getKeys(false)) {
            this.cache.put(str, this.get(str));
        }
        this.key = new NamespacedKey((Plugin)CrazyEggs.getPlugin(), "crazyeggs" + name);
        new EggPermissions(this);
    }

    public void initializeRecipe() {
        if (this.getBoolean("is-craftable")) {
            new EggRecipe(this);
        }
    }

    public <T> T get(String path) {
        return (T)this.cache.getOrDefault(path, this.customFile.get(path));
    }

    public float getFloat(String path) {
        return (float)this.customFile.getDouble(path);
    }

    public boolean getBoolean(String path) {
        return this.customFile.getBoolean(path);
    }

    public FileConfiguration save() {
        try {
            this.customFile.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.cache.clear();
        for (String str : this.customFile.getKeys(false)) {
            this.cache.put(str, this.get(str));
        }
        return this.customFile;
    }

    public FileConfiguration reload() {
        this.customFile = YamlConfiguration.loadConfiguration((File)this.file);
        this.cache.clear();
        for (String str : this.customFile.getKeys(false)) {
            this.cache.put(str, this.get(str));
        }
        return this.customFile;
    }

    public void setDefaults() {
        this.set("display-name", "&#b32222&l" + this.name.replace('_', ' '), Collections.singletonList("The name of the egg item"));
        this.set("lore", List.of("&cThis is quite the egg"), List.of("The lore of the egg item. Keep the dash only if you want no lore"));
        this.set("is-craftable", true, Collections.singletonList("Determines whether the egg is craftable or not"));
        this.set("recipe", List.of("EEE", "ETE", "EEE"), Collections.singletonList("The crafting layout for the recipe"));
        this.set("materials", null, Collections.singletonList("The materials that correspond to each letter"));
        this.set("materials.E", "EGG");
        this.set("materials.T", "TNT");
        this.set("upon-craft-amount", 4, Collections.singletonList("Determines the amount of eggs given upon crafting"));
        this.set("damage", 15.0, Collections.singletonList("The damage inflicted upon an entity when hit"));
        this.set("velocity-multiplier", 0.45, Collections.singletonList("Velocity of the hit entity upon impact. Feel free to experiment"));
        this.set("velocity-set-y", 0.5);
        this.set("enable-spawn-eggs-drop", true, Collections.singletonList("Determines if a living entity will drop their corresponding spawn egg"));
        this.set("spawn-egg-rarity", "10.0%", Collections.singletonList("Determines the probability that a spawn egg will be dropped"));
        this.set("should-explode", false, Collections.singletonList("Determines whether the egg explodes on impact"));
        this.set("power", 8.0, Collections.singletonList("Determines the power of the explosion caused by the egg (For reference, 4 is the power of regular TNT)"));
        this.set("cooldown", 10, Collections.singletonList("Cooldown for the egg. Input in seconds"));
        this.set("should-set-fire", false, Collections.singletonList("Determines whether explosions caused by the Destruction Egg should set nearby blocks on fire"));
        this.set("impact-particles", List.of("DAMAGE_INDICATOR,5"), List.of("The particles that should be spawned when the egg hits an entity", "Parameters: Particle name, number of particles"));
        this.set("impact-sounds", List.of("ENTITY_LIGHTNING_BOLT_IMPACT,1.0,1.0"), List.of("The sounds played when the egg hits an entity", "Parameters: Sound name, volume, pitch"));
        this.set("set-glint", true, Collections.singletonList("Determines whether the egg is decorated with an enchantment glint"));
        this.set("potion-effects", List.of(new PotionEffect(PotionEffectType.SLOWNESS, 100, 0, true, true).serialize()), Collections.singletonList("The potion effects to apply on entity upon impact"));
        this.set("custom-model-data", -1, Collections.singletonList("For resourcepacks"));
    }

    private List<Component> adaptLore(List<String> lore) {
        ArrayList<Component> actualLore = new ArrayList<Component>();
        for (String str : lore) {
            actualLore.add(ColorUtils.format(str));
        }
        return actualLore;
    }

    public ItemStack getEggItem() {
        if (this.eggItem == null) {
            this.eggItem = new ItemStack(Material.EGG);
            this.eggItem.editMeta(meta -> {
                int customModelData;
                meta.itemName(ColorUtils.format((String)this.get("display-name")));
                List lore = (List)this.get("lore");
                if (lore != null && !lore.isEmpty()) {
                    meta.lore(this.adaptLore(lore));
                }
                if (((Boolean)this.get("set-glint")).booleanValue()) {
                    meta.addEnchant(Enchantment.UNBREAKING, 1, false);
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                }
                if ((customModelData = ((Integer)this.get("custom-model-data")).intValue()) != -1) {
                    meta.setCustomModelData(Integer.valueOf(customModelData));
                }
                meta.getPersistentDataContainer().set(this.key, PersistentDataType.BOOLEAN, (Object)true);
            });
        }
        return this.eggItem.clone();
    }

    public void set(@NotNull String path, Object obj, @Nullable List<String> description) {
        this.customFile.set(path, obj);
        if (description != null) {
            this.customFile.setComments(path, description);
        }
    }

    public void set(@NotNull String path, Object obj) {
        this.customFile.set(path, obj);
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getDisplayName() {
        return (String)this.get("display-name");
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public double getDouble(String path) {
        return (Double)this.get(path);
    }

    public FileConfiguration getConfig() {
        return this.customFile;
    }

    public int getInteger(String path) {
        return (Integer)this.get(path);
    }

    public List<Pair<Sound, Pair<Float, Float>>> getImpactSounds() {
        List soundString;
        if (this.impactSounds == null && (soundString = (List)this.get("impact-sounds")) != null && !soundString.isEmpty()) {
            this.impactSounds = new ArrayList<Pair<Sound, Pair<Float, Float>>>();
            for (String s : soundString) {
                String[] process = s.split(",");
                this.impactSounds.add(new Pair<Sound, Pair<Float, Float>>(Sound.valueOf((String)process[0]), new Pair<Float, Float>(Float.valueOf(Float.parseFloat(process[1])), Float.valueOf(Float.parseFloat(process[2])))));
            }
        }
        return this.impactSounds;
    }

    public List<Pair<Particle, Integer>> getParticles() {
        List particleString;
        if (this.particles == null && (particleString = (List)this.get("impact-particles")) != null && !particleString.isEmpty()) {
            this.particles = new ArrayList<Pair<Particle, Integer>>();
            for (String s : particleString) {
                String[] process = s.split(",");
                this.particles.add(new Pair<Particle, Integer>(Particle.valueOf((String)process[0]), Integer.parseInt(process[1])));
            }
        }
        return this.particles;
    }

    public List<PotionEffect> getPotionEffects() {
        if (this.potionEffects == null) {
            this.potionEffects = new ArrayList<PotionEffect>();
            List potions = (List)this.get("potion-effects");
            for (Map toAdd : potions) {
                this.potionEffects.add(new PotionEffect(toAdd));
            }
        }
        return this.potionEffects;
    }
}

