/*
 * Decompiled with CFR 0.152.
 */
package me.choketa.crazyeggs;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import me.choketa.crazyeggs.commands.GetEgg;
import me.choketa.crazyeggs.commands.ReloadEggs;
import me.choketa.crazyeggs.eggs.EggManager;
import me.choketa.crazyeggs.listeners.OnOpJoinEvent;
import me.choketa.crazyeggs.utils.UpdateChecker;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class CrazyEggs
extends JavaPlugin {
    private static CrazyEggs plugin;
    private final Set<NamespacedKey> recipes = new HashSet<NamespacedKey>();
    public static final Random RANDOM;

    public void onEnable() {
        plugin = this;
        this.getConfig().options().copyDefaults();
        this.saveDefaultConfig();
        EggManager.getEggManager().loadEggs();
        this.getServer().getPluginManager().registerEvents((Listener)new OnOpJoinEvent(), (Plugin)this);
        this.registerCmd(new GetEgg(), "giveegg");
        this.registerCmd(new ReloadEggs(), "reloadeggs");
        new UpdateChecker().getVersion(version -> {
            String curr = "\"" + this.getDescription().getVersion() + "\"";
            if (version.replaceFirst("r\":\"[0-9]\\.[0-9]+\\.[0-9]+(\\.[0-9]+)?\"", "r\":" + curr).equals(version)) {
                this.getLogger().info("There isn't a new update available.");
            } else {
                this.getLogger().warning("There is a new update available!");
                this.getLogger().warning("Go to https://modrinth.com/plugin/crazy-eggs in order to update!");
            }
        });
    }

    private <T extends CommandExecutor> void registerCmd(T obj, String cmdName) {
        PluginCommand setCmd = this.getCommand(cmdName);
        setCmd.setExecutor(obj);
        if (obj instanceof TabCompleter) {
            setCmd.setTabCompleter((TabCompleter)obj);
        }
    }

    private Permission getPermission(String name) {
        return this.getServer().getPluginManager().getPermission(name);
    }

    public Permission addParentPermission(String name, PermissionDefault def, @Nullable String description) {
        Permission permission = this.getPermission(name);
        if (permission == null) {
            permission = new Permission(name);
            permission.setDefault(def);
            if (description != null) {
                permission.setDescription(description);
            }
            this.getServer().getPluginManager().addPermission(permission);
        }
        return permission;
    }

    public Permission addPermission(String name, PermissionDefault def, @Nullable String description) {
        Permission permission = this.getPermission(name);
        if (permission == null) {
            permission = new Permission(name);
            permission.setDefault(def);
            if (description != null) {
                permission.setDescription(description);
            }
            permission.addParent(name.replaceAll("\\.(.*)", ".*"), true);
            this.getServer().getPluginManager().addPermission(permission);
        }
        return permission;
    }

    public void onDisable() {
        this.recipes.forEach(recipe -> this.getServer().removeRecipe(recipe));
    }

    public static CrazyEggs getPlugin() {
        return plugin;
    }

    public Set<NamespacedKey> getRecipes() {
        return this.recipes;
    }

    static {
        RANDOM = new Random();
    }
}

