/*
 * Decompiled with CFR 0.152.
 */
package me.choketa.crazyeggs.commands;

import java.util.List;
import me.choketa.crazyeggs.eggs.EggManager;
import me.choketa.crazyeggs.eggs.PluginEgg;
import me.choketa.crazyeggs.utils.ColorUtils;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GetEgg
implements CommandExecutor,
TabCompleter {
    private final EggManager manager = EggManager.getEggManager();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Player player;
        if (args.length >= 4) {
            sender.sendMessage(ColorUtils.format("&c[CrazyEggs] Proper usage: &e/giveegg <player> <egg> <amount>"));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(ColorUtils.format("&c[CrazyEggs] You must specify a player"));
            return true;
        }
        Player exactPlayer = Bukkit.getPlayerExact((String)args[0]);
        if (exactPlayer == null || !exactPlayer.isOnline()) {
            sender.sendMessage(ColorUtils.format("&c[CrazyEggs] No player was found"));
            return true;
        }
        if (args.length == 1) {
            sender.sendMessage(ColorUtils.format("&c[CrazyEggs] You must specify an egg"));
            return true;
        }
        PluginEgg egg = this.manager.getEggByName(args[1]);
        if (egg == null) {
            sender.sendMessage(ColorUtils.format("&c[CrazyEggs] No egg was found"));
            return true;
        }
        if (sender instanceof Player && !(player = (Player)sender).hasPermission("crazyeggs." + egg.getSimpleName() + ".getegg")) {
            player.sendMessage(ColorUtils.format("&c[CrazyEggs] You do not have the permission to obtain this egg."));
            return true;
        }
        ItemStack eggStack = egg.getEggItem();
        if (args.length == 2) {
            eggStack.setAmount(1);
            exactPlayer.getInventory().addItem(new ItemStack[]{eggStack});
            sender.sendMessage(ColorUtils.format("&4[CrazyEggs] &fGave 1 " + egg.getDisplayName() + "&r to " + exactPlayer.getName()));
            exactPlayer.playSound((Entity)exactPlayer, Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
            return true;
        }
        try {
            int parse = Integer.parseInt(args[2]);
            eggStack.setAmount(parse);
            exactPlayer.getInventory().addItem(new ItemStack[]{eggStack});
            sender.sendMessage(ColorUtils.format("&4[CrazyEggs] &fGave " + parse + " " + egg.getDisplayName() + "&r to " + exactPlayer.getName()));
            exactPlayer.playSound((Entity)exactPlayer, Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(ColorUtils.format("&c[CrazyEggs] Proper usage: &e/getegg <player> <egg> <amount>"));
            return true;
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 1) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
        }
        if (args.length == 2) {
            return this.manager.getEggs().stream().map(PluginEgg::getName).toList();
        }
        return null;
    }
}

