/*
 * Decompiled with CFR 0.152.
 */
package me.choketa.crazyeggs.eggs;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.choketa.crazyeggs.CrazyEggs;
import me.choketa.crazyeggs.eggs.EggManager;
import me.choketa.crazyeggs.eggs.PluginEgg;
import me.choketa.crazyeggs.utils.ColorUtils;
import me.choketa.crazyeggs.utils.Pair;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class EggListener
implements Listener {
    private final CrazyEggs plugin = CrazyEggs.getPlugin();
    private final EggManager manager = EggManager.getEggManager();
    private final HashMap<UUID, HashMap<PluginEgg, Long>> cooldown = new HashMap();

    @EventHandler
    public void onHit(ProjectileHitEvent event) {
        boolean isLucky;
        if (!(event.getEntity().getShooter() instanceof Player)) {
            return;
        }
        Entity entity = event.getHitEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity hitEntity = (LivingEntity)entity;
        PluginEgg egg = this.manager.getEggByPDC(event.getEntity());
        if (egg == null) {
            return;
        }
        if (egg.getBoolean("should-explode")) {
            return;
        }
        World world = hitEntity.getWorld();
        Location location = hitEntity.getLocation();
        List<Pair<Sound, Pair<Float, Float>>> impactSounds = egg.getImpactSounds();
        List<Pair<Particle, Integer>> particles = egg.getParticles();
        List<PotionEffect> potionEffects = egg.getPotionEffects();
        hitEntity.damage(((Double)egg.get("damage")).doubleValue());
        if (impactSounds != null) {
            for (Pair<Object, Object> pair : impactSounds) {
                world.playSound((Entity)hitEntity, (Sound)pair.a(), ((Float)((Pair)pair.b()).a()).floatValue(), ((Float)((Pair)pair.b()).a()).floatValue());
            }
        }
        if (particles != null) {
            for (Pair<Object, Object> pair : particles) {
                world.spawnParticle((Particle)pair.a(), location, ((Integer)pair.b()).intValue());
            }
        }
        if (potionEffects != null) {
            for (PotionEffect potionEffect : potionEffects) {
                hitEntity.addPotionEffect(potionEffect);
            }
        }
        Vector direction = event.getEntity().getVelocity().multiply(egg.getDouble("velocity-multiplier"));
        hitEntity.setVelocity(direction.setY(egg.getDouble("velocity-set-y")));
        hitEntity.setVelocity(direction);
        if (!egg.getBoolean("enable-spawn-eggs-drop")) {
            return;
        }
        String string = (String)egg.get("spawn-egg-rarity");
        double percentage = Double.parseDouble(string.replace("%", ""));
        boolean bl = isLucky = CrazyEggs.RANDOM.nextDouble(0.0, 100.0) < percentage;
        if (hitEntity.isDead() && isLucky && !(hitEntity instanceof Player) && this.plugin.getConfig().getBoolean("enable-spawn-eggs-drop")) {
            String name = hitEntity.getName().toUpperCase();
            Material eggMaterial = Material.matchMaterial((String)(name + "_SPAWN_EGG"));
            if (eggMaterial == null) {
                return;
            }
            ItemStack eggItem = new ItemStack(eggMaterial);
            world.dropItem(location, eggItem);
        }
    }

    @EventHandler
    public void onExplosionHit(ProjectileHitEvent event) {
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        Projectile proj = event.getEntity();
        PluginEgg egg = this.manager.getEggByPDC(proj);
        if (egg == null) {
            return;
        }
        if (!egg.getBoolean("should-explode")) {
            return;
        }
        float power = egg.getFloat("power");
        player.getWorld().createExplosion(proj.getLocation(), power, ((Boolean)egg.get("should-set-fire")).booleanValue());
    }

    @EventHandler
    public void onLaunch(ProjectileLaunchEvent event) {
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        ItemStack item = player.getInventory().getItemInMainHand();
        if (!(event.getEntity() instanceof Egg)) {
            return;
        }
        PluginEgg egg = this.manager.getEggByPDC(item);
        if (egg == null) {
            return;
        }
        if (!player.hasPermission("crazyeggs." + egg.getSimpleName() + ".use")) {
            event.setCancelled(true);
            player.sendMessage("crazyeggs." + egg.getSimpleName() + ".use");
            player.sendMessage(ColorUtils.format("&c[CrazyEggs] You are not allowed to use this egg!"));
            return;
        }
        if (player.hasPermission("crazyeggs." + egg.getSimpleName() + ".bypass.cooldown") || egg.getInteger("cooldown") <= 0) {
            return;
        }
        UUID id = player.getUniqueId();
        if (!this.cooldown.containsKey(id)) {
            HashMap<PluginEgg, Long> newMap = new HashMap<PluginEgg, Long>();
            newMap.put(egg, System.currentTimeMillis());
            this.cooldown.put(id, newMap);
        } else {
            int cooldowns;
            HashMap<PluginEgg, Long> map = this.cooldown.get(id);
            long timeElapsed = System.currentTimeMillis() - map.get(egg);
            if (timeElapsed >= (long)(cooldowns = this.plugin.getConfig().getInt("cooldown")) * 1000L) {
                map.put(egg, System.currentTimeMillis());
                this.cooldown.put(player.getUniqueId(), map);
            } else {
                player.sendMessage(ColorUtils.format("&c[CrazyEggs] You are in a cooldown. &e" + ((long)cooldowns * 1000L - timeElapsed) / 1000L + " &cmore seconds."));
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onHatch(PlayerEggThrowEvent event) {
        if (this.manager.getEggByPDC((Projectile)event.getEgg()) == null) {
            return;
        }
        event.setHatching(false);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        for (PluginEgg egg : this.manager.getEggs()) {
            NamespacedKey recipe = egg.getKey();
            if (!player.hasPermission("crazyeggs." + egg.getSimpleName() + ".craft") && player.hasDiscoveredRecipe(recipe)) {
                player.undiscoverRecipe(recipe);
                continue;
            }
            if (player.hasDiscoveredRecipe(recipe)) continue;
            player.discoverRecipe(recipe);
        }
    }

    @EventHandler
    public void onCraft(PrepareItemCraftEvent event) {
        Player player = (Player)event.getInventory().getHolder();
        if (player == null) {
            return;
        }
        ItemStack result = event.getInventory().getResult();
        if (result == null) {
            return;
        }
        if (!event.getInventory().contains(Material.EGG)) {
            return;
        }
        for (PluginEgg egg : this.manager.getEggs()) {
            if (!event.getInventory().contains(egg.getEggItem()) || !result.isSimilar(egg.getEggItem()) || player.hasPermission("crazyeggs." + egg.getSimpleName() + ".craft")) continue;
            event.getInventory().setResult(new ItemStack(Material.AIR));
            return;
        }
    }
}

