/*
 * Decompiled with CFR 0.152.
 */
package me.choketa.crazyeggs.eggs;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.choketa.crazyeggs.CrazyEggs;
import me.choketa.crazyeggs.eggs.EggListener;
import me.choketa.crazyeggs.eggs.PluginEgg;
import org.bukkit.Material;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;

public class EggManager {
    private static EggManager eggManager;
    private final CrazyEggs plugin = CrazyEggs.getPlugin();
    private final List<PluginEgg> eggs = new ArrayList<PluginEgg>();
    private final File eggsFolder = new File(String.valueOf(this.plugin.getDataFolder()) + "/eggs");
    private final boolean isOld = this.eggsFolder.exists();

    private EggManager() {
        if (this.isOld) {
            return;
        }
        this.eggsFolder.mkdirs();
    }

    public void makeCrazy(PluginEgg egg) {
        egg.set("display-name", "&c&lCrazy &#b32222&lEgg");
        egg.set("lore", List.of("&cKill with the crazy egg!"));
        egg.set("cooldown", 0);
        egg.save();
    }

    public void makeDestruction(PluginEgg egg) {
        egg.set("should-explode", true);
        egg.set("display-name", "&5&lDestruction Egg");
        egg.set("lore", List.of("&4Dangerous weapon. Use foolishly."));
        egg.set("recipe", List.of("EEE", "ETE", "EEE"));
        egg.set("materials.E", "Crazy_Egg");
        egg.set("materials.T", "CREEPER_SPAWN_EGG");
        egg.save();
    }

    public void loadEggs() {
        if (!this.isOld) {
            PluginEgg crazy = new PluginEgg("Crazy_Egg");
            this.makeCrazy(crazy);
            PluginEgg destruction = new PluginEgg("Destruction_Egg");
            this.makeDestruction(destruction);
            this.eggs.add(crazy);
            this.eggs.add(destruction);
        }
        List<File> files = !this.isOld ? Arrays.stream(this.eggsFolder.listFiles()).filter(f -> f.getName().equals("Crazy_Egg") || f.getName().equals("Destruction_Egg")).toList() : Arrays.stream(this.eggsFolder.listFiles()).toList();
        for (File file : files) {
            PluginEgg egg = new PluginEgg(file.getName().replace(".yml", ""));
            this.eggs.add(egg);
        }
        for (PluginEgg egg : this.eggs) {
            egg.initializeRecipe();
        }
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new EggListener(), (Plugin)this.plugin);
    }

    public static EggManager getEggManager() {
        if (eggManager == null) {
            eggManager = new EggManager();
        }
        return eggManager;
    }

    public PluginEgg getEggByName(String name) {
        for (PluginEgg egg : this.eggs) {
            if (!egg.getName().equalsIgnoreCase(name)) continue;
            return egg;
        }
        return null;
    }

    public List<PluginEgg> getEggs() {
        return this.eggs;
    }

    public PluginEgg getEggByPDC(Projectile entity) {
        if (!(entity instanceof Egg)) {
            return null;
        }
        Egg egg = (Egg)entity;
        ItemStack item = egg.getItem();
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        for (PluginEgg pluginEgg : this.eggs) {
            if (!pdc.has(pluginEgg.getKey())) continue;
            return pluginEgg;
        }
        return null;
    }

    public PluginEgg getEggByPDC(ItemStack item) {
        if (item.getType() != Material.EGG) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        for (PluginEgg pluginEgg : this.eggs) {
            if (!pdc.has(pluginEgg.getKey())) continue;
            return pluginEgg;
        }
        return null;
    }
}

