/*
 * Decompiled with CFR 0.152.
 */
package de.j.deathMinigames.database;

import com.zaxxer.hikari.HikariDataSource;
import de.chojo.sadu.datasource.DataSourceCreator;
import de.chojo.sadu.mapper.RowMapperRegistry;
import de.chojo.sadu.postgresql.databases.PostgreSql;
import de.chojo.sadu.postgresql.jdbc.PostgreSqlJdbc;
import de.chojo.sadu.postgresql.mapper.PostgresqlMapper;
import de.chojo.sadu.queries.api.configuration.QueryConfiguration;
import de.j.deathMinigames.database.PlayerDataDatabase;
import de.j.deathMinigames.main.Config;
import de.j.stationofdoom.main.Main;
import java.util.HashMap;
import javax.sql.DataSource;

public class Database {
    private static Database instance;
    private HikariDataSource dataSource;
    private int port;
    private String host;
    private String database;
    private String user;
    private String password;
    private String applicationName;
    private String schema;
    public volatile boolean isConnected = false;

    private Database() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Database getInstance() {
        if (instance != null) return instance;
        Class<Database> clazz = Database.class;
        synchronized (Database.class) {
            if (instance != null) return instance;
            instance = new Database();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initDatabase() {
        if (this.checkIfConnectionInfoIsNotEntered()) {
            Main.getMainLogger().info("Database connection information is not completely entered, running without one");
            return;
        }
        this.setConnectionInfo();
        try {
            this.dataSource = DataSourceCreator.create((de.chojo.sadu.core.databases.Database)PostgreSql.get()).configure(config -> ((PostgreSqlJdbc)((PostgreSqlJdbc)((PostgreSqlJdbc)((PostgreSqlJdbc)((PostgreSqlJdbc)config.host(this.host)).port(this.port)).database(this.database)).user(this.user)).password(this.password)).currentSchema(this.schema).applicationName(this.applicationName)).create().withMaximumPoolSize(3).withMinimumIdle(1).build();
            Main.getMainLogger().info("Database connected");
            this.isConnected = true;
            this.configureDefaultQuery();
            PlayerDataDatabase.getInstance().createTable();
            Main.getMainLogger().info("Database initialized");
        }
        catch (Exception e) {
            Main.getMainLogger().info("No database found, running without one");
        }
    }

    private void configureDefaultQuery() {
        QueryConfiguration config = QueryConfiguration.builder((DataSource)this.dataSource).setExceptionHandler(err -> Main.getMainLogger().warning(err.getMessage())).setThrowExceptions(true).setAtomic(true).setRowMapperRegistry(new RowMapperRegistry().register(PostgresqlMapper.getDefaultMapper())).build();
        QueryConfiguration.setDefault((QueryConfiguration)config);
    }

    private boolean checkIfConnectionInfoIsNotEntered() {
        return Config.getInstance().getDatabaseConfig().containsValue("default");
    }

    private void setConnectionInfo() {
        HashMap<String, String> connectionInfo = Config.getInstance().getDatabaseConfig();
        if (!this.validateConnectionInfo(connectionInfo)) {
            Main.getMainLogger().warning("Invalid database connection information, running without one");
            return;
        }
        this.port = Integer.parseInt(connectionInfo.get("port"));
        this.host = connectionInfo.get("host");
        this.database = connectionInfo.get("database");
        this.user = connectionInfo.get("user");
        this.password = connectionInfo.get("password");
        this.applicationName = connectionInfo.get("applicationName");
        this.schema = connectionInfo.get("schema");
    }

    private boolean validateConnectionInfo(HashMap<String, String> connectionInfo) {
        String[] required;
        if (connectionInfo == null) {
            return false;
        }
        for (String key : required = new String[]{"port", "host", "database", "user", "password", "applicationName", "schema"}) {
            if (connectionInfo.containsKey(key) && connectionInfo.get(key) != null) continue;
            return false;
        }
        try {
            Integer.parseInt(connectionInfo.get("port"));
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

