/*
 * Decompiled with CFR 0.152.
 */
package de.j.deathMinigames.listeners;

import de.j.deathMinigames.dmUtil.DmUtil;
import de.j.deathMinigames.main.HandlePlayers;
import de.j.deathMinigames.main.PlayerData;
import de.j.deathMinigames.main.PlayerMinigameStatus;
import de.j.deathMinigames.minigames.Minigame;
import de.j.stationofdoom.main.Main;
import de.j.stationofdoom.util.translations.TranslationFactory;
import java.time.Duration;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.title.Title;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class RespawnListener
implements Listener {
    private volatile BukkitTask task;
    private TranslationFactory tf = new TranslationFactory();

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        PlayerData playerData = HandlePlayers.getKnownPlayers().get(player.getUniqueId());
        if (playerData == null) {
            Main.getMainLogger().warning("PlayerData of player " + player.getName() + " is null!");
            return;
        }
        player.getInventory().clear();
        playerData.setStatus(PlayerMinigameStatus.ALIVE);
        if (!playerData.getUsesPlugin()) {
            return;
        }
        if (playerData.getDecisionTimer() == 0) {
            playerData.setDecisionTimerDefault();
        }
        if (!playerData.getLastDeathInventory().isEmpty()) {
            playerData.setStatus(PlayerMinigameStatus.DECIDING);
            this.handleTimerWhilePlayerDecides(player);
        }
    }

    public void handleTimerWhilePlayerDecides(Player player) {
        player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)this.tf.getTranslation(player, "decision")).color((TextColor)NamedTextColor.GOLD)).append(((TextComponent)((TextComponent)Component.text((String)this.tf.getTranslation(player, "playMinigame")).decorate(TextDecoration.UNDERLINED)).color((TextColor)NamedTextColor.GREEN)).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)"/game start")))).append(Component.text((String)" / ").color((TextColor)NamedTextColor.GOLD))).append(((TextComponent)((TextComponent)Component.text((String)this.tf.getTranslation(player, "ignoreMinigame")).decorate(TextDecoration.UNDERLINED)).color((TextColor)NamedTextColor.RED)).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)"/game ignore"))));
        this.timerWhilePlayerDecides(player);
    }

    private void timerWhilePlayerDecides(final Player player) {
        final DmUtil util = DmUtil.getInstance();
        if (!util.validatePlayerAndPlayerData(player)) {
            Main.getMainLogger().warning("Player is null or playerData is null!");
            return;
        }
        UUID uuidPlayer = player.getUniqueId();
        final PlayerData playerData = HandlePlayers.getKnownPlayers().get(uuidPlayer);
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                if (RespawnListener.this.handlePlayerOffline(player, playerData)) {
                    return;
                }
                if (RespawnListener.this.handlePlayerNotDeciding(playerData)) {
                    return;
                }
                int decisionTimer = playerData.getDecisionTimer();
                switch (decisionTimer) {
                    case 0: {
                        RespawnListener.this.handleTimer0(playerData, player, util, RespawnListener.this.tf);
                        return;
                    }
                    case -1: {
                        Main.getMainLogger().warning("Timer is below 0, stopping timer!");
                        RespawnListener.this.getTask().cancel();
                        return;
                    }
                }
                Title.Times times = Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(1L), (Duration)Duration.ofMillis(500L));
                Title title = Title.title((Component)Component.text((String)RespawnListener.this.tf.getTranslation(player, "decideInChat")).color((TextColor)NamedTextColor.GOLD), (Component)MiniMessage.miniMessage().deserialize((Object)Component.text((String)RespawnListener.this.tf.getTranslation(player, "decideTime", decisionTimer)).content()), (Title.Times)times);
                player.showTitle(title);
                playerData.setDecisionTimer(decisionTimer - 1);
            }
        };
        this.task = runnable.runTaskTimer((Plugin)Main.getPlugin(), 0L, 20L);
    }

    private boolean handlePlayerOffline(Player player, PlayerData playerData) {
        if (!player.isOnline()) {
            playerData.setLeftWhileProcessing(true);
            Minigame.getInstance().dropInvAndClearData(player);
            Main.getMainLogger().info("Player" + playerData.getName() + "is offline and timerWhilePlayerDecides is stopped");
            this.getTask().cancel();
            return true;
        }
        return false;
    }

    private boolean handlePlayerNotDeciding(PlayerData playerData) {
        if (!playerData.getStatus().equals((Object)PlayerMinigameStatus.DECIDING)) {
            playerData.resetDecisionTimerAndStatus();
            this.getTask().cancel();
            return true;
        }
        return false;
    }

    private void handleTimer0(PlayerData playerData, Player player, DmUtil util, TranslationFactory tf) {
        if (playerData == null) {
            throw new NullPointerException("playerData is null!");
        }
        if (playerData.getLastDeathLocation() == null) {
            Main.getMainLogger().warning("DeathLocation of player is null and timer is stopped!");
            this.getTask().cancel();
            return;
        }
        Location deathLocation = playerData.getLastDeathLocation();
        player.sendTitle("", tf.getTranslation(player, "droppingInvAt2"), 10, 40, 10);
        player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)new TranslationFactory().getTranslation(player, "deathpoint")).color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)("X: " + deathLocation.getBlockX() + " ")).color((TextColor)NamedTextColor.RED))).append(Component.text((String)("Y: " + deathLocation.getBlockY() + " ")).color((TextColor)NamedTextColor.RED))).append(Component.text((String)("Z: " + deathLocation.getBlockZ())).color((TextColor)NamedTextColor.RED)));
        util.dropInv(player, deathLocation);
        playerData.resetDecisionTimerAndStatus();
        this.getTask().cancel();
    }

    public BukkitTask getTask() {
        return this.task;
    }
}

