/*
 * Decompiled with CFR 0.152.
 */
package de.j.deathMinigames.main;

import de.j.stationofdoom.enchants.CustomEnchantsEnum;
import de.j.stationofdoom.main.Main;
import de.j.stationofdoom.util.Tablist;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;

public class Config {
    private static volatile Config instance;
    private static volatile boolean configSetUp;
    private static volatile int configParkourStartHeight;
    private static final int configParkourStartHeightDefault = 100;
    private static volatile int configParkourLength;
    private static final int configParkourLengthDefault = 10;
    private static volatile int configCostToLowerTheDifficulty;
    private static final int configCostToLowerTheDifficultyDefault = 6;
    private static volatile int configTimeToDecideWhenRespawning;
    private static final int configTimeToDecideWhenRespawningDefault = 10;
    private static volatile Location configWaitingListPosition;

    private Config() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Config getInstance() {
        if (instance != null) return instance;
        Class<Config> clazz = Config.class;
        synchronized (Config.class) {
            if (instance != null) return instance;
            instance = new Config();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initializeConfig() {
        this.cloneConfigToPlugin();
    }

    public void cloneConfigToPlugin() {
        FileConfiguration config = Main.getPlugin().getConfig();
        this.handleCloneSetUp(config);
        this.handleCloneDatabase(config);
        this.handleCloneTablist(config);
        this.handleCloneCustomEnchants(config);
    }

    private void handleCloneSetUp(FileConfiguration config) {
        boolean setUp = true;
        if (config.contains("ParkourStartHeight")) {
            this.setParkourStartHeight(config.getInt("ParkourStartHeight"));
        } else {
            this.setParkourStartHeight(100);
            setUp = false;
        }
        if (config.contains("ParkourLength")) {
            this.setParkourLength(config.getInt("ParkourLength"));
        } else {
            this.setParkourLength(10);
            setUp = false;
        }
        if (config.contains("CostToLowerTheDifficulty")) {
            this.setCostToLowerTheDifficulty(config.getInt("CostToLowerTheDifficulty"));
        } else {
            this.setCostToLowerTheDifficulty(6);
            setUp = false;
        }
        if (config.contains("TimeToDecideWhenRespawning")) {
            this.setTimeToDecideWhenRespawning(config.getInt("TimeToDecideWhenRespawning"));
        } else {
            this.setTimeToDecideWhenRespawning(10);
            setUp = false;
        }
        configSetUp = setUp;
    }

    private void handleCloneDatabase(FileConfiguration config) {
        if (!config.contains("Database")) {
            config.set("Database.host", (Object)"default");
            config.set("Database.port", (Object)"default");
            config.set("Database.user", (Object)"default");
            config.set("Database.database", (Object)"default");
            config.set("Database.password", (Object)"default");
            config.set("Database.applicationName", (Object)"default");
            config.set("Database.schema", (Object)"public");
            Main.getPlugin().saveConfig();
        }
    }

    private void handleCloneTablist(FileConfiguration config) {
        if (config.contains("Tablist")) {
            if (config.contains("Tablist.ServerName") && config.get("Tablist.ServerName") != null) {
                Tablist.setServerName(config.getString("Tablist.ServerName"));
            }
            if (config.contains("Tablist.HostedBy") && config.get("Tablist.HostedBy") != null) {
                Tablist.setHostedBy(config.getString("Tablist.HostedBy"));
            }
        }
    }

    private void handleCloneCustomEnchants(FileConfiguration config) {
        if (config.contains("CustomEnchants")) {
            for (CustomEnchantsEnum customEnchantsEnum : CustomEnchantsEnum.values()) {
                try {
                    boolean customEnchantBool = config.getBoolean("CustomEnchants." + customEnchantsEnum.name());
                    customEnchantsEnum.setEnabled(customEnchantBool);
                }
                catch (Exception e) {
                    Main.getMainLogger().warning("Setting value for custom enchantment " + customEnchantsEnum.name() + " failed. Falling back to default true value.");
                    e.printStackTrace();
                    customEnchantsEnum.setEnabled(true);
                }
            }
        } else {
            config.createSection("CustomEnchants");
            for (CustomEnchantsEnum customEnchantsEnum : CustomEnchantsEnum.values()) {
                config.set("CustomEnchants." + customEnchantsEnum.name(), (Object)true);
                customEnchantsEnum.setEnabled(true);
            }
            Main.getPlugin().saveConfig();
        }
    }

    public void cloneWaitingListLocationToPlugin(World world) {
        if (world == null) {
            Main.getMainLogger().severe("Ca not set waitingListLocation because world is null!");
            return;
        }
        if (Main.getPlugin().getConfig().contains("WaitingListPosition")) {
            int x = Main.getPlugin().getConfig().getInt("WaitingListPosition.x");
            int y = Main.getPlugin().getConfig().getInt("WaitingListPosition.y");
            int z = Main.getPlugin().getConfig().getInt("WaitingListPosition.z");
            configWaitingListPosition = new Location(world, (double)x, (double)y, (double)z);
            Main.getMainLogger().info("set WaitingListPosition from config to: " + configWaitingListPosition.getBlockX() + ", " + configWaitingListPosition.getBlockY() + ", " + configWaitingListPosition.getBlockZ());
        } else {
            Main.getMainLogger().warning("WaitingListPosition not found in config!");
        }
    }

    public synchronized void setParkourStartHeight(int height) {
        configParkourStartHeight = height;
        Main.getPlugin().getConfig().set("ParkourStartHeight", (Object)height);
        Main.getPlugin().saveConfig();
    }

    public synchronized void setParkourLength(int length) {
        configParkourLength = length;
        Main.getPlugin().getConfig().set("ParkourLength", (Object)length);
        Main.getPlugin().saveConfig();
    }

    public synchronized void setCostToLowerTheDifficulty(int cost) {
        configCostToLowerTheDifficulty = cost;
        Main.getPlugin().getConfig().set("CostToLowerTheDifficulty", (Object)cost);
        Main.getPlugin().saveConfig();
    }

    public synchronized void setTimeToDecideWhenRespawning(int time) {
        configTimeToDecideWhenRespawning = time;
        Main.getPlugin().getConfig().set("TimeToDecideWhenRespawning", (Object)time);
        Main.getPlugin().saveConfig();
    }

    public synchronized void setWaitingListPosition(Location location) {
        if (location == null) {
            throw new NullPointerException("location is null!");
        }
        configWaitingListPosition = location;
        Main.getPlugin().getConfig().set("WaitingListPosition.x", (Object)location.getBlockX());
        Main.getPlugin().getConfig().set("WaitingListPosition.y", (Object)location.getBlockY());
        Main.getPlugin().getConfig().set("WaitingListPosition.z", (Object)location.getBlockZ());
        Main.getPlugin().saveConfig();
        Main.getMainLogger().info("set WaitingListPosition to: " + String.valueOf(configWaitingListPosition));
    }

    public boolean checkSetUp() {
        return configSetUp;
    }

    public int checkParkourStartHeight() {
        return configParkourStartHeight;
    }

    public int checkParkourLength() {
        return configParkourLength;
    }

    public int checkCostToLowerTheDifficulty() {
        return configCostToLowerTheDifficulty;
    }

    public int checkTimeToDecideWhenRespawning() {
        return configTimeToDecideWhenRespawning;
    }

    public Location checkWaitingListLocation() {
        if (configWaitingListPosition != null) {
            return configWaitingListPosition;
        }
        Main.getMainLogger().warning("configWaitingListPosition is not setup");
        return null;
    }

    public HashMap<String, String> getDatabaseConfig() {
        String[] requiredFields;
        HashMap<String, String> databaseConnectionInfo = new HashMap<String, String>();
        FileConfiguration config = Main.getPlugin().getConfig();
        for (String field : requiredFields = new String[]{"host", "port", "database", "user", "password", "applicationName", "schema"}) {
            String value = config.getString("Database." + field);
            if (value == null || value.equals("default")) {
                Main.getMainLogger().warning("Database." + field + " is not configured properly");
            }
            databaseConnectionInfo.put(field, value);
        }
        return databaseConnectionInfo;
    }

    public synchronized void setServerName(String serverName) {
        if (serverName == null) {
            Main.getMainLogger().warning("ServerName is null!");
            return;
        }
        if (!Main.getPlugin().getConfig().contains("Tablist.ServerName")) {
            Main.getPlugin().getConfig().set("Tablist.ServerName", (Object)serverName);
            Main.getPlugin().saveConfig();
        } else if (!Main.getPlugin().getConfig().getString("Tablist.ServerName").equals(serverName)) {
            Main.getPlugin().getConfig().set("Tablist.ServerName", (Object)serverName);
            Main.getPlugin().saveConfig();
        }
    }

    public String getServerName() {
        if (Main.getPlugin().getConfig().contains("Tablist.ServerName")) {
            return Main.getPlugin().getConfig().getString("Tablist.ServerName");
        }
        Main.getMainLogger().warning("ServerName not found in config!");
        return null;
    }

    public synchronized void setHostedBy(String serverName) {
        if (!Main.getPlugin().getConfig().contains("Tablist.HostedBy") || !Main.getPlugin().getConfig().getString("Tablist.HostedBy").equals(serverName)) {
            Main.getPlugin().getConfig().set("Tablist.HostedBy", (Object)serverName);
            Main.getPlugin().saveConfig();
        }
    }

    public String getHostedBy() {
        if (Main.getPlugin().getConfig().contains("Tablist.HostedBy")) {
            return Main.getPlugin().getConfig().getString("Tablist.HostedBy");
        }
        Main.getMainLogger().warning("HostedBy not found in config!");
        return null;
    }
}

