/*
 * Decompiled with CFR 0.152.
 */
package de.j.deathMinigames.minigames;

import de.j.deathMinigames.dmUtil.DmUtil;
import de.j.deathMinigames.main.Config;
import de.j.deathMinigames.main.HandlePlayers;
import de.j.deathMinigames.main.PlayerData;
import de.j.deathMinigames.main.PlayerMinigameStatus;
import de.j.deathMinigames.minigames.Minigame;
import de.j.deathMinigames.minigames.ParkourTimer;
import de.j.stationofdoom.main.Main;
import de.j.stationofdoom.util.translations.TranslationFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class JumpAndRun {
    private static volatile JumpAndRun jumpAndRun;
    private volatile BukkitTask task;
    private boolean running = false;
    private ArrayList<Block> blocksToDelete = new ArrayList();
    private boolean woolPlaced = false;
    private boolean goldPlaced = false;
    private int _x = 0;
    private int _y = 0;
    private int _z = 0;

    private JumpAndRun() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JumpAndRun getInstance() {
        if (jumpAndRun != null) return jumpAndRun;
        Class<JumpAndRun> clazz = JumpAndRun.class;
        synchronized (JumpAndRun.class) {
            if (jumpAndRun != null) return jumpAndRun;
            jumpAndRun = new JumpAndRun();
            // ** MonitorExit[var0] (shouldn't be in output)
            return jumpAndRun;
        }
    }

    public BukkitTask getTask() {
        return this.task;
    }

    public boolean getRunning() {
        return this.running;
    }

    public void start() {
        Minigame mg = Minigame.getInstance();
        Config config = Config.getInstance();
        TranslationFactory tf = new TranslationFactory();
        if (HandlePlayers.waitingListMinigame.isEmpty()) {
            Main.getMainLogger().warning("No player in the waiting list!");
            return;
        }
        Player playerInArena = HandlePlayers.waitingListMinigame.getFirst();
        PlayerData playerData = HandlePlayers.getKnownPlayers().get(playerInArena.getUniqueId());
        if (playerData == null) {
            return;
        }
        playerData.setStatus(PlayerMinigameStatus.IN_MINIGAME);
        this.running = true;
        playerInArena.sendTitle("JumpNRun", "");
        World w = playerInArena.getWorld();
        Location spawnLocation = w.getSpawnLocation();
        Location firstBlockPlayerTPLocation = new Location(playerInArena.getWorld(), (double)spawnLocation.getBlockX() + 0.5, (double)(config.checkParkourStartHeight() + 1), (double)spawnLocation.getBlockZ() + 0.5);
        playerInArena.teleport(firstBlockPlayerTPLocation);
        mg.sendStartMessage(playerInArena, tf.getTranslation(playerInArena, "introParkour"));
        ParkourTimer.startTimer(playerInArena);
        int heightToWin = config.checkParkourStartHeight() + config.checkParkourLength();
        Location firstBlock = firstBlockPlayerTPLocation;
        firstBlock.setY(firstBlockPlayerTPLocation.getY() - 1.0);
        firstBlock.getBlock().setType(Material.GREEN_CONCRETE);
        this.blocksToDelete.add(firstBlock.getBlock());
        this.parkourGenerator(firstBlock, heightToWin, playerInArena);
    }

    private boolean checkIfOnConcrete(Player player) {
        Location block = player.getLocation();
        block.setY((double)(block.getBlockY() - 1));
        return block.getBlock().getType() == Material.GREEN_CONCRETE;
    }

    private int randomizer(int min, int max) {
        if (min == max + 1) {
            return min;
        }
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }

    private boolean checkIfPlayerWon(Player player) {
        Minigame mg = Minigame.getInstance();
        TranslationFactory tf = new TranslationFactory();
        PlayerData playerData = HandlePlayers.getKnownPlayers().get(player.getUniqueId());
        if (this.checkIfOnGold(player)) {
            mg.sendWinMessage(player);
            mg.showInv(player);
            float timer = ParkourTimer.getTimer();
            ParkourTimer.stopTimer();
            if (playerData.getBestParkourTime() == 1000.0f) {
                playerData.setBestParkourTime(timer);
            }
            if (timer < playerData.getBestParkourTime()) {
                float timerDifference = playerData.getBestParkourTime() - timer;
                player.sendMessage(Component.text((String)tf.getTranslation(player, "newRecord", Float.valueOf(new BigDecimal(timerDifference).setScale(2, RoundingMode.HALF_UP).floatValue()))).color((TextColor)NamedTextColor.GREEN));
                DmUtil.getInstance().playSoundAtLocation(player.getLocation(), Float.valueOf(0.8f), Sound.ENTITY_PLAYER_LEVELUP);
                playerData.setBestParkourTime(timer);
            }
            ParkourTimer.resetTimer();
            this.clearBlocks(player);
            return true;
        }
        return false;
    }

    private boolean checkIfPlayerLost(Player player, int heightToLose) {
        Minigame mg = Minigame.getInstance();
        if (player.getLocation().getBlockY() <= heightToLose) {
            ParkourTimer.stopTimer();
            ParkourTimer.resetTimer();
            mg.sendLoseMessage(player);
            mg.dropInvAndClearData(player);
            mg.tpPlayerToRespawnLocation(player);
            mg.playSoundToPlayer(player, Float.valueOf(0.5f), Sound.ENTITY_ITEM_BREAK);
            this.clearBlocks(player);
            return true;
        }
        return false;
    }

    private void replaceWoolWithConcrete(final Player player) {
        new BukkitRunnable(){

            public void run() {
                if (JumpAndRun.this.checkIfOnWool(player)) {
                    Location block = player.getLocation();
                    block.setY((double)(block.getBlockY() - 1));
                    block.getBlock().setType(Material.GREEN_CONCRETE);
                    JumpAndRun.this.woolPlaced = false;
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 5L);
    }

    private boolean checkIfOnWool(Player player) {
        Location block = player.getLocation();
        block.setY((double)(block.getBlockY() - 1));
        return block.getBlock().getType() == Material.GREEN_WOOL;
    }

    private boolean checkIfOnGold(Player player) {
        Location block = player.getLocation();
        block.setY((double)(block.getBlockY() - 1));
        return block.getBlock().getType() == Material.GOLD_BLOCK;
    }

    private void parkourGenerator(Location firstBLock, final int heightToWin, final Player playerInArena) {
        final Minigame mg = Minigame.getInstance();
        Config config = Config.getInstance();
        final DmUtil util = DmUtil.getInstance();
        final int heightToLose = config.checkParkourStartHeight() - 2;
        final Location nextBlock = firstBLock;
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                if (JumpAndRun.this.checkIfPlayerWon(playerInArena) || JumpAndRun.this.checkIfPlayerLost(playerInArena, heightToLose) || JumpAndRun.this.checkIfPlayerLeft(playerInArena)) {
                    Main.getMainLogger().info("Removed " + HandlePlayers.waitingListMinigame.getFirst().getName() + " from waiting list");
                    HandlePlayers.waitingListMinigame.remove(playerInArena);
                    JumpAndRun.this.running = false;
                    if (!HandlePlayers.waitingListMinigame.isEmpty()) {
                        Main.getMainLogger().info("Started new minigame with: " + HandlePlayers.waitingListMinigame.getFirst().getName());
                        Minigame.getInstance().minigameStart(HandlePlayers.waitingListMinigame.getFirst());
                    }
                    this.cancel();
                } else {
                    List<Integer> values = JumpAndRun.this.setValuesBasedOnDifficulty(playerInArena);
                    int minX = values.getFirst();
                    int minZ = values.get(1);
                    int maxX = values.get(2);
                    int maxZ = values.get(3);
                    int maxDifficulty = values.getLast();
                    if (JumpAndRun.this.checkIfOnConcrete(playerInArena) && !JumpAndRun.this.woolPlaced) {
                        JumpAndRun.this._x = JumpAndRun.this.randomizer(minX, maxX);
                        JumpAndRun.this._z = JumpAndRun.this.randomizer(minZ, maxZ);
                        int randomNum = JumpAndRun.this.randomizer(1, maxDifficulty);
                        JumpAndRun.this._x = JumpAndRun.this.coordinatesRandomizerCasesX(JumpAndRun.this._x, randomNum);
                        JumpAndRun.this._z = JumpAndRun.this.coordinatesRandomizerCasesZ(JumpAndRun.this._z, randomNum);
                        JumpAndRun.this._x = playerInArena.getLocation().getBlockX() + JumpAndRun.this._x;
                        JumpAndRun.this._y = playerInArena.getLocation().getBlockY();
                        JumpAndRun.this._z = playerInArena.getLocation().getBlockZ() + JumpAndRun.this._z;
                        nextBlock.set((double)JumpAndRun.this._x, (double)JumpAndRun.this._y, (double)JumpAndRun.this._z);
                        if (JumpAndRun.this._y == heightToWin && !JumpAndRun.this.goldPlaced) {
                            nextBlock.getBlock().setType(Material.GOLD_BLOCK);
                            util.playSoundAtLocation(nextBlock, Float.valueOf(2.0f), Sound.BLOCK_AMETHYST_BLOCK_HIT);
                            mg.spawnParticles(playerInArena, nextBlock, Particle.GLOW);
                            JumpAndRun.this.blocksToDelete.add(nextBlock.getBlock());
                            JumpAndRun.this.goldPlaced = true;
                            JumpAndRun.this.woolPlaced = true;
                        } else {
                            nextBlock.getBlock().setType(Material.GREEN_WOOL);
                            util.playSoundAtLocation(nextBlock, Float.valueOf(2.0f), Sound.BLOCK_AMETHYST_BLOCK_HIT);
                            mg.spawnParticles(playerInArena, nextBlock, Particle.GLOW);
                            JumpAndRun.this.woolPlaced = true;
                            JumpAndRun.this.blocksToDelete.add(nextBlock.getBlock());
                        }
                    } else {
                        JumpAndRun.this.replaceWoolWithConcrete(playerInArena);
                    }
                }
            }
        };
        this.task = runnable.runTaskTimer((Plugin)Main.getPlugin(), 0L, 5L);
    }

    private List<Integer> setValuesBasedOnDifficulty(Player playerInArena) {
        int minX = 0;
        int minZ = 0;
        int maxX = 0;
        int maxZ = 0;
        int maxDifficulty = 0;
        PlayerData playerInArenaData = HandlePlayers.getKnownPlayers().get(playerInArena.getUniqueId());
        switch (playerInArenaData.getDifficulty()) {
            case 0: 
            case 1: {
                minX = 1;
                minZ = 1;
                maxX = 2;
                maxZ = 2;
                break;
            }
            case 2: 
            case 3: {
                minX = 1;
                minZ = 1;
                maxX = 3;
                maxZ = 3;
                break;
            }
            case 4: 
            case 5: {
                minX = 2;
                minZ = 2;
                maxX = 3;
                maxZ = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                minX = 3;
                minZ = 3;
                maxX = 3;
                maxZ = 3;
                break;
            }
            case 9: 
            case 10: {
                minX = 3;
                minZ = 3;
                maxX = 3;
                maxZ = 3;
                maxDifficulty = 8;
            }
        }
        return Arrays.asList(minX, minZ, maxX, maxZ, maxDifficulty);
    }

    private int coordinatesRandomizerCasesX(int _x, int cas) {
        switch (cas) {
            case 1: {
                _x *= -1;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                _x *= -1;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                _x = 0;
                break;
            }
            case 6: {
                _x = -4;
                break;
            }
            case 7: {
                _x = 4;
                break;
            }
            case 8: {
                _x = 0;
            }
        }
        return _x;
    }

    private int coordinatesRandomizerCasesZ(int _z, int cas) {
        switch (cas) {
            case 1: {
                _z *= -1;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                _z *= -1;
                break;
            }
            case 5: {
                _z = -4;
                break;
            }
            case 6: {
                _z = 0;
                break;
            }
            case 7: {
                _z = 0;
                break;
            }
            case 8: {
                _z = 4;
            }
        }
        return _z;
    }

    public boolean checkIfPlayerLeft(Player playerInArena) {
        Minigame mg = Minigame.getInstance();
        if (playerInArena.isOnline()) {
            return false;
        }
        this.running = false;
        ParkourTimer.stopTimer();
        ParkourTimer.resetTimer();
        mg.dropInvAndClearData(playerInArena);
        mg.tpPlayerToRespawnLocation(playerInArena);
        this.clearBlocks(playerInArena);
        Main.getMainLogger().info("Player " + playerInArena.getName() + "left the parkour!");
        HandlePlayers.getKnownPlayers().get(playerInArena.getUniqueId()).setLeftWhileProcessing(true);
        Main.getMainLogger().info(HandlePlayers.waitingListMinigame.toString());
        return true;
    }

    private void clearBlocks(Player playerInArena) {
        this.woolPlaced = false;
        this.goldPlaced = false;
        for (Block block : this.blocksToDelete) {
            playerInArena.getWorld().setType(block.getLocation(), Material.AIR);
        }
        this.blocksToDelete.clear();
    }
}

