/*
 * Decompiled with CFR 0.152.
 */
package de.j.stationofdoom.listener;

import de.j.stationofdoom.main.Main;
import de.j.stationofdoom.util.EntityManager;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class BowComboListener
implements Listener {
    private final HashMap<Player, Integer> shooterList = new HashMap();
    private static final String KEY = "HitMarker";

    @EventHandler
    public void onBowShot(EntityShootBowEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!(event.getProjectile() instanceof Arrow)) {
            return;
        }
        this.shooterList.put(player, this.shooterList.getOrDefault(player, 0));
        AsyncScheduler asyncScheduler = Main.getAsyncScheduler();
        asyncScheduler.runDelayed((Plugin)Main.getPlugin(), scheduledTask -> this.shooterList.put(player, this.shooterList.get(player) - 1 >= 0 ? this.shooterList.get(player) : 0), 2L, TimeUnit.SECONDS);
    }

    @EventHandler
    public void onHit(ProjectileHitEvent event) {
        Projectile projectile = event.getEntity();
        if (!(projectile instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)projectile;
        ProjectileSource projectileSource = arrow.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        MiniMessage mm = MiniMessage.miniMessage();
        if (event.getHitBlock() != null) {
            if (this.shooterList.get(player) > 0) {
                this.shooterList.put(player, 0);
                player.sendActionBar(mm.deserialize((Object)("<rainbow>Combo: " + String.valueOf(this.shooterList.get(player)) + "</rainbow>")));
            }
        } else if (event.getHitEntity() != null && event.getHitEntity() != arrow.getShooter()) {
            double dmg = this.calculateDamageMultiplier(this.shooterList.get(player), arrow);
            player.sendActionBar(mm.deserialize((Object)("<rainbow>Combo: " + String.valueOf(this.shooterList.get(player)) + "</rainbow> <green>DMG:" + dmg)));
            arrow.setDamage(dmg);
            this.shooterList.put(player, this.shooterList.containsKey(player) ? this.shooterList.get(player) + 1 : 1);
            ArmorStand armorStand = (ArmorStand)player.getWorld().spawnEntity(event.getEntity().getLocation(), EntityType.ARMOR_STAND);
            armorStand.setVisible(false);
            armorStand.setMarker(true);
            armorStand.customName(((TextComponent)Component.text((String)"\u2720 ").color(TextColor.color((int)255, (int)102, (int)0))).append(Component.text((String)String.valueOf(dmg)).color((TextColor)NamedTextColor.GRAY)));
            armorStand.setCustomNameVisible(true);
            armorStand.setGravity(false);
            armorStand.getPersistentDataContainer().set(new NamespacedKey((Plugin)Main.getPlugin(), KEY), PersistentDataType.BOOLEAN, (Object)true);
            EntityManager.addEntity(new NamespacedKey((Plugin)Main.getPlugin(), KEY), EntityType.ARMOR_STAND);
            AsyncScheduler asyncScheduler = Main.getAsyncScheduler();
            asyncScheduler.runDelayed((Plugin)Main.getPlugin(), scheduledTask -> armorStand.remove(), 1L, TimeUnit.SECONDS);
        }
    }

    private double calculateDamageMultiplier(int combo, Arrow arrow) {
        double dmg = arrow.getDamage();
        double multiplier = 0.25;
        assert (combo >= 0);
        double calc = Math.max(dmg * ((double)(combo - 1) + 0.25), dmg);
        return calc <= dmg + 4.5 ? calc : dmg;
    }
}

