/*
 * Decompiled with CFR 0.152.
 */
package de.j.stationofdoom.main;

import de.j.deathMinigames.commands.GameCMD;
import de.j.deathMinigames.commands.LeaderboardCMD;
import de.j.deathMinigames.database.Database;
import de.j.deathMinigames.listeners.AnvilListener;
import de.j.deathMinigames.listeners.InventoryListener;
import de.j.deathMinigames.listeners.JoinListener;
import de.j.deathMinigames.listeners.LeaveListener;
import de.j.deathMinigames.listeners.RespawnListener;
import de.j.deathMinigames.listeners.SaveItemsOnDeath;
import de.j.deathMinigames.main.Config;
import de.j.deathMinigames.main.HandlePlayers;
import de.j.deathMinigames.main.InitWaitingListLocationOnJoin;
import de.j.stationofdoom.cmd.ChangeLanguageCMD;
import de.j.stationofdoom.cmd.DeathPointCMD;
import de.j.stationofdoom.cmd.GetCustomEnchantsCMD;
import de.j.stationofdoom.cmd.PingCommand;
import de.j.stationofdoom.cmd.StatusCMD;
import de.j.stationofdoom.cmd.VersionCMD;
import de.j.stationofdoom.cmd.VoteRestartCMD;
import de.j.stationofdoom.enchants.FlightEvents;
import de.j.stationofdoom.enchants.FurnaceEvents;
import de.j.stationofdoom.enchants.TelepathyEvents;
import de.j.stationofdoom.listener.AntiSwordDropListener;
import de.j.stationofdoom.listener.Bed;
import de.j.stationofdoom.listener.BowComboListener;
import de.j.stationofdoom.listener.ChatMessagesListener;
import de.j.stationofdoom.listener.EntityDeathListener;
import de.j.stationofdoom.listener.PlayerJoin;
import de.j.stationofdoom.listener.PlayerKillListener;
import de.j.stationofdoom.listener.PlayerQuit;
import de.j.stationofdoom.listener.PlayerSitListener;
import de.j.stationofdoom.util.EntityManager;
import de.j.stationofdoom.util.WhoIsOnline;
import de.j.stationofdoom.util.translations.ChangeLanguageGUI;
import de.j.stationofdoom.util.translations.LanguageChanger;
import de.j.stationofdoom.util.translations.TranslationFactory;
import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Objects;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class Main
extends JavaPlugin {
    private static Main plugin;
    public static String version;

    public void onLoad() {
        plugin = this;
        InputStreamReader in = new InputStreamReader(Objects.requireNonNull(Main.class.getResourceAsStream("/plugin.yml")));
        BufferedReader reader = new BufferedReader(in);
        try {
            String line;
            int lineNumber = 1;
            while ((line = reader.readLine()) != null) {
                if (lineNumber == 2) {
                    version = line.replace("version: ", "");
                    break;
                }
                ++lineNumber;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onEnable() {
        Config config = Config.getInstance();
        config.initializeConfig();
        Database database = Database.getInstance();
        database.initDatabase();
        HandlePlayers.initKnownPlayersPlayerData();
        LifecycleEventManager manager = this.getLifecycleManager();
        manager.registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            Commands COMMANDS = (Commands)event.registrar();
            COMMANDS.register("afk", "", (BasicCommand)new StatusCMD());
            COMMANDS.register("ping", (BasicCommand)new PingCommand());
            COMMANDS.register("plversion", (BasicCommand)new VersionCMD());
            COMMANDS.register("language", (BasicCommand)new ChangeLanguageCMD());
            COMMANDS.register("deathpoint", (BasicCommand)new DeathPointCMD());
            COMMANDS.register("customenchant", (BasicCommand)new GetCustomEnchantsCMD());
            COMMANDS.register("voterestart", (BasicCommand)new VoteRestartCMD());
            COMMANDS.register("sit", (BasicCommand)new PlayerSitListener());
            COMMANDS.register("game", "game related commands", (BasicCommand)new GameCMD());
            COMMANDS.register("leaderboard", "showing the leaderboard of the minigame", (BasicCommand)new LeaderboardCMD());
        });
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)new Bed(), (Plugin)this);
        pluginManager.registerEvents((Listener)new PlayerJoin(), (Plugin)this);
        pluginManager.registerEvents((Listener)new PlayerQuit(), (Plugin)this);
        pluginManager.registerEvents((Listener)new PlayerKillListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new ChatMessagesListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new EntityDeathListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new PlayerSitListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new PlayerSitListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new DeathPointCMD(), (Plugin)this);
        pluginManager.registerEvents((Listener)new TelepathyEvents(), (Plugin)this);
        pluginManager.registerEvents((Listener)new FlightEvents(), (Plugin)this);
        pluginManager.registerEvents((Listener)new AntiSwordDropListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new FurnaceEvents(), (Plugin)this);
        pluginManager.registerEvents((Listener)new ChangeLanguageGUI(), (Plugin)this);
        pluginManager.registerEvents((Listener)new BowComboListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new SaveItemsOnDeath(), (Plugin)this);
        pluginManager.registerEvents((Listener)new RespawnListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new JoinListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new InventoryListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new InitWaitingListLocationOnJoin(), (Plugin)this);
        pluginManager.registerEvents((Listener)new LeaveListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new AnvilListener(), (Plugin)this);
        WhoIsOnline.init();
        TranslationFactory.initTranslations();
        LanguageChanger.init();
    }

    public void onDisable() {
        EntityManager.removeOldEntities();
        WhoIsOnline.shutdown();
        HandlePlayers.copyAllPlayerDataIntoDatabase();
    }

    public static Main getPlugin() {
        return plugin;
    }

    public static Logger getMainLogger() {
        return Main.getPlugin().getLogger();
    }

    public static boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static AsyncScheduler getAsyncScheduler() {
        return Main.getPlugin().getServer().getAsyncScheduler();
    }

    public static GlobalRegionScheduler getGlobalRegionScheduler() {
        return Main.getPlugin().getServer().getGlobalRegionScheduler();
    }
}

