/*
 * Decompiled with CFR 0.152.
 */
package de.j.deathMinigames.commands;

import de.j.deathMinigames.dmUtil.DmUtil;
import de.j.deathMinigames.main.Config;
import de.j.deathMinigames.main.HandlePlayers;
import de.j.deathMinigames.main.Introduction;
import de.j.deathMinigames.main.PlayerData;
import de.j.deathMinigames.main.PlayerMinigameStatus;
import de.j.deathMinigames.minigames.Difficulty;
import de.j.deathMinigames.minigames.Minigame;
import de.j.deathMinigames.settings.MainMenu;
import de.j.stationofdoom.util.translations.TranslationFactory;
import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GameCMD
implements BasicCommand {
    private final Difficulty difficulty = Difficulty.getInstance();
    private final Minigame minigame = Minigame.getInstance();
    private final Introduction introduction = new Introduction();
    private final MainMenu mainMenu = new MainMenu();
    private final Config config = Config.getInstance();
    private final TranslationFactory tf = new TranslationFactory();

    public boolean canUse(@NotNull CommandSender sender) {
        return sender instanceof Player;
    }

    public void execute(CommandSourceStack stack, String[] args) {
        if (stack == null) {
            throw new NullPointerException("stack is null!");
        }
        if (args == null) {
            throw new NullPointerException("args is null!");
        }
        Player player = (Player)stack.getSender();
        if (player == null) {
            throw new NullPointerException("player is null!");
        }
        PlayerData playerData = HandlePlayers.getKnownPlayers().get(player.getUniqueId());
        if (playerData == null) {
            throw new NullPointerException("playerData is null!");
        }
        String arg0 = args.length > 0 ? args[0].toLowerCase() : "";
        String arg1 = null;
        if (args.length > 1) {
            arg1 = args[1].toLowerCase();
        }
        String arg2 = null;
        if (args.length > 2) {
            arg2 = args[2].toLowerCase();
        }
        switch (args.length) {
            case 0: {
                player.sendMessage(Component.text((String)this.tf.getTranslation(player, "cmdUsage")).color((TextColor)NamedTextColor.RED));
                break;
            }
            case 1: {
                this.handleArgsLength1Execution(playerData, player, arg0);
                break;
            }
            case 2: {
                this.handleArgsLength2Execution(playerData, player, arg0, arg1);
                break;
            }
            case 3: {
                this.handleArgsLength3Execution(player, arg0, arg1, arg2);
                break;
            }
            default: {
                player.sendMessage(Component.text((String)this.tf.getTranslation(player, "cmdUsage")).color((TextColor)NamedTextColor.RED));
            }
        }
    }

    private void handleArgsLength1Execution(PlayerData playerData, Player player, String arg0) {
        ArgsLength1 arg0AsEnumType = null;
        try {
            arg0AsEnumType = ArgsLength1.valueOf(arg0.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(Component.text((String)this.tf.getTranslation(player, "cmdUsageLength1")).color((TextColor)NamedTextColor.RED));
        }
        if (arg0AsEnumType == null) {
            return;
        }
        switch (arg0AsEnumType.ordinal()) {
            case 0: {
                this.handleArgsLength1SettingsExecution(player);
                break;
            }
            case 1: {
                this.handleArgsLength1LowerDifficultyExecution(playerData, player);
                break;
            }
            case 2: {
                this.handleArgsLength1IntroPlayerDecidesToUseFeaturesExecution(playerData, player);
                break;
            }
            case 3: {
                this.handleArgsLength1IntroPlayerDecidesToNotUseFeaturesExecution(playerData, player);
                break;
            }
            case 4: {
                playerData.setIntroduction(false);
                break;
            }
            case 5: {
                player.sendMessage(((TextComponent)Component.text((String)this.tf.getTranslation(player, "diffAt")).color((TextColor)NamedTextColor.GOLD)).append(Component.text((int)playerData.getDifficulty()).color((TextColor)NamedTextColor.RED)));
                break;
            }
            case 6: {
                this.handleArgsLength1SetWaitingListPositionExecution(player);
                break;
            }
            case 7: {
                player.sendMessage(Component.text((String)this.tf.getTranslation(player, "decidedNotToSetPosition")).color((TextColor)NamedTextColor.RED));
                break;
            }
            case 8: {
                player.sendMessage("Status: " + playerData.getStatus().toString());
                break;
            }
            default: {
                this.handleDecisionCMDsWhenRespawning(playerData, player, arg0AsEnumType);
            }
        }
    }

    private void handleDecisionCMDsWhenRespawning(PlayerData playerData, Player player, ArgsLength1 arg0) {
        if (!playerData.getLastDeathInventory().isEmpty() && playerData.getStatus() != PlayerMinigameStatus.IN_MINIGAME && playerData.getStatus() != PlayerMinigameStatus.IN_WAITING_LIST) {
            switch (arg0.ordinal()) {
                case 9: {
                    this.handleArgsLength1StartExecution(player);
                    break;
                }
                case 10: {
                    this.handleArgsLength1IgnoreExecution(player);
                    break;
                }
                default: {
                    if (playerData.getIntroduction()) break;
                    player.sendMessage(Component.text((String)this.tf.getTranslation(player, "cmdUsageLength1")).color((TextColor)NamedTextColor.RED));
                }
            }
        }
    }

    private void handleArgsLength2Execution(PlayerData playerData, Player player, String arg0, String arg1) {
        ArgsLength1 arg0AsEnumType = null;
        try {
            arg0AsEnumType = ArgsLength1.valueOf(arg0.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(Component.text((String)this.tf.getTranslation(player, "cmdUsageLength1")).color((TextColor)NamedTextColor.RED));
        }
        if (arg0AsEnumType == null) {
            return;
        }
        if (player.isOp()) {
            switch (arg0AsEnumType.ordinal()) {
                case 5: {
                    this.handleArgsLength2DifficultyExecution(playerData, player, arg1);
                    break;
                }
                case 2: {
                    playerData.setUsesPlugin(true);
                    break;
                }
                case 3: {
                    playerData.setUsesPlugin(false);
                }
            }
        } else {
            player.sendMessage(Component.text((String)this.tf.getTranslation(player, "playerNotOP")).color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleArgsLength3Execution(Player player, String arg0, String arg1, String arg2) {
        ArgsLength1 arg0AsEnumType = null;
        try {
            arg0AsEnumType = ArgsLength1.valueOf(arg0.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(Component.text((String)this.tf.getTranslation(player, "cmdUsageLength1")).color((TextColor)NamedTextColor.RED));
        }
        if (arg0AsEnumType == null) {
            return;
        }
        if (player.isOp()) {
            switch (arg0AsEnumType.ordinal()) {
                case 5: {
                    this.handleArgsLength3DifficultyExecution(player, arg1, arg2);
                    break;
                }
                case 2: {
                    this.handleArgsLength3IntroPlayerDecidesToUseFeaturesExecution(player, arg1);
                    break;
                }
                case 3: {
                    this.handleArgsLength3introPlayerDecidesToNotUseFeaturesExecution(player, arg1);
                }
            }
        } else {
            player.sendMessage(Component.text((String)this.tf.getTranslation(player, "playerNotOP")).color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleArgsLength1SettingsExecution(Player player) {
        if (player.isOp()) {
            this.mainMenu.showPlayerSettings(player);
        } else {
            player.sendMessage(Component.text((String)this.tf.getTranslation(player, "playerNotOP")).color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleArgsLength1LowerDifficultyExecution(PlayerData playerData, Player player) {
        DmUtil util = DmUtil.getInstance();
        if (this.difficulty.checkIfPlayerCanPay(player)) {
            int diff = playerData.getDifficulty();
            if (diff > 0) {
                this.difficulty.removePaymentFromPlayerInventory(player);
                this.difficulty.lowerDifficulty(player);
                util.playSoundAtLocation(player.getEyeLocation(), Float.valueOf(0.5f), Sound.ENTITY_ENDER_EYE_DEATH);
                player.sendMessage(MiniMessage.miniMessage().deserialize((Object)Component.text((String)this.tf.getTranslation(player, "changedDiff", diff)).content()));
            } else {
                player.sendMessage(((TextComponent)Component.text((String)this.tf.getTranslation(player, "diffAlreadyAt")).color((TextColor)NamedTextColor.GOLD)).append(Component.text((int)diff).color((TextColor)NamedTextColor.RED)));
            }
        } else {
            player.sendMessage(Component.text((String)this.tf.getTranslation(player, "notEnoughResources")).color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleArgsLength1IntroPlayerDecidesToUseFeaturesExecution(PlayerData playerData, Player player) {
        if (!playerData.getIntroduction()) {
            playerData.setIntroduction(true);
            playerData.setUsesPlugin(true);
            Minigame.getInstance().minigameStart(player);
            player.sendMessage(Component.text((String)this.tf.getTranslation(player, "playerDecided")).color((TextColor)NamedTextColor.GOLD));
        } else {
            player.sendMessage(Component.text((String)this.tf.getTranslation(player, "playerAlreadyDecided")).color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleArgsLength1IntroPlayerDecidesToNotUseFeaturesExecution(PlayerData playerData, Player player) {
        DmUtil util = DmUtil.getInstance();
        if (!playerData.getIntroduction()) {
            playerData.setIntroduction(true);
            playerData.setUsesPlugin(false);
            Location lastDeathLocation = playerData.getLastDeathLocation();
            if (lastDeathLocation == null) {
                lastDeathLocation = player.getLastDeathLocation();
            }
            util.dropInv(player, lastDeathLocation);
            this.minigame.sendLoseMessage(player);
            this.introduction.teleportPlayerToRespawnLocation(player);
            player.sendMessage(Component.text((String)this.tf.getTranslation(player, "playerDecided")).color((TextColor)NamedTextColor.GOLD));
        } else {
            player.sendMessage(Component.text((String)this.tf.getTranslation(player, "playerAlreadyDecided")).color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleArgsLength1SetWaitingListPositionExecution(Player player) {
        Location location = player.getLocation();
        this.config.setWaitingListPosition(location);
        player.sendMessage(Component.text((String)this.tf.getTranslation(player, "setWaitingListPosition")).color((TextColor)NamedTextColor.GREEN));
    }

    private void handleArgsLength1StartExecution(Player player) {
        DmUtil util = DmUtil.getInstance();
        PlayerData playerData = HandlePlayers.getKnownPlayers().get(player.getUniqueId());
        util.playSoundAtLocation(player.getEyeLocation(), Float.valueOf(0.5f), Sound.ENTITY_ENDER_EYE_DEATH);
        player.resetTitle();
        playerData.setStatus(PlayerMinigameStatus.ALIVE);
        Minigame.getInstance().minigameStart(player);
    }

    private void handleArgsLength1IgnoreExecution(Player player) {
        PlayerData playerData = HandlePlayers.getKnownPlayers().get(player.getUniqueId());
        Inventory lastDeathInventory = playerData.getLastDeathInventory();
        Location deathLocation = playerData.getLastDeathLocation();
        this.minigame.playSoundToPlayer(player, Float.valueOf(0.5f), Sound.ENTITY_ITEM_BREAK);
        playerData.setStatus(PlayerMinigameStatus.ALIVE);
        player.resetTitle();
        if (!HandlePlayers.waitingListMinigame.contains(player) && !lastDeathInventory.isEmpty()) {
            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)this.tf.getTranslation(player, "droppingInvAt")).color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)("X: " + deathLocation.getBlockX() + " Y: " + deathLocation.getBlockY() + " Z: " + deathLocation.getBlockZ())).color((TextColor)NamedTextColor.RED))).append((Component)Component.text((String)")"))).color((TextColor)NamedTextColor.GOLD));
            for (int i = 0; i < lastDeathInventory.getSize(); ++i) {
                ItemStack item = lastDeathInventory.getItem(i);
                if (item == null) continue;
                player.getWorld().dropItem(deathLocation, item);
            }
            playerData.getLastDeathInventory().clear();
        }
    }

    private void handleArgsLength2DifficultyExecution(PlayerData playerData, Player player, String arg1) {
        if (arg1 != null) {
            int i;
            try {
                i = Integer.parseInt(arg1);
                if (i < 0 || i > 10) {
                    player.sendMessage(Component.text((String)this.tf.getTranslation(player, "invalidDifficulty")).color((TextColor)NamedTextColor.RED));
                }
            }
            catch (NumberFormatException e) {
                player.sendMessage(Component.text((String)this.tf.getTranslation(player, "youHaveToEnterANumber")).color((TextColor)NamedTextColor.RED));
                return;
            }
            playerData.setDifficulty(i);
            player.sendMessage(MiniMessage.miniMessage().deserialize((Object)Component.text((String)this.tf.getTranslation(player, "setDiffTo", playerData.getDifficulty())).content()));
        } else {
            player.sendMessage((Component)Component.text((String)this.tf.getTranslation(player, "youHaveToEnterANumber")));
        }
    }

    private void handleArgsLength3DifficultyExecution(Player player, String arg1, String arg2) {
        if (arg2 != null) {
            int i;
            try {
                i = Integer.parseInt(arg2);
            }
            catch (NumberFormatException e) {
                player.sendMessage(Component.text((String)this.tf.getTranslation(player, "youHaveToEnterANumber")).color((TextColor)NamedTextColor.RED));
                return;
            }
            Player playerToEdit = Bukkit.getPlayer((String)arg1);
            assert (playerToEdit != null);
            PlayerData playerDataPlayerToEdit = HandlePlayers.getKnownPlayers().get(playerToEdit.getUniqueId());
            if (playerDataPlayerToEdit == null) {
                throw new NullPointerException("playerDataPlayerToEdit is null!");
            }
            playerDataPlayerToEdit.setDifficulty(i);
            player.sendMessage(MiniMessage.miniMessage().deserialize((Object)Component.text((String)this.tf.getTranslation(player, "setDiffOfTo", playerToEdit, playerDataPlayerToEdit.getDifficulty())).content()));
        } else {
            player.sendMessage(Component.text((String)this.tf.getTranslation(player, "youHaveToEnterANumber")).color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleArgsLength3IntroPlayerDecidesToUseFeaturesExecution(Player player, String arg1) {
        Player playerToEdit = Bukkit.getPlayer((String)arg1);
        if (playerToEdit != null) {
            PlayerData playerDataPlayerToEdit = HandlePlayers.getKnownPlayers().get(playerToEdit.getUniqueId());
            playerDataPlayerToEdit.setUsesPlugin(true);
        } else {
            player.sendMessage(Component.text((String)this.tf.getTranslation(player, "didNotEnterKnownPlayer")).color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleArgsLength3introPlayerDecidesToNotUseFeaturesExecution(Player player, String arg1) {
        Player playerToEdit = Bukkit.getPlayer((String)arg1);
        if (playerToEdit != null) {
            PlayerData playerDataPlayerToEdit = HandlePlayers.getKnownPlayers().get(playerToEdit.getUniqueId());
            playerDataPlayerToEdit.setUsesPlugin(false);
        } else {
            player.sendMessage((Component)Component.text((String)this.tf.getTranslation(player, "didNotEnterKnownPlayer")));
        }
    }

    @NotNull
    public Collection<String> suggest(@NotNull CommandSourceStack commandSourceStack, @NotNull String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (commandSourceStack == null || args == null) {
            return suggestions;
        }
        Player player = (Player)commandSourceStack.getSender();
        if (player == null) {
            return suggestions;
        }
        if (args.length == 0) {
            suggestions.add("difficulty");
            suggestions.add("lowerDifficulty");
            return suggestions;
        }
        if (args.length == 2 && player.isOp() && "difficulty".equalsIgnoreCase(args[0])) {
            for (UUID uuid : HandlePlayers.getKnownPlayers().keySet()) {
                Player playerToSuggest = Bukkit.getPlayer((UUID)uuid);
                if (playerToSuggest == null) continue;
                suggestions.add(playerToSuggest.getName());
            }
            return suggestions;
        }
        return super.suggest(commandSourceStack, args);
    }

    public static enum ArgsLength1 {
        SETTINGS,
        LOWERDIFFICULTY,
        INTROPLAYERDECIDESTOUSEFEATURES,
        INTROPLAYERDECIDESTONOTUSEFEATURES,
        SETNOTINTRODUCED,
        DIFFICULTY,
        SETWAITINGLISTPOSITION,
        DECIDEDNOTTOSETPOSITION,
        STATUS,
        START,
        IGNORE;

    }
}

