/*
 * Decompiled with CFR 0.152.
 */
package de.j.deathMinigames.database;

import de.chojo.sadu.queries.api.call.Call;
import de.chojo.sadu.queries.api.query.Query;
import de.chojo.sadu.queries.call.adapter.UUIDAdapter;
import de.j.deathMinigames.database.Database;
import de.j.deathMinigames.main.HandlePlayers;
import de.j.deathMinigames.main.PlayerData;
import de.j.stationofdoom.main.Main;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PlayerDataDatabase {
    private static volatile PlayerDataDatabase instance;

    private PlayerDataDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PlayerDataDatabase getInstance() {
        if (instance != null) return instance;
        Class<PlayerDataDatabase> clazz = PlayerDataDatabase.class;
        synchronized (PlayerDataDatabase.class) {
            if (instance != null) return instance;
            instance = new PlayerDataDatabase();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void createTable() {
        if (!Database.getInstance().isConnected) {
            return;
        }
        Query.query((String)"CREATE TABLE IF NOT EXISTS playerData (name VARCHAR(255), UUID VARCHAR(255), introduction BOOLEAN, usesPlugin BOOLEAN, difficulty INT, bestParkourTime FLOAT);", (Object[])new Object[0]).single().insert();
    }

    public List<PlayerData> getAllPlayerDatas() {
        if (!Database.getInstance().isConnected) {
            return new ArrayList<PlayerData>();
        }
        return Query.query((String)"SELECT * FROM playerdata;", (Object[])new Object[0]).single().map(row -> new PlayerData(row.getString("name"), row.getString("uuid"), row.getBoolean("introduction"), row.getBoolean("usesPlugin"), row.getInt("difficulty"), row.getFloat("bestParkourTime"))).all();
    }

    public void updatePlayerDataDatabase(Collection<PlayerData> playerDatas) {
        int newlyAddedPlayers = 0;
        int updatedPlayers = 0;
        if (!Database.getInstance().isConnected) {
            return;
        }
        for (PlayerData playerData : playerDatas) {
            if (this.checkIfPlayerIsInDatabase(playerData)) {
                Query.query((String)"UPDATE playerData SET name = :name, introduction = :introduction, usesPlugin = :usesPlugin, difficulty = :difficulty, bestParkourTime = :bestParkourTime WHERE uuid = :uuid;", (Object[])new Object[0]).single(Call.of().bind("name", playerData.getName()).bind("introduction", Boolean.valueOf(playerData.getIntroduction())).bind("usesPlugin", Boolean.valueOf(playerData.getUsesPlugin())).bind("difficulty", Integer.valueOf(playerData.getDifficulty())).bind("bestParkourTime", Float.valueOf(playerData.getBestParkourTime())).bind("uuid", (Object)playerData.getUUID(), UUIDAdapter.AS_STRING)).update();
                ++updatedPlayers;
                continue;
            }
            this.addPlayerToDatabase(playerData);
            ++newlyAddedPlayers;
        }
        Main.getMainLogger().info("Updated PlayerDataDatabase, added " + newlyAddedPlayers + " and updated " + updatedPlayers + " players");
    }

    public void addPlayerToDatabase(PlayerData playerData) {
        if (!Database.getInstance().isConnected) {
            return;
        }
        Query.query((String)"INSERT INTO playerData (name, UUID, introduction, usesPlugin, difficulty, bestParkourTime) VALUES (:name, :uuid, :introduction, :usesPlugin, :difficulty, :bestParkourTime);", (Object[])new Object[0]).single(Call.of().bind("name", playerData.getName()).bind("uuid", (Object)playerData.getUUID(), UUIDAdapter.AS_STRING).bind("introduction", Boolean.valueOf(playerData.getIntroduction())).bind("usesPlugin", Boolean.valueOf(playerData.getUsesPlugin())).bind("difficulty", Integer.valueOf(playerData.getDifficulty())).bind("bestParkourTime", Float.valueOf(playerData.getBestParkourTime()))).insert();
    }

    public boolean checkIfPlayerIsInDatabase(PlayerData playerDataPlayerToCheck) {
        if (!Database.getInstance().isConnected) {
            return HandlePlayers.getKnownPlayers().containsKey(playerDataPlayerToCheck.getUUID());
        }
        List<PlayerData> playerDatas = this.getAllPlayerDatas();
        boolean isInDatabase = false;
        if (playerDatas.isEmpty()) {
            return false;
        }
        for (PlayerData playerDataToCompare : playerDatas) {
            if (!playerDataToCompare.getUUID().equals(playerDataPlayerToCheck.getUUID())) continue;
            isInDatabase = true;
        }
        return isInDatabase;
    }
}

