/*
 * Decompiled with CFR 0.152.
 */
package de.j.deathMinigames.listeners;

import de.j.deathMinigames.main.Config;
import de.j.deathMinigames.main.HandlePlayers;
import de.j.deathMinigames.main.PlayerData;
import de.j.deathMinigames.minigames.Minigame;
import de.j.deathMinigames.settings.GUI;
import de.j.deathMinigames.settings.MainMenu;
import de.j.stationofdoom.util.translations.TranslationFactory;
import java.util.HashMap;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryHolder;

public class InventoryListener
implements Listener {
    private Player playerClicked;

    @EventHandler
    public void onSettingsClick(InventoryClickEvent event) {
        Config config = Config.getInstance();
        MainMenu mainMenu = new MainMenu();
        InventoryHolder invHolder = event.getInventory().getHolder();
        Minigame minigame = Minigame.getInstance();
        int slot = event.getSlot();
        if (slot < 0) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (invHolder instanceof MainMenu) {
            this.handleMainMenuGUI(event, player, mainMenu, slot);
            this.reloadInventory(MainMenu.InventoryMenus.DIFFICULTY, mainMenu);
        } else if (invHolder instanceof GUI) {
            GUI gui = (GUI)invHolder;
            UUID ID = gui.getUUID();
            if (ID == MainMenu.getIntroduction().getUUID()) {
                this.handleIntroductionGUI(event, player, mainMenu, slot, minigame);
            } else if (ID == MainMenu.getUsesPlugin().getUUID()) {
                this.handleUsesPluginGUI(event, player, mainMenu, slot, minigame);
            } else if (ID == MainMenu.getDifficulty().getUUID()) {
                this.handleDifficultyGUI(event, player, mainMenu, slot);
            } else if (ID == MainMenu.getDifficultyPlayerSettings().getUUID()) {
                this.handleDifficultyPlayerSettingsGUI(event, player, mainMenu, slot, minigame);
            } else if (ID == MainMenu.getSetUp().getUUID()) {
                this.handleSetUpGUI(event, player, mainMenu, slot, config);
            } else if (ID == MainMenu.getParkourStartHeight().getUUID()) {
                this.handleParkourStartHeightGUI(event, player, mainMenu, slot, config, minigame);
            } else if (ID == MainMenu.getParkourLength().getUUID()) {
                this.handleParkourLengthGUI(event, player, mainMenu, slot, config, minigame);
            } else if (ID == MainMenu.getCostToLowerTheDifficulty().getUUID()) {
                this.handleCostToLowerTheDifficultyGUI(event, player, mainMenu, slot, config, minigame);
            } else if (ID == MainMenu.getTimeToDecideWhenRespawning().getUUID()) {
                this.handleTimeToDecideWhenRespawningGUI(event, player, mainMenu, slot, config, minigame);
            }
        }
    }

    public Player getIndexAssociatedWithPlayerInKnownPlayersList(int placeInList) {
        HashMap<UUID, PlayerData> knownPlayers = HandlePlayers.getKnownPlayers();
        if (placeInList >= 0 && placeInList < knownPlayers.size()) {
            Player player = Bukkit.getPlayer((UUID)((UUID)knownPlayers.keySet().stream().toList().get(placeInList)));
            assert (player != null);
            return player;
        }
        return null;
    }

    public void reloadInventory(MainMenu.InventoryMenus inventory, int slot, MainMenu mainMenu) {
        Config config = Config.getInstance();
        PlayerData playerClickedData = HandlePlayers.getKnownPlayers().get(this.playerClicked.getUniqueId());
        if (this.playerClicked == null) {
            throw new IllegalStateException("No player selected");
        }
        switch (inventory) {
            case INTRODUCTION: {
                if (playerClickedData.getIntroduction()) {
                    MainMenu.getIntroduction().addClickableItemStack(this.playerClicked.getName(), Material.GREEN_CONCRETE_POWDER, 1, slot);
                    break;
                }
                MainMenu.getIntroduction().addClickableItemStack(this.playerClicked.getName(), Material.RED_CONCRETE_POWDER, 1, slot);
                break;
            }
            case USES_PLUGIN: {
                if (playerClickedData.getUsesPlugin()) {
                    MainMenu.getUsesPlugin().addClickableItemStack(this.playerClicked.getName(), Material.GREEN_CONCRETE_POWDER, 1, slot);
                    break;
                }
                MainMenu.getUsesPlugin().addClickableItemStack(this.playerClicked.getName(), Material.RED_CONCRETE_POWDER, 1, slot);
                break;
            }
            case DIFFICULTY_SETTINGS: {
                int difficulty = playerClickedData.getDifficulty();
                mainMenu.difficultySettingsSetInventoryContents(difficulty);
                break;
            }
            case SETTINGS: {
                if (config.checkSetUp()) {
                    mainMenu.addClickableItemStack("SetUp", Material.GREEN_CONCRETE, 1, 0);
                } else {
                    mainMenu.addClickableItemStack("SetUp", Material.RED_CONCRETE, 1, 0);
                }
                mainMenu.addClickableItemStack("Introduction", Material.GREEN_CONCRETE, 1, 1);
                mainMenu.addClickableItemStack("UsesPlugin", Material.GREEN_CONCRETE, 1, 2);
                mainMenu.addClickableItemStack("Difficulty", Material.RED_CONCRETE, 1, 3);
            }
        }
    }

    public void reloadInventory(MainMenu.InventoryMenus inventory, MainMenu mainMenu) {
        switch (inventory) {
            case INTRODUCTION: {
                HashMap<UUID, PlayerData> knownPlayers = HandlePlayers.getKnownPlayers();
                for (int i = 0; i < knownPlayers.size(); ++i) {
                    Player currentPlayer = this.getIndexAssociatedWithPlayerInKnownPlayersList(i);
                    if (currentPlayer == null) continue;
                    PlayerData playerData = knownPlayers.get(currentPlayer.getUniqueId());
                    MainMenu.getIntroduction().addClickableItemStack(currentPlayer.getName(), this.getMaterialBasedOnBoolean(playerData.getIntroduction()), 1, i);
                }
                break;
            }
            case USES_PLUGIN: {
                for (int i = 0; i < HandlePlayers.getKnownPlayers().size(); ++i) {
                    Player currentPlayer = this.getIndexAssociatedWithPlayerInKnownPlayersList(i);
                    if (currentPlayer == null) continue;
                    PlayerData playerData = HandlePlayers.getKnownPlayers().get(currentPlayer.getUniqueId());
                    MainMenu.getUsesPlugin().addClickableItemStack(currentPlayer.getName(), this.getMaterialBasedOnBoolean(playerData.getUsesPlugin()), 1, i);
                }
                break;
            }
            case DIFFICULTY: {
                MainMenu.getDifficulty().addPlayerHeads(HandlePlayers.getKnownPlayers());
                break;
            }
            case DIFFICULTY_SETTINGS: {
                PlayerData playerData = HandlePlayers.getKnownPlayers().get(this.playerClicked.getUniqueId());
                int difficulty = playerData.getDifficulty();
                mainMenu.difficultySettingsSetInventoryContents(difficulty);
                break;
            }
            case SETUP: {
                mainMenu.setUpSettingsSetInventoryContents();
                break;
            }
            case PARKOUR_START_HEIGHT: {
                mainMenu.parkourStartHeightSettingsSetInventoryContents();
                break;
            }
            case PARKOUR_LENGTH: {
                mainMenu.parkourLengthSettingsSetInventoryContents();
                break;
            }
            case COST_TO_LOWER_THE_DIFFICULTY: {
                mainMenu.costToLowerTheDifficultySettingsSetInventoryContents();
                break;
            }
            case TIME_TO_DECIDE_WHEN_RESPAWNING: {
                mainMenu.timeToDecideWhenRespawningSettingsSetInventoryContents();
            }
        }
    }

    private Material getMaterialBasedOnBoolean(boolean bool) {
        if (bool) {
            return Material.GREEN_CONCRETE_POWDER;
        }
        return Material.RED_CONCRETE_POWDER;
    }

    private void handleMainMenuGUI(InventoryClickEvent event, Player player, MainMenu mainMenu, int slot) {
        event.setCancelled(true);
        switch (slot) {
            case 0: {
                this.reloadInventory(MainMenu.InventoryMenus.SETUP, mainMenu);
                MainMenu.getSetUp().addBackButton(player);
                MainMenu.getSetUp().showInventory(player);
                break;
            }
            case 1: {
                this.reloadInventory(MainMenu.InventoryMenus.INTRODUCTION, mainMenu);
                MainMenu.getIntroduction().addBackButton(player);
                MainMenu.getIntroduction().showInventory(player);
                break;
            }
            case 2: {
                this.reloadInventory(MainMenu.InventoryMenus.USES_PLUGIN, mainMenu);
                MainMenu.getUsesPlugin().addBackButton(player);
                MainMenu.getUsesPlugin().showInventory(player);
                break;
            }
            case 3: {
                MainMenu.getDifficulty().addBackButton(player);
                MainMenu.getDifficulty().showInventory(player);
                break;
            }
            case 4: {
                MainMenu.getSetHost().showInventory(player);
                break;
            }
            case 5: {
                MainMenu.getSetServerName().showInventory(player);
            }
        }
    }

    private void handleIntroductionGUI(InventoryClickEvent event, Player player, MainMenu mainMenu, int slot, Minigame minigame) {
        HashMap<UUID, PlayerData> knownPlayers = HandlePlayers.getKnownPlayers();
        event.setCancelled(true);
        if (slot == 53) {
            mainMenu.showPlayerSettings(player);
        } else if (slot <= knownPlayers.size()) {
            PlayerData playerClickedData;
            this.playerClicked = this.getIndexAssociatedWithPlayerInKnownPlayersList(slot);
            if (this.playerClicked == null) {
                player.sendMessage(Component.text((String)new TranslationFactory().getTranslation(player, "somethingWentWrong")).color((TextColor)NamedTextColor.RED));
            }
            if ((playerClickedData = knownPlayers.get(this.playerClicked.getUniqueId())).getIntroduction()) {
                minigame.playSoundToPlayer(player, Float.valueOf(0.5f), Sound.ENTITY_ITEM_BREAK);
                playerClickedData.setIntroduction(false);
            } else if (!playerClickedData.getIntroduction()) {
                minigame.playSoundToPlayer(player, Float.valueOf(0.5f), Sound.BLOCK_ANVIL_USE);
                playerClickedData.setIntroduction(true);
            }
            this.reloadInventory(MainMenu.InventoryMenus.INTRODUCTION, slot, mainMenu);
            player.sendMessage(Component.text((String)("Changed Introduction of " + this.playerClicked.getName() + " to " + playerClickedData.getIntroduction())).color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleUsesPluginGUI(InventoryClickEvent event, Player player, MainMenu mainMenu, int slot, Minigame minigame) {
        HashMap<UUID, PlayerData> knownPlayers = HandlePlayers.getKnownPlayers();
        event.setCancelled(true);
        if (slot == 53) {
            mainMenu.showPlayerSettings(player);
        } else if (slot <= knownPlayers.size()) {
            PlayerData playerClickedData;
            this.playerClicked = this.getIndexAssociatedWithPlayerInKnownPlayersList(slot);
            if (this.playerClicked == null) {
                player.sendMessage(Component.text((String)new TranslationFactory().getTranslation(player, "somethingWentWrong")).color((TextColor)NamedTextColor.RED));
            }
            if ((playerClickedData = knownPlayers.get(this.playerClicked.getUniqueId())).getUsesPlugin()) {
                minigame.playSoundToPlayer(player, Float.valueOf(0.5f), Sound.ENTITY_ITEM_BREAK);
                playerClickedData.setUsesPlugin(false);
            } else if (!playerClickedData.getUsesPlugin()) {
                minigame.playSoundToPlayer(player, Float.valueOf(0.5f), Sound.BLOCK_ANVIL_USE);
                playerClickedData.setUsesPlugin(true);
            }
            this.reloadInventory(MainMenu.InventoryMenus.USES_PLUGIN, slot, mainMenu);
            player.sendMessage(Component.text((String)("Changed UsesPlugin of " + playerClickedData.getName() + " to " + playerClickedData.getUsesPlugin())).color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleDifficultyGUI(InventoryClickEvent event, Player player, MainMenu mainMenu, int slot) {
        event.setCancelled(true);
        if (slot == 53) {
            mainMenu.showPlayerSettings(player);
        } else if (slot <= HandlePlayers.getKnownPlayers().size()) {
            this.playerClicked = this.getIndexAssociatedWithPlayerInKnownPlayersList(slot);
            player.sendMessage(Component.text((String)new TranslationFactory().getTranslation(player, "somethingWentWrong")).color((TextColor)NamedTextColor.RED));
            this.reloadInventory(MainMenu.InventoryMenus.DIFFICULTY_SETTINGS, slot, mainMenu);
            MainMenu.getDifficultyPlayerSettings().addBackButton(player);
            MainMenu.getDifficultyPlayerSettings().showInventory(player);
        }
    }

    private void handleDifficultyPlayerSettingsGUI(InventoryClickEvent event, Player player, MainMenu mainMenu, int slot, Minigame minigame) {
        event.setCancelled(true);
        if (slot == 53) {
            mainMenu.showPlayerSettings(player);
        } else if (slot < 11) {
            minigame.playSoundToPlayer(player, Float.valueOf(0.5f), Sound.BLOCK_ANVIL_USE);
            PlayerData playerClickedData = HandlePlayers.getKnownPlayers().get(this.playerClicked.getUniqueId());
            playerClickedData.setDifficulty(slot);
            this.reloadInventory(MainMenu.InventoryMenus.DIFFICULTY_SETTINGS, slot, mainMenu);
            player.sendMessage(Component.text((String)("Changed Difficulty of " + playerClickedData.getName() + " to " + playerClickedData.getDifficulty())).color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleSetUpGUI(InventoryClickEvent event, Player player, MainMenu mainMenu, int slot, Config config) {
        event.setCancelled(true);
        if (slot == 53) {
            mainMenu.showPlayerSettings(player);
        } else if (slot <= 4) {
            switch (slot) {
                case 0: {
                    this.reloadInventory(MainMenu.InventoryMenus.PARKOUR_START_HEIGHT, mainMenu);
                    MainMenu.getParkourStartHeight().addBackButton(player);
                    MainMenu.getParkourStartHeight().showInventory(player);
                    break;
                }
                case 1: {
                    this.reloadInventory(MainMenu.InventoryMenus.PARKOUR_LENGTH, mainMenu);
                    MainMenu.getParkourLength().addBackButton(player);
                    MainMenu.getParkourLength().showInventory(player);
                    break;
                }
                case 2: {
                    config.setWaitingListPosition(player.getLocation());
                    this.reloadInventory(MainMenu.InventoryMenus.SETUP, mainMenu);
                    player.sendMessage(Component.text((String)new TranslationFactory().getTranslation(player, "setWaitingListPosition")).color((TextColor)NamedTextColor.GREEN));
                    break;
                }
                case 3: {
                    this.reloadInventory(MainMenu.InventoryMenus.COST_TO_LOWER_THE_DIFFICULTY, mainMenu);
                    MainMenu.getCostToLowerTheDifficulty().addBackButton(player);
                    MainMenu.getCostToLowerTheDifficulty().showInventory(player);
                    break;
                }
                case 4: {
                    this.reloadInventory(MainMenu.InventoryMenus.TIME_TO_DECIDE_WHEN_RESPAWNING, mainMenu);
                    MainMenu.getTimeToDecideWhenRespawning().addBackButton(player);
                    MainMenu.getTimeToDecideWhenRespawning().showInventory(player);
                }
            }
        }
    }

    private void handleParkourStartHeightGUI(InventoryClickEvent event, Player player, MainMenu mainMenu, int slot, Config config, Minigame minigame) {
        event.setCancelled(true);
        if (slot == 53) {
            mainMenu.showPlayerSettings(player);
        } else if (slot <= 36) {
            minigame.playSoundToPlayer(player, Float.valueOf(0.5f), Sound.BLOCK_ANVIL_USE);
            int parkourStartHeight = slot * 10;
            config.setParkourStartHeight(parkourStartHeight);
            this.reloadInventory(MainMenu.InventoryMenus.PARKOUR_START_HEIGHT, mainMenu);
        }
    }

    private void handleParkourLengthGUI(InventoryClickEvent event, Player player, MainMenu mainMenu, int slot, Config config, Minigame minigame) {
        event.setCancelled(true);
        if (slot == 53) {
            mainMenu.showPlayerSettings(player);
        } else if (slot < 20) {
            minigame.playSoundToPlayer(player, Float.valueOf(0.5f), Sound.BLOCK_ANVIL_USE);
            config.setParkourLength(slot);
            this.reloadInventory(MainMenu.InventoryMenus.PARKOUR_LENGTH, mainMenu);
        }
    }

    private void handleCostToLowerTheDifficultyGUI(InventoryClickEvent event, Player player, MainMenu mainMenu, int slot, Config config, Minigame minigame) {
        event.setCancelled(true);
        if (slot == 53) {
            mainMenu.showPlayerSettings(player);
        } else if (slot < 9) {
            minigame.playSoundToPlayer(player, Float.valueOf(0.5f), Sound.BLOCK_ANVIL_USE);
            config.setCostToLowerTheDifficulty(++slot);
            this.reloadInventory(MainMenu.InventoryMenus.COST_TO_LOWER_THE_DIFFICULTY, mainMenu);
        }
    }

    private void handleTimeToDecideWhenRespawningGUI(InventoryClickEvent event, Player player, MainMenu mainMenu, int slot, Config config, Minigame minigame) {
        event.setCancelled(true);
        if (slot == 53) {
            mainMenu.showPlayerSettings(player);
        } else if (slot < 29) {
            minigame.playSoundToPlayer(player, Float.valueOf(0.5f), Sound.BLOCK_ANVIL_USE);
            config.setTimeToDecideWhenRespawning(slot += 5);
            this.reloadInventory(MainMenu.InventoryMenus.TIME_TO_DECIDE_WHEN_RESPAWNING, mainMenu);
        }
    }
}

