/*
 * Decompiled with CFR 0.152.
 */
package de.j.deathMinigames.listeners;

import de.j.deathMinigames.dmUtil.DmUtil;
import de.j.deathMinigames.main.HandlePlayers;
import de.j.deathMinigames.main.PlayerData;
import de.j.deathMinigames.main.PlayerMinigameStatus;
import de.j.stationofdoom.main.Main;
import de.j.stationofdoom.util.translations.TranslationFactory;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;

public class SaveItemsOnDeath
implements Listener {
    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        TextComponent message;
        event.setKeepInventory(true);
        event.getDrops().clear();
        TranslationFactory tf = new TranslationFactory();
        DmUtil util = DmUtil.getInstance();
        if (event == null || event.getPlayer() == null) {
            Main.getMainLogger().warning("Event or player in onDeath is null!");
            return;
        }
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        PlayerData playerData = HandlePlayers.getKnownPlayers().get(uuid);
        playerData.setStatus(PlayerMinigameStatus.DEAD);
        if (player.getInventory() == null) {
            Main.getMainLogger().warning("Player inventory is null!");
            return;
        }
        if (!playerData.getUsesPlugin()) {
            Location deathLocation = playerData.getLastDeathLocation();
            util.dropInv(player, deathLocation);
            return;
        }
        PlayerInventory inventory = player.getInventory();
        Location deathpoint = player.getLocation();
        if (inventory.isEmpty()) {
            message = Component.text((String)tf.getTranslation(player, "didNotSaveInv"));
            playerData.getLastDeathInventory().clear();
        } else {
            message = Component.text((String)tf.getTranslation(player, "savedInv"));
            playerData.setLastDeathInventoryContents((Inventory)inventory);
            playerData.setLastDeathLocation(deathpoint);
        }
        player.sendActionBar(message.color((TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, true));
    }
}

