/*
 * Decompiled with CFR 0.152.
 */
package de.j.deathMinigames.main;

import de.j.deathMinigames.dmUtil.DmUtil;
import de.j.deathMinigames.main.Config;
import de.j.stationofdoom.main.Main;
import de.j.stationofdoom.util.translations.TranslationFactory;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class Introduction {
    public void introStart(Player player) {
        int heightDifferenceToParkourEnd = 5;
        try {
            Config config = Config.getInstance();
            Location location = player.getWorld().getSpawnLocation();
            location.setY((double)(config.checkParkourStartHeight() + config.checkParkourLength() + heightDifferenceToParkourEnd));
            this.sendPlayerIntroMessage(player);
            this.teleportPlayerToIntroLocation(player, location);
        }
        catch (Exception e) {
            Main.getMainLogger().warning("Could not start intro!");
            player.sendMessage(Component.text((String)("Could not start intro!" + e.getMessage())).color((TextColor)NamedTextColor.RED));
        }
    }

    private void sendPlayerIntroMessage(Player player) {
        TranslationFactory tf = new TranslationFactory();
        player.sendMessage((Component)Component.text((String)tf.getTranslation(player, "introMessage")));
        player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"").append(((TextComponent)((TextComponent)Component.text((String)tf.getTranslation(player, "yes")).decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)"/game introPlayerDecidesToUseFeatures"))).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)" / ").color((TextColor)NamedTextColor.GOLD))).append(((TextComponent)((TextComponent)Component.text((String)tf.getTranslation(player, "no")).decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)"/game introPlayerDecidesToNotUseFeatures"))).color((TextColor)NamedTextColor.RED)));
    }

    private void teleportPlayerToIntroLocation(Player player, Location location) {
        DmUtil dmUtil = DmUtil.getInstance();
        if (location.getBlock().getType() != Material.BARRIER) {
            this.placeBarrierCageAroundLoc(location);
        }
        location.setX(location.getX() + 0.5);
        location.setZ(location.getZ() + 0.5);
        player.teleport(location);
        dmUtil.playSoundAtLocation(location, Float.valueOf(0.5f), Sound.ENTITY_ENDER_EYE_DEATH);
    }

    private void placeBarrierCageAroundLoc(Location location) {
        if (location == null) {
            Main.getMainLogger().warning("Tried to place barrier cage at null location!");
            return;
        }
        int[][] offsets = new int[][]{{0, -1, 0}, {1, 0, 0}, {-1, 0, 0}, {0, 0, 1}, {0, 0, -1}, {1, 1, 0}, {-1, 1, 0}, {0, 1, 1}, {0, 1, -1}, {0, 2, 0}};
        try {
            for (int[] offset : offsets) {
                location.clone().add((double)offset[0], (double)offset[1], (double)offset[2]).getBlock().setType(Material.BARRIER);
            }
        }
        catch (IllegalStateException e) {
            Main.getMainLogger().warning(String.format("Failes to place barrier cage at %s", location));
        }
    }

    public void teleportPlayerToRespawnLocation(Player player) {
        if (player == null) {
            throw new NullPointerException("player is null!");
        }
        player.playSound(player.getEyeLocation(), Sound.BLOCK_PORTAL_TRAVEL, 0.5f, 1.0f);
        if (player.getRespawnLocation() == null) {
            player.teleport(player.getWorld().getSpawnLocation());
        } else {
            player.teleport(player.getRespawnLocation());
        }
    }
}

