/*
 * Decompiled with CFR 0.152.
 */
package de.j.deathMinigames.minigames;

import de.j.deathMinigames.main.Config;
import de.j.deathMinigames.main.HandlePlayers;
import de.j.deathMinigames.main.PlayerData;
import de.j.stationofdoom.util.translations.TranslationFactory;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Difficulty {
    private static Difficulty instance;
    private static final int maxDifficulty = 10;

    private Difficulty() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Difficulty getInstance() {
        if (instance != null) return instance;
        Class<Difficulty> clazz = Difficulty.class;
        synchronized (Difficulty.class) {
            if (instance != null) return instance;
            instance = new Difficulty();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void higherDifficulty(Player player) {
        if (player == null) {
            throw new NullPointerException("player is null!");
        }
        PlayerData playerData = HandlePlayers.getKnownPlayers().get(player.getUniqueId());
        if (playerData == null) {
            throw new NullPointerException("playerData is null!");
        }
        TranslationFactory tf = new TranslationFactory();
        int currentDifficulty = playerData.getDifficulty();
        if (currentDifficulty == 10) {
            player.sendMessage(Component.text((String)tf.getTranslation(player, "maxDiffAlreadyReached")).color((TextColor)NamedTextColor.RED));
        } else {
            playerData.setDifficulty(currentDifficulty + 1);
        }
    }

    public void lowerDifficulty(Player player) {
        if (player == null) {
            throw new NullPointerException("player is null!");
        }
        PlayerData playerData = HandlePlayers.getKnownPlayers().get(player.getUniqueId());
        if (playerData == null) {
            throw new NullPointerException("playerData is null!");
        }
        int currentDifficulty = playerData.getDifficulty();
        playerData.setDifficulty(currentDifficulty - 1);
    }

    public boolean checkIfPlayerCanPay(Player player) {
        Config config = Config.getInstance();
        return player.getInventory().contains(Material.DIAMOND, config.checkCostToLowerTheDifficulty());
    }

    public void removePaymentFromPlayerInventory(Player player) {
        Config config = Config.getInstance();
        ItemStack diamonds = new ItemStack(Material.DIAMOND, config.checkCostToLowerTheDifficulty());
        player.getInventory().removeItem(new ItemStack[]{diamonds});
    }
}

