/*
 * Decompiled with CFR 0.152.
 */
package de.j.deathMinigames.minigames;

import de.j.deathMinigames.main.PlayerData;
import de.j.stationofdoom.main.Main;
import java.math.BigDecimal;
import java.math.RoundingMode;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ParkourTimer {
    private static volatile ParkourTimer instance;
    private static BukkitRunnable runnable;
    private static Player player;
    private static float timer;

    private ParkourTimer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ParkourTimer getInstance() {
        if (instance != null) return instance;
        Class<ParkourTimer> clazz = ParkourTimer.class;
        synchronized (ParkourTimer.class) {
            if (instance != null) return instance;
            instance = new ParkourTimer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static float getTimer() {
        return new BigDecimal(timer).setScale(2, RoundingMode.HALF_UP).floatValue();
    }

    public static void resetTimer() {
        timer = 0.0f;
    }

    public static void startTimer(Player player) {
        if (player == null) {
            Main.getMainLogger().warning("Player is null! Timer not started!");
            return;
        }
        ParkourTimer.player = player;
        if (runnable != null) {
            Main.getMainLogger().warning("Runnable is not null! Timer not started!");
            return;
        }
        ParkourTimer.timer(player);
    }

    public static void stopTimer() {
        if (runnable == null) {
            return;
        }
        runnable.cancel();
        runnable = null;
    }

    private static void timer(final Player player) {
        ParkourTimer.player = player;
        runnable = new BukkitRunnable(){

            public void run() {
                timer += 0.1f;
                ParkourTimer.showTimerToPlayerAsTitle(player);
            }
        };
        runnable.runTaskTimerAsynchronously((Plugin)Main.getPlugin(), 0L, 2L);
    }

    public static void showTimerToPlayerAsTitle(Player player) {
        player.sendActionBar(Component.text((String)("Time: " + ParkourTimer.getTimer())).color((TextColor)NamedTextColor.GOLD));
    }

    public void checkIfPlayerLeft(Player player, PlayerData playerData) {
        if (player == ParkourTimer.player) {
            ParkourTimer.stopTimer();
            playerData.setLeftWhileProcessing(true);
        }
    }

    static {
        timer = 0.0f;
    }
}

