/*
 * Decompiled with CFR 0.152.
 */
package de.j.deathMinigames.settings;

import de.j.deathMinigames.main.HandlePlayers;
import de.j.deathMinigames.main.PlayerData;
import de.j.stationofdoom.main.Main;
import de.j.stationofdoom.util.translations.TranslationFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.jetbrains.annotations.NotNull;

public class GUI
implements InventoryHolder {
    private final Inventory inventory;
    private final UUID uuid = UUID.randomUUID();

    public GUI(String title, boolean addAllPlayers, boolean addAsPlayerHeads) {
        if (title == null) {
            throw new NullPointerException("Title is null!");
        }
        int inventorySize = 54;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)inventorySize, (String)title);
        if (addAllPlayers) {
            HashMap<UUID, PlayerData> knownPlayers = HandlePlayers.getKnownPlayers();
            if (addAsPlayerHeads) {
                this.addPlayerHeads(knownPlayers);
            } else {
                this.addBooleanBased(knownPlayers, title);
            }
        }
    }

    public void addPlayerHeads(HashMap<UUID, PlayerData> knownPlayers) {
        int maxSlots = this.inventory.getSize() - 1;
        ArrayList<UUID> playerKeys = new ArrayList<UUID>(knownPlayers.keySet());
        for (int i = 0; i < knownPlayers.size(); ++i) {
            if (i > maxSlots) {
                Main.getMainLogger().warning("Not enough slots to add all players!");
                break;
            }
            PlayerData playerData = knownPlayers.get(playerKeys.get(i));
            if (playerData == null || playerData.getUUID() == null) continue;
            ItemStack head = new ItemStack(Material.PLAYER_HEAD, 1);
            SkullMeta skullMeta = (SkullMeta)head.getItemMeta();
            skullMeta.setOwnerProfile((PlayerProfile)Bukkit.createProfile((UUID)playerData.getUUID()));
            skullMeta.displayName((Component)Component.text((String)playerData.getName()));
            head.setItemMeta((ItemMeta)skullMeta);
            this.inventory.setItem(i, head);
        }
    }

    private void addBooleanBased(HashMap<UUID, PlayerData> knownPlayers, String title) {
        ArrayList<UUID> playerKeys = new ArrayList<UUID>(knownPlayers.keySet());
        for (int i = 0; i < knownPlayers.size(); ++i) {
            PlayerData playerData = knownPlayers.get(playerKeys.get(i));
            boolean value = switch (title) {
                case "UsesPlugin" -> playerData.getUsesPlugin();
                case "Introduction" -> playerData.getIntroduction();
                default -> false;
            };
            Material material = value ? Material.GREEN_CONCRETE_POWDER : Material.RED_CONCRETE_POWDER;
            ItemStack itemStack = new ItemStack(material);
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.displayName((Component)Component.text((String)playerData.getName()));
            itemStack.setItemMeta(itemMeta);
            this.inventory.setItem(i, itemStack);
        }
    }

    public void addClickableItemStack(String name, Material material, int amount, int slotWhereToPutTheItem) {
        this.addClickableItemStack(name, material, amount, slotWhereToPutTheItem, null);
    }

    public void addClickableItemStack(String name, Material material, int amount, int slotWhereToPutTheItem, ArrayList<String> lore) {
        ArrayList<String> loreList = lore;
        ItemStack itemStack = new ItemStack(material, amount);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(name);
        if (lore != null) {
            itemMeta.setLore(loreList);
        }
        itemStack.setItemMeta(itemMeta);
        this.inventory.setItem(slotWhereToPutTheItem, itemStack);
    }

    public void addClickableContentsViaItemStackList(ItemStack[] itemStackList) {
        if (itemStackList.length > this.inventory.getSize()) {
            throw new IllegalArgumentException("The StackList is bigger then the size of the inventory!");
        }
        this.inventory.setContents(itemStackList);
    }

    public void showInventory(Player playerToShowTheInvTo) {
        playerToShowTheInvTo.openInventory(this.inventory);
    }

    public void addBackButton(Player player) {
        this.addClickableItemStack(new TranslationFactory().getTranslation(player, "backButton"), Material.RED_CONCRETE, 1, 53);
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public UUID getUUID() {
        return this.uuid;
    }
}

