/*
 * Decompiled with CFR 0.152.
 */
package de.j.deathMinigames.settings;

import de.j.deathMinigames.main.Config;
import de.j.deathMinigames.settings.AnvilUI;
import de.j.deathMinigames.settings.GUI;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MainMenu
implements InventoryHolder {
    private final Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)9, (String)"Settings");
    private static final GUI introduction = new GUI("Introduction", true, false);
    private static final GUI difficulty = new GUI("Difficulty", true, true);
    private static final GUI usesPlugin = new GUI("UsesPlugin", true, false);
    private static final GUI difficultyPlayerSettings = new GUI("Difficulty - Settings", false, false);
    private static final GUI setUp = new GUI("SetUp", false, false);
    private static final GUI parkourStartHeight = new GUI("ParkourStartHeight", false, false);
    private static final GUI parkourLength = new GUI("ParkourLength", false, false);
    private static final GUI costToLowerTheDifficulty = new GUI("CostToLowerTheDifficulty", false, false);
    private static final GUI timeToDecideWhenRespawning = new GUI("TimeToDecideWhenRespawning", false, false);
    private static final AnvilUI setHost = new AnvilUI(AnvilUIs.SET_HOST_NAME);
    private static final AnvilUI setServerName = new AnvilUI(AnvilUIs.SET_SERVER_NAME);

    public static synchronized GUI getIntroduction() {
        return introduction;
    }

    public static synchronized GUI getDifficulty() {
        return difficulty;
    }

    public static synchronized GUI getUsesPlugin() {
        return usesPlugin;
    }

    public static synchronized GUI getDifficultyPlayerSettings() {
        return difficultyPlayerSettings;
    }

    public static synchronized GUI getSetUp() {
        return setUp;
    }

    public static synchronized GUI getParkourStartHeight() {
        return parkourStartHeight;
    }

    public static synchronized GUI getParkourLength() {
        return parkourLength;
    }

    public static synchronized GUI getCostToLowerTheDifficulty() {
        return costToLowerTheDifficulty;
    }

    public static synchronized GUI getTimeToDecideWhenRespawning() {
        return timeToDecideWhenRespawning;
    }

    public static synchronized AnvilUI getSetHost() {
        return setHost;
    }

    public static synchronized AnvilUI getSetServerName() {
        return setServerName;
    }

    public void showPlayerSettings(Player player) {
        this.addSubmenus();
        this.showPlayerInv(player);
    }

    private void addSubmenus() {
        Config config = Config.getInstance();
        if (config.checkSetUp()) {
            this.addClickableItemStack("SetUp", Material.GREEN_CONCRETE, 1, 0);
        } else {
            this.addClickableItemStack("SetUp", Material.RED_CONCRETE, 1, 0);
        }
        this.addClickableItemStack("Introduction", Material.GREEN_CONCRETE, 1, 1);
        this.addClickableItemStack("UsesPlugin", Material.GREEN_CONCRETE, 1, 2);
        this.addClickableItemStack("Difficulty", Material.RED_CONCRETE, 1, 3);
        this.addClickableItemStack("SetHost", Material.BOOK, 1, 4);
        this.addClickableItemStack("SetServerName", Material.BOOK, 1, 5);
    }

    private void showPlayerInv(Player player) {
        if (this.inventory == null) {
            throw new IllegalStateException("Inventory is null");
        }
        player.openInventory(this.inventory);
    }

    public void addClickableItemStack(String name, Material material, int amount, int slotWhereToPutTheItem) {
        if (name == null) {
            throw new NullPointerException("name is null!");
        }
        if (material == null) {
            throw new NullPointerException("material is null!");
        }
        if (amount <= 0) {
            throw new IllegalArgumentException("amount must be greater than 0!");
        }
        if (slotWhereToPutTheItem < 0 || slotWhereToPutTheItem >= this.inventory.getSize()) {
            throw new IllegalArgumentException("Invalid slot index: " + slotWhereToPutTheItem);
        }
        ItemStack itemStack = new ItemStack(material, amount);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(name);
        itemStack.setItemMeta(itemMeta);
        this.inventory.setItem(slotWhereToPutTheItem, itemStack);
    }

    public void difficultySettingsSetInventoryContents(int difficulty) {
        int maxDifficulty = 10;
        if (difficulty < 0 || difficulty > maxDifficulty) {
            throw new IllegalArgumentException("Difficulty must be between 0 and " + maxDifficulty);
        }
        for (int i = 0; i <= maxDifficulty; ++i) {
            MainMenu.getDifficultyPlayerSettings().addClickableItemStack(Integer.toString(i), Material.RED_CONCRETE_POWDER, 1, i);
        }
        MainMenu.getDifficultyPlayerSettings().addClickableItemStack(Integer.toString(difficulty), Material.GREEN_CONCRETE_POWDER, 1, difficulty);
    }

    public void setUpSettingsSetInventoryContents() {
        Config config = Config.getInstance();
        Location waitingListPosition = config.checkWaitingListLocation();
        int startHeight = config.checkParkourStartHeight();
        int parkourLength = config.checkParkourLength();
        int costToLowerTheDifficulty = config.checkCostToLowerTheDifficulty();
        int timeToDecideWhenRespawning = config.checkTimeToDecideWhenRespawning();
        if (startHeight != 0) {
            MainMenu.getSetUp().addClickableItemStack("Parcour Start Height", Material.LADDER, startHeight, 0);
        } else {
            MainMenu.getSetUp().addClickableItemStack("Parcour Start Height", Material.LADDER, 1, 0);
        }
        if (parkourLength != 0) {
            MainMenu.getSetUp().addClickableItemStack("Parcour length", Material.LADDER, parkourLength, 1);
        } else {
            MainMenu.getSetUp().addClickableItemStack("Parcour length", Material.LADDER, 1, 1);
        }
        if (waitingListPosition != null) {
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("Current position:");
            lore.add(String.format("X: %d", waitingListPosition.getBlockX()));
            lore.add(String.format("Y: %d", waitingListPosition.getBlockY()));
            lore.add(String.format("Z: %d", waitingListPosition.getBlockZ()));
            MainMenu.getSetUp().addClickableItemStack("WaitingListPosition", Material.GREEN_CONCRETE_POWDER, 1, 2, lore);
        } else {
            MainMenu.getSetUp().addClickableItemStack("WaitingListPosition", Material.RED_CONCRETE_POWDER, 1, 2);
        }
        if (costToLowerTheDifficulty != 0) {
            MainMenu.getSetUp().addClickableItemStack("cost to lower the difficulty", Material.DIAMOND, costToLowerTheDifficulty, 3);
        } else {
            MainMenu.getSetUp().addClickableItemStack("cost to lower the difficulty", Material.DIAMOND, 1, 3);
        }
        if (timeToDecideWhenRespawning != 0) {
            MainMenu.getSetUp().addClickableItemStack("time to decide when respawning", Material.CLOCK, timeToDecideWhenRespawning, 4);
        } else {
            MainMenu.getSetUp().addClickableItemStack("time to decide when respawning", Material.CLOCK, 1, 4);
        }
    }

    public void parkourStartHeightSettingsSetInventoryContents() {
        Config config = Config.getInstance();
        int startHeight = config.checkParkourStartHeight();
        for (int i = 0; i < 29; ++i) {
            if (startHeight == i * 10) {
                MainMenu.getParkourStartHeight().addClickableItemStack(Integer.toString(i * 10), Material.GREEN_CONCRETE_POWDER, 1, i);
                continue;
            }
            MainMenu.getParkourStartHeight().addClickableItemStack(Integer.toString(i * 10), Material.RED_CONCRETE_POWDER, 1, i);
        }
    }

    public void parkourLengthSettingsSetInventoryContents() {
        Config config = Config.getInstance();
        int length = config.checkParkourLength();
        for (int i = 0; i < 20; ++i) {
            if (length == i) {
                MainMenu.getParkourLength().addClickableItemStack(Integer.toString(i), Material.GREEN_CONCRETE_POWDER, 1, i);
                continue;
            }
            MainMenu.getParkourLength().addClickableItemStack(Integer.toString(i), Material.RED_CONCRETE_POWDER, 1, i);
        }
    }

    public void costToLowerTheDifficultySettingsSetInventoryContents() {
        Config config = Config.getInstance();
        int length = config.checkCostToLowerTheDifficulty();
        for (int i = 1; i < 11; ++i) {
            if (length == i) {
                MainMenu.getCostToLowerTheDifficulty().addClickableItemStack(Integer.toString(i), Material.GREEN_CONCRETE_POWDER, 1, i - 1);
                continue;
            }
            MainMenu.getCostToLowerTheDifficulty().addClickableItemStack(Integer.toString(i), Material.RED_CONCRETE_POWDER, 1, i - 1);
        }
    }

    public void timeToDecideWhenRespawningSettingsSetInventoryContents() {
        Config config = Config.getInstance();
        int time = config.checkTimeToDecideWhenRespawning();
        for (int i = 5; i < 31; ++i) {
            if (time == i) {
                MainMenu.getTimeToDecideWhenRespawning().addClickableItemStack(Integer.toString(time), Material.GREEN_CONCRETE_POWDER, 1, i - 5);
                continue;
            }
            MainMenu.getTimeToDecideWhenRespawning().addClickableItemStack(Integer.toString(i), Material.RED_CONCRETE_POWDER, 1, i - 5);
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public static enum AnvilUIs {
        SET_SERVER_NAME,
        SET_HOST_NAME,
        DEFAULT;

    }

    public static enum InventoryMenus {
        INTRODUCTION,
        DIFFICULTY,
        USES_PLUGIN,
        DIFFICULTY_SETTINGS,
        SETTINGS,
        SETUP,
        PARKOUR_START_HEIGHT,
        PARKOUR_LENGTH,
        COST_TO_LOWER_THE_DIFFICULTY,
        TIME_TO_DECIDE_WHEN_RESPAWNING,
        SET_HOST,
        SET_SERVER_NAME;

    }
}

