/*
 * Decompiled with CFR 0.152.
 */
package de.j.stationofdoom.listener;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Random;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class PlayerKillListener
implements Listener {
    @EventHandler
    public void onPlayerKill(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (player.getKiller() != null && player.getKiller() instanceof Player && this.drop(2)) {
            Player killer = player.getKiller();
            ItemStack head = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)head.getItemMeta();
            assert (meta != null);
            meta.setOwningPlayer((OfflinePlayer)player);
            ArrayList<Component> lore = new ArrayList<Component>();
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");
            LocalDateTime now = LocalDateTime.now();
            lore.add(Component.text((String)("Killed on " + dtf.format(now))).color((TextColor)NamedTextColor.GREEN));
            lore.add(Component.text((String)("Killed by " + killer.getName())).color((TextColor)NamedTextColor.YELLOW));
            meta.lore(lore);
            head.setItemMeta((ItemMeta)meta);
            player.getWorld().dropItem(player.getLocation(), head);
        }
    }

    private boolean drop(int bound) {
        return new Random().nextInt(bound) == 1;
    }
}

