/*
 * Decompiled with CFR 0.152.
 */
package de.j.stationofdoom.util.translations;

import de.j.stationofdoom.main.Main;
import de.j.stationofdoom.util.translations.LanguageEnums;
import de.j.stationofdoom.util.translations.TranslationFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class LanguageChanger {
    private static YamlConfiguration config;
    private static File configFile;
    private static HashMap<Player, LanguageEnums> playersLang;

    public static void init() {
        configFile = new File("plugins//StationofDoom//lang.yml");
        config = YamlConfiguration.loadConfiguration((File)configFile);
        playersLang = new HashMap();
        Main.getMainLogger().info("Initiated language changer");
    }

    public static void setPlayerLanguage(Player player, LanguageEnums language) {
        try {
            assert (config != null);
            assert (configFile != null);
            config.set("player.lang." + String.valueOf(player.getUniqueId()), (Object)language.getKey());
            config.save(configFile);
            playersLang.put(player, language);
            player.sendMessage(Component.text((String)new TranslationFactory().getTranslation(player, "ChangeLanguageSuccess")).color((TextColor)NamedTextColor.GREEN));
        }
        catch (IOException e) {
            player.sendMessage(Component.text((String)new TranslationFactory().getTranslation(player, "ChangeLanguageException")).color((TextColor)NamedTextColor.RED));
            throw new RuntimeException(e);
        }
    }

    public LanguageEnums getPlayerLanguage(Player player) {
        assert (config != null);
        assert (configFile != null);
        if (playersLang.get(player) == null) {
            return LanguageEnums.getLangFromKey(config.getString("player.lang." + String.valueOf(player.getUniqueId())));
        }
        if (playersLang.get(player) != null) {
            return playersLang.get(player);
        }
        return LanguageEnums.EN;
    }

    public static boolean hasPlayerLanguage(Player player) {
        if (config.getString("player.lang." + String.valueOf(player.getUniqueId())) != null) {
            playersLang.put(player, LanguageEnums.getLangFromKey(config.getString("player.lang." + String.valueOf(player.getUniqueId()))));
            return true;
        }
        if (playersLang.get(player) != null) {
            return true;
        }
        LanguageChanger.setDefaultLanguage(player);
        return false;
    }

    private static void setDefaultLanguage(Player player) {
        LanguageChanger.setPlayerLanguage(player, LanguageEnums.EN);
    }
}

