/*
 * Decompiled with CFR 0.152.
 */
package de.j.stationofdoom.util.translations;

import com.google.gson.Gson;
import de.j.stationofdoom.main.Main;
import de.j.stationofdoom.util.translations.LanguageChanger;
import de.j.stationofdoom.util.translations.LanguageEnums;
import de.j.stationofdoom.util.translations.Translation;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class TranslationFactory {
    private static boolean initialized = false;
    private static final Map<String, Map<LanguageEnums, String>> translations = new HashMap<String, Map<LanguageEnums, String>>();
    private static LanguageEnums lang;

    public TranslationFactory() {
        FileConfiguration config;
        if (!initialized) {
            this.init();
        }
        if ((config = Main.getPlugin().getConfig()).getString("server.lang") != null) {
            assert (config.getString("server.lang") != null);
            lang = LanguageEnums.getLangFromKey(config.getString("server.lang"));
        }
    }

    private void init() {
        TranslationFactory.initTranslations();
    }

    public static void initTranslations() {
        Main.getMainLogger().info("Loading translations!");
        try (InputStreamReader reader = new InputStreamReader(TranslationFactory.class.getResourceAsStream("/translations.json"), StandardCharsets.UTF_8);){
            Gson gson = new Gson();
            Map map = (Map)gson.fromJson((Reader)reader, HashMap.class);
            for (String l : map.keySet()) {
                Map value = (Map)((List)map.get(l)).get(0);
                for (String key : value.keySet()) {
                    Map<Object, Object> t = !translations.containsKey(key) ? new HashMap() : translations.get(key);
                    t.put((Object)LanguageEnums.getLangFromKey(l), (String)value.get(key));
                    translations.put(key, t);
                }
            }
            Main.getMainLogger().info("Loaded translations!");
            FileConfiguration config = Main.getPlugin().getConfig();
            if (config.getString("server.lang") != null) {
                assert (config.getString("server.lang") != null);
                lang = LanguageEnums.getLangFromKey(config.getString("server.lang"));
            } else {
                config.set("server.lang", (Object)LanguageEnums.EN.getKey());
            }
            initialized = true;
        }
        catch (IOException e) {
            Main.getMainLogger().severe("Could not load translations \n " + String.valueOf(e));
            throw new RuntimeException(e);
        }
    }

    public String getTranslation(LanguageEnums lang, String key) {
        return this.checkIfTranslationExists(key, lang) ? translations.get(key).get((Object)lang) : "Translation could not be found!";
    }

    public String getTranslation(Player player, String key) {
        LanguageEnums lang = new LanguageChanger().getPlayerLanguage(player);
        return this.checkIfTranslationExists(key, lang) ? translations.get(key).get((Object)lang) : "Translation could not be found!";
    }

    public String getTranslation(LanguageEnums lang, String key, Object ... replaceWords) {
        return this.checkIfTranslationExists(key, lang) ? String.format(translations.get(key).get((Object)lang), replaceWords) : "Translation could not be found!";
    }

    public String getTranslation(Player player, String key, Object ... replaceWords) {
        LanguageEnums lang = new LanguageChanger().getPlayerLanguage(player);
        return this.checkIfTranslationExists(key, lang) ? String.format(translations.get(key).get((Object)lang), replaceWords) : "Translation could not be found!";
    }

    private boolean checkIfTranslationExists(String key, LanguageEnums lang) {
        return translations.getOrDefault(key, Map.of()).containsKey((Object)lang);
    }

    public LanguageEnums getServerLang() {
        return lang;
    }

    public void addTranslation(Translation translation) {
        translations.put(translation.getKey(), translation.getTranslations());
    }

    public void addTranslationsFromFile(InputStreamReader reader) {
        Main.getMainLogger().info("Loading translations from file!");
        Gson gson = new Gson();
        Map map = (Map)gson.fromJson((Reader)reader, HashMap.class);
        for (String l : map.keySet()) {
            Map value = (Map)((List)map.get(l)).get(0);
            for (String key : value.keySet()) {
                if (!translations.containsKey(key)) continue;
                Main.getMainLogger().warning("Key " + key + " already exists! It'll be overwritten");
            }
            for (String key : value.keySet()) {
                System.out.println("key " + key);
                Map<Object, Object> t = !translations.containsKey(key) ? new HashMap() : translations.get(key);
                t.put((Object)LanguageEnums.getLangFromKey(l), (String)value.get(key));
                translations.put(key, t);
            }
        }
        Main.getMainLogger().info("Loaded translations from file!");
    }
}

