/*
 * Decompiled with CFR 0.152.
 */
package de.j.deathMinigames.commands;

import de.j.deathMinigames.main.HandlePlayers;
import de.j.deathMinigames.main.PlayerData;
import de.j.stationofdoom.util.translations.TranslationFactory;
import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LeaderboardCMD
implements BasicCommand {
    public boolean canUse(@NotNull CommandSender sender) {
        return sender instanceof Player;
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Player player = (Player)stack.getSender();
        TranslationFactory tf = new TranslationFactory();
        HandlePlayers handlePlayers = HandlePlayers.getInstance();
        List<PlayerData> leaderboard = handlePlayers.getLeaderBoard();
        if (args.length == 0) {
            if (leaderboard.isEmpty()) {
                player.sendMessage(Component.text((String)tf.getTranslation(player, "leaderboardEmpty")).color((TextColor)NamedTextColor.RED));
                return;
            }
            player.sendMessage(tf.getTranslation(player, "leaderboard"));
            player.sendMessage("------------------");
            for (int i = 0; i < leaderboard.size() && i < 10; ++i) {
                PlayerData playerData = leaderboard.get(i);
                player.sendMessage((Component)Component.text((String)(i + 1 + ". " + playerData.getName() + " - " + playerData.getBestParkourTime() + "s")));
            }
            player.sendMessage("------------------");
        } else if (args.length == 1 && player.isOp()) {
            if (args[0].equalsIgnoreCase("reset")) {
                handlePlayers.resetLeaderboardAndTimesOfPlayers();
                player.sendMessage((Component)Component.text((String)tf.getTranslation(player, "leaderboardReset")));
            } else {
                player.sendMessage(Component.text((String)tf.getTranslation(player, "invalidArgument")).color((TextColor)NamedTextColor.RED));
            }
        }
    }

    @NotNull
    public Collection<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        Player player = (Player)stack.getSender();
        if (player.isOp()) {
            suggestions.add("reset");
        }
        return suggestions;
    }
}

