/*
 * Decompiled with CFR 0.152.
 */
package de.j.deathMinigames.main;

import de.j.deathMinigames.database.PlayerDataDatabase;
import de.j.deathMinigames.main.PlayerData;
import de.j.deathMinigames.minigames.Minigame;
import de.j.stationofdoom.main.Main;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;

public class HandlePlayers {
    private static volatile HandlePlayers instance;
    private static final HashMap<UUID, PlayerData> knownPlayers;
    public static volatile ArrayList<Player> waitingListMinigame;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized HandlePlayers getInstance() {
        if (instance != null) return instance;
        Class<HandlePlayers> clazz = HandlePlayers.class;
        synchronized (HandlePlayers.class) {
            if (instance != null) return instance;
            instance = new HandlePlayers();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private HandlePlayers() {
    }

    public static HashMap<UUID, PlayerData> getKnownPlayers() {
        return knownPlayers;
    }

    public static void initKnownPlayersPlayerData() {
        PlayerDataDatabase playerDataDatabase = PlayerDataDatabase.getInstance();
        for (PlayerData playerData : playerDataDatabase.getAllPlayerDatas()) {
            knownPlayers.put(playerData.getUUID(), playerData);
        }
        Main.getMainLogger().info("Loaded " + knownPlayers.size() + " known players and their data");
    }

    public boolean checkIfPlayerIsKnown(UUID uuid) {
        return knownPlayers.containsKey(uuid);
    }

    public synchronized void addNewPlayer(Player player) {
        PlayerData playerData = new PlayerData(player);
        UUID playerUUID = player.getUniqueId();
        if (this.checkIfPlayerIsKnown(playerUUID)) {
            Main.getMainLogger().warning("Player " + String.valueOf(playerUUID) + " was tried to add, but is already known!");
            return;
        }
        knownPlayers.put(playerUUID, playerData);
        Main.getMainLogger().info("Added new player " + playerData.getName());
    }

    public static void copyAllPlayerDataIntoDatabase() {
        PlayerDataDatabase playerDataDatabase = PlayerDataDatabase.getInstance();
        playerDataDatabase.updatePlayerDataDatabase(knownPlayers.values());
    }

    public List<PlayerData> getLeaderBoard() {
        float defaultTime = 1000.0f;
        ArrayList<PlayerData> leaderboard = new ArrayList<PlayerData>();
        for (PlayerData playerData : knownPlayers.values()) {
            if (playerData.getBestParkourTime() == defaultTime) continue;
            leaderboard.add(playerData);
        }
        leaderboard.sort(Comparator.comparing(PlayerData::getBestParkourTime));
        return leaderboard;
    }

    public void resetLeaderboardAndTimesOfPlayers() {
        for (PlayerData playerData : knownPlayers.values()) {
            playerData.setBestParkourTime(1000.0f);
        }
    }

    public void checkIfPlayerLeftWhileInWaitingList(Player player) {
        if (waitingListMinigame.contains(player)) {
            Main.getMainLogger().info("Player " + player.getName() + " left while in waiting list");
            HandlePlayers.getKnownPlayers().get(player.getUniqueId()).setLeftWhileProcessing(true);
            waitingListMinigame.remove(player);
            Minigame.getInstance().dropInvAndClearData(player);
        }
    }

    public void handlePlayerLeftWhileProcessing(Player player) {
        PlayerData playerData = HandlePlayers.getKnownPlayers().get(player.getUniqueId());
        if (playerData.getLeftWhileProcessing()) {
            Minigame.getInstance().tpPlayerToRespawnLocation(player);
            playerData.setLeftWhileProcessing(false);
        }
    }

    static {
        knownPlayers = new HashMap();
        waitingListMinigame = new ArrayList();
    }
}

