/*
 * Decompiled with CFR 0.152.
 */
package de.j.deathMinigames.main;

import de.j.deathMinigames.main.Config;
import de.j.deathMinigames.main.PlayerMinigameStatus;
import de.j.stationofdoom.main.Main;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class PlayerData {
    private volatile String name;
    private volatile UUID uuid;
    private final Player player;
    private volatile PlayerMinigameStatus status;
    private volatile Inventory lastDeathInventory = Bukkit.createInventory(null, (int)54);
    private volatile Location lastDeathLocation;
    private volatile boolean introduction;
    private volatile boolean usesPlugin;
    private volatile int difficulty;
    private volatile int decisionTimer;
    private volatile float bestParkourTime;
    private volatile boolean leftWhileProcessing;

    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    public synchronized UUID getUUID() {
        return this.uuid;
    }

    public synchronized void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public synchronized Player getPlayer() {
        return this.player;
    }

    public synchronized PlayerMinigameStatus getStatus() {
        return this.status;
    }

    public synchronized void setStatus(PlayerMinigameStatus status) {
        this.status = status;
    }

    public synchronized Inventory getLastDeathInventory() {
        if (this.lastDeathInventory == null) {
            Main.getMainLogger().warning("Tried accessing lastDeathInventory of " + this.name + " but inventory is not set!");
            return Bukkit.createInventory(null, (int)54);
        }
        return this.lastDeathInventory;
    }

    public synchronized void setLastDeathInventoryContents(Inventory lastDeathInventory) {
        this.lastDeathInventory.setContents(lastDeathInventory.getContents());
    }

    public synchronized Location getLastDeathLocation() {
        if (this.lastDeathLocation == null) {
            Main.getMainLogger().warning("Tried accessing lastDeathLocation of " + this.name + " but location is not set!");
            return new Location(Bukkit.getWorld((String)"world"), 0.0, 0.0, 0.0);
        }
        return this.lastDeathLocation;
    }

    public synchronized void setLastDeathLocation(Location lastDeathLocation) {
        this.lastDeathLocation = lastDeathLocation;
    }

    public synchronized int getDecisionTimer() {
        return this.decisionTimer;
    }

    public synchronized void setDecisionTimer(int decisionTimer) {
        this.decisionTimer = decisionTimer;
    }

    public synchronized float getBestParkourTime() {
        return new BigDecimal(this.bestParkourTime).setScale(2, RoundingMode.HALF_UP).floatValue();
    }

    public synchronized void setBestParkourTime(float bestParkourTime) {
        this.bestParkourTime = bestParkourTime;
    }

    public synchronized int getDifficulty() {
        return this.difficulty;
    }

    public synchronized void setDifficulty(int difficulty) {
        this.difficulty = difficulty;
    }

    public synchronized boolean getIntroduction() {
        return this.introduction;
    }

    public synchronized void setIntroduction(boolean introduced) {
        this.introduction = introduced;
    }

    public synchronized boolean getUsesPlugin() {
        return this.usesPlugin;
    }

    public synchronized void setUsesPlugin(boolean usesPlugin) {
        this.usesPlugin = usesPlugin;
    }

    public boolean getLeftWhileProcessing() {
        return this.leftWhileProcessing;
    }

    public void setLeftWhileProcessing(boolean leftWhileProcessing) {
        this.leftWhileProcessing = leftWhileProcessing;
    }

    public PlayerData(Player player) {
        Config config = Config.getInstance();
        this.name = player.getName();
        this.uuid = player.getUniqueId();
        this.player = player;
        this.status = PlayerMinigameStatus.ALIVE;
        this.lastDeathInventory = Bukkit.createInventory(null, (int)54);
        this.decisionTimer = config.checkTimeToDecideWhenRespawning();
        this.bestParkourTime = 1000.0f;
        this.difficulty = 0;
        this.introduction = false;
        this.usesPlugin = true;
        this.leftWhileProcessing = false;
    }

    public PlayerData(String name, String uuid, boolean introduction, boolean usesPlugin, int difficulty, float bestParkourTime) {
        Config config = Config.getInstance();
        this.name = name;
        this.uuid = UUID.fromString(uuid);
        this.player = Bukkit.getPlayer((String)uuid);
        this.status = PlayerMinigameStatus.ALIVE;
        this.lastDeathInventory = Bukkit.createInventory(null, (int)54);
        this.decisionTimer = config.checkTimeToDecideWhenRespawning();
        this.bestParkourTime = bestParkourTime;
        this.difficulty = difficulty;
        this.introduction = introduction;
        this.usesPlugin = usesPlugin;
        this.leftWhileProcessing = false;
    }

    public void updateName() {
        this.name = this.player.getName();
    }

    public void setDecisionTimerDefault() {
        Config config = Config.getInstance();
        this.decisionTimer = config.checkTimeToDecideWhenRespawning();
    }

    public void resetDecisionTimerAndStatus() {
        this.status = PlayerMinigameStatus.ALIVE;
        this.setDecisionTimerDefault();
    }
}

