/*
 * Decompiled with CFR 0.152.
 */
package de.j.deathMinigames.minigames;

import de.j.deathMinigames.dmUtil.DmUtil;
import de.j.deathMinigames.main.Config;
import de.j.deathMinigames.main.HandlePlayers;
import de.j.deathMinigames.main.Introduction;
import de.j.deathMinigames.main.PlayerData;
import de.j.deathMinigames.main.PlayerMinigameStatus;
import de.j.deathMinigames.minigames.Difficulty;
import de.j.deathMinigames.minigames.JumpAndRun;
import de.j.deathMinigames.minigames.WaitingListPositionTimer;
import de.j.stationofdoom.main.Main;
import de.j.stationofdoom.util.translations.TranslationFactory;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class Minigame {
    private static volatile Minigame instance;

    private Minigame() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Minigame getInstance() {
        if (instance != null) return instance;
        Class<Minigame> clazz = Minigame.class;
        synchronized (Minigame.class) {
            if (instance != null) return instance;
            instance = new Minigame();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void minigameStart(Player playerToStart) {
        if (playerToStart == null) {
            throw new NullPointerException("player is null");
        }
        PlayerData playerData = HandlePlayers.getKnownPlayers().get(playerToStart.getUniqueId());
        if (playerData == null) {
            throw new NullPointerException("playerData is null!");
        }
        JumpAndRun jumpAndRun = JumpAndRun.getInstance();
        Introduction introduction = new Introduction();
        Config config = Config.getInstance();
        TranslationFactory tf = new TranslationFactory();
        if (!playerData.getIntroduction()) {
            introduction.introStart(playerToStart);
            return;
        }
        if (!playerData.getUsesPlugin()) {
            return;
        }
        if (!HandlePlayers.waitingListMinigame.contains(playerToStart)) {
            HandlePlayers.waitingListMinigame.addLast(playerToStart);
        }
        if (!JumpAndRun.getInstance().getRunning()) {
            playerData.setStatus(PlayerMinigameStatus.IN_MINIGAME);
            jumpAndRun.start();
        } else {
            playerData.setStatus(PlayerMinigameStatus.IN_WAITING_LIST);
            playerToStart.sendMessage(Component.text((String)tf.getTranslation(playerToStart, "arenaIsFull")).color((TextColor)NamedTextColor.GOLD));
            Location locationBox = config.checkWaitingListLocation();
            if (locationBox != null) {
                this.teleportPlayerInBox(playerToStart, locationBox);
            } else {
                Main.getMainLogger().warning("WaitingListPosition is not set in the config!");
                this.teleportPlayerInBox(playerToStart, playerToStart.getRespawnLocation());
                playerToStart.sendMessage(tf.getTranslation(playerToStart, "waitingListPositionNotSet"));
            }
        }
    }

    public void sendStartMessage(Player player, String message) {
        if (player == null) {
            throw new NullPointerException("player is null!");
        }
        PlayerData playerData = HandlePlayers.getKnownPlayers().get(player.getUniqueId());
        if (playerData == null) {
            throw new NullPointerException("playerData is null!");
        }
        Inventory lastDeathInventory = Bukkit.createInventory(null, (int)54);
        lastDeathInventory.setContents(playerData.getLastDeathInventory().getContents());
        player.sendMessage(Component.text((String)message).color((TextColor)NamedTextColor.GOLD));
        assert (!lastDeathInventory.isEmpty()) : "lastDeathInventory is empty!";
        playerData.setStatus(PlayerMinigameStatus.IN_MINIGAME);
    }

    public void sendLoseMessage(Player player) {
        TranslationFactory tf = new TranslationFactory();
        if (player == null) {
            throw new NullPointerException("player is null");
        }
        PlayerData playerData = HandlePlayers.getKnownPlayers().get(player.getUniqueId());
        if (playerData == null) {
            throw new NullPointerException("playerData is null!");
        }
        Location deathLocation = playerData.getLastDeathLocation();
        assert (deathLocation != null) : "lastDeathInventory is null";
        playerData.setStatus(PlayerMinigameStatus.ALIVE);
        if (playerData.getUsesPlugin()) {
            player.sendMessage(MiniMessage.miniMessage().deserialize((Object)Component.text((String)tf.getTranslation(player, "loseMessage", "X: " + deathLocation.getBlockX() + " Y: " + deathLocation.getBlockY() + " Z: " + deathLocation.getBlockZ())).content()));
        }
    }

    public void dropInvAndClearData(Player player) {
        DmUtil util = DmUtil.getInstance();
        if (player == null) {
            throw new NullPointerException("player is null");
        }
        PlayerData playerData = HandlePlayers.getKnownPlayers().get(player.getUniqueId());
        if (playerData == null) {
            throw new NullPointerException("playerData is null!");
        }
        Location deathLocation = playerData.getLastDeathLocation();
        if (deathLocation == null) {
            throw new NullPointerException("deathLocation is null!");
        }
        util.dropInv(player, deathLocation);
    }

    public void tpPlayerToRespawnLocation(Player player) {
        if (player == null) {
            throw new NullPointerException("player is null");
        }
        if (player.getRespawnLocation() == null) {
            player.playSound(player.getEyeLocation(), Sound.BLOCK_PORTAL_TRAVEL, 0.5f, 1.0f);
            player.teleport(player.getWorld().getSpawnLocation());
        } else {
            player.playSound(player.getEyeLocation(), Sound.BLOCK_PORTAL_TRAVEL, 0.5f, 1.0f);
            player.teleport(player.getRespawnLocation());
        }
    }

    public void sendWinMessage(Player player) {
        Difficulty difficulty = Difficulty.getInstance();
        TranslationFactory tf = new TranslationFactory();
        if (player == null) {
            throw new NullPointerException("player is null");
        }
        PlayerData playerData = HandlePlayers.getKnownPlayers().get(player.getUniqueId());
        if (playerData == null) {
            throw new NullPointerException("playerData is null!");
        }
        player.sendMessage(Component.text((String)tf.getTranslation(player, "winMessage")).color((TextColor)NamedTextColor.GOLD));
        if (playerData.getDifficulty() < 10) {
            difficulty.higherDifficulty(player);
            player.sendMessage(MiniMessage.miniMessage().deserialize((Object)Component.text((String)tf.getTranslation(player, "changedDiff", playerData.getDifficulty())).content()));
        }
    }

    public void showInv(Player player) {
        DmUtil util = DmUtil.getInstance();
        if (player == null) {
            throw new NullPointerException("player is null");
        }
        TranslationFactory tf = new TranslationFactory();
        Inventory inventory = Bukkit.createInventory(null, (int)54, (Component)Component.text((String)tf.getTranslation(player, "winInv")).color((TextColor)NamedTextColor.GOLD));
        PlayerData playerData = HandlePlayers.getKnownPlayers().get(player.getUniqueId());
        if (playerData == null) {
            throw new NullPointerException("playerData is null!");
        }
        Inventory lastDeathInventory = playerData.getLastDeathInventory();
        if (lastDeathInventory.isEmpty()) {
            throw new NullPointerException("playerDeathInventory is empty");
        }
        try {
            inventory.setContents(lastDeathInventory.getContents());
            this.tpPlayerToRespawnLocation(player);
            playerData.setStatus(PlayerMinigameStatus.ALIVE);
            player.openInventory(inventory);
            util.playSoundAtLocation(player.getLocation(), Float.valueOf(1.0f), Sound.ITEM_TOTEM_USE);
        }
        catch (Exception e) {
            Main.getMainLogger().warning("Failed to show inventory to " + player.getName() + e.getMessage());
        }
    }

    public void playSoundToPlayer(Player player, Float volume, Sound sound) {
        player.playSound((Entity)player, sound, volume.floatValue(), 1.0f);
    }

    public void spawnParticles(Player player, Location location, Particle particle) {
        if (player == null) {
            throw new NullPointerException("player is null!");
        }
        if (location == null) {
            throw new NullPointerException("location is null!");
        }
        if (particle == null) {
            throw new NullPointerException("particle is null!");
        }
        int count = 20;
        boolean offsetX = true;
        boolean offsetY = true;
        boolean offsetZ = true;
        player.getWorld().spawnParticle(particle, location, count, (double)offsetX, (double)offsetY, (double)offsetZ);
    }

    public void teleportPlayerInBox(Player player, Location locationOfBox) {
        if (player == null) {
            throw new NullPointerException("player is null!");
        }
        if (locationOfBox == null) {
            throw new NullPointerException("location is null!");
        }
        if (locationOfBox.getWorld() == null) {
            throw new IllegalArgumentException("Location must have a valid world!");
        }
        player.teleport(locationOfBox);
        WaitingListPositionTimer.getInstance().run(player);
    }
}

