/*
 * Decompiled with CFR 0.152.
 */
package de.j.deathMinigames.settings;

import de.j.deathMinigames.settings.MainMenu;
import de.j.stationofdoom.util.Tablist;
import de.j.stationofdoom.util.translations.TranslationFactory;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class AnvilUI
implements InventoryHolder {
    private Location loc = null;
    private ItemStack input = new ItemStack(Material.RED_CONCRETE);
    Player player = null;
    private MainMenu.AnvilUIs title;

    public AnvilUI(MainMenu.AnvilUIs title) {
        if (title == null) {
            throw new IllegalArgumentException("Title cannot be null");
        }
        this.title = title;
        this.createUniqueLocation();
    }

    public void showInventory(Player playerToShowTheInvTo) {
        if (playerToShowTheInvTo == null) {
            return;
        }
        this.player = playerToShowTheInvTo;
        playerToShowTheInvTo.openAnvil(this.loc, true);
        this.setInputMeta(playerToShowTheInvTo);
        playerToShowTheInvTo.getOpenInventory().getTopInventory().setItem(0, this.input);
    }

    @NotNull
    public Inventory getInventory() {
        return null;
    }

    private void createUniqueLocation() {
        World world = Bukkit.getWorld((String)"world");
        if (world == null) {
            throw new IllegalStateException("world `world\u00b4 could not be found");
        }
        this.loc = new Location(world, (double)ThreadLocalRandom.current().nextInt(0, 1000), (double)ThreadLocalRandom.current().nextInt(0, 1000), (double)ThreadLocalRandom.current().nextInt(0, 1000));
    }

    public boolean compareLocIDTo(Location loc) {
        return loc.getBlockX() == this.loc.getBlockX() && loc.getBlockZ() == this.loc.getBlockZ();
    }

    private void setInputMeta(Player player) {
        ItemMeta inputMeta = this.input.getItemMeta();
        String inputItemName = null;
        if (player == null) {
            inputMeta.displayName((Component)Component.text((String)"default"));
        } else {
            switch (this.title) {
                case SET_HOST_NAME: {
                    inputItemName = Tablist.getHostedBy();
                    break;
                }
                case SET_SERVER_NAME: {
                    inputItemName = Tablist.getServerName();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Title: " + String.valueOf((Object)this.title) + " is not supported");
                }
            }
            if (inputItemName == null) {
                inputMeta.displayName((Component)Component.text((String)new TranslationFactory().getTranslation(player, "noNameSet")));
            } else {
                inputMeta.displayName((Component)Component.text((String)inputItemName));
            }
        }
        this.input.setItemMeta(inputMeta);
    }
}

