/*
 * Decompiled with CFR 0.152.
 */
package de.j.stationofdoom.listener;

import de.j.stationofdoom.main.Main;
import de.j.stationofdoom.util.EntityManager;
import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PlayerSitListener
implements Listener,
BasicCommand {
    private static final ArrayList<Player> sitting = new ArrayList();
    private static final NamespacedKey KEY = new NamespacedKey((Plugin)Main.getPlugin(), "Chair");

    @EventHandler
    public void onDismount(EntityDismountEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Entity entity2 = event.getDismounted();
        if (!(entity2 instanceof ArmorStand)) {
            return;
        }
        ArmorStand armorStand = (ArmorStand)entity2;
        if (sitting.contains(player) && ((Boolean)armorStand.getPersistentDataContainer().getOrDefault(KEY, PersistentDataType.BOOLEAN, (Object)false)).booleanValue()) {
            armorStand.remove();
            player.teleport(new Location(player.getWorld(), player.getX(), player.getY() + 0.2, player.getZ()), PlayerTeleportEvent.TeleportCause.DISMOUNT);
            sitting.remove(player);
        }
    }

    public void execute(@NotNull CommandSourceStack commandSourceStack, @NotNull String[] strings) {
        assert (commandSourceStack.getSender() instanceof Player);
        Player player = (Player)commandSourceStack.getSender();
        if (!player.isOnGround()) {
            player.sendMessage(Component.text((String)"You cannot sit while you are in the air!").color((TextColor)NamedTextColor.RED));
            return;
        }
        if (sitting.contains(player)) {
            player.sendMessage(Component.text((String)"You are already sitting!").color((TextColor)NamedTextColor.RED));
            return;
        }
        sitting.add(player);
        Location location = player.getLocation();
        World world = location.getWorld();
        ArmorStand chair = (ArmorStand)world.spawnEntity(location.add(0.0, -1.8, 0.0), EntityType.ARMOR_STAND);
        chair.setGravity(false);
        chair.setVisible(false);
        chair.setInvulnerable(false);
        chair.addPassenger((Entity)player);
        chair.getPersistentDataContainer().set(KEY, PersistentDataType.BOOLEAN, (Object)true);
        EntityManager.addEntity(KEY, EntityType.ARMOR_STAND);
    }

    public boolean canUse(@NotNull CommandSender sender) {
        return sender instanceof Player;
    }
}

