/*
 * Decompiled with CFR 0.152.
 */
package de.j.stationofdoom.util;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import de.j.stationofdoom.main.Main;
import de.j.stationofdoom.util.Heads;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemBuilder {
    private ItemStack item;
    private ItemMeta meta;

    public ItemBuilder(Material material) {
        this.item = new ItemStack(material);
        this.meta = this.item.getItemMeta();
    }

    public ItemBuilder setAmount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    public ItemBuilder setName(String name) {
        this.meta.displayName((Component)Component.text((String)name));
        return this;
    }

    public ItemBuilder setName(Component name) {
        this.meta.displayName(name);
        return this;
    }

    public ItemStack build() {
        this.item.setItemMeta(this.meta);
        return this.item;
    }

    public ItemBuilder addLore(List<String> lore) {
        ArrayList l = new ArrayList();
        lore.forEach(lo -> l.add(Component.text((String)lo)));
        this.meta.lore(l);
        return this;
    }

    public ItemBuilder addLore(List<String> lore, NamedTextColor color) {
        ArrayList l = new ArrayList();
        lore.forEach(lo -> l.add(Component.text((String)lo).color((TextColor)color)));
        this.meta.lore(l);
        return this;
    }

    public ItemBuilder addPDC(String key, String value) {
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)Main.getPlugin(), key);
        this.meta.getPersistentDataContainer().set(namespacedKey, PersistentDataType.STRING, (Object)value);
        return this;
    }

    public ItemBuilder addEnchantment(Enchantment enchantment, int i, boolean b) {
        this.meta.addEnchant(enchantment, i, b);
        return this;
    }

    public ItemBuilder addFlags(ItemFlag ... itemFlags) {
        this.meta.addItemFlags(itemFlags);
        return this;
    }

    public static ItemStack createHead(String url, String name) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD, 1);
        if (url.isEmpty()) {
            return head;
        }
        SkullMeta headMeta = (SkullMeta)head.getItemMeta();
        GameProfile profile = new GameProfile(UUID.randomUUID(), name);
        profile.properties().put((Object)"textures", (Object)new Property("textures", url));
        try {
            assert (headMeta != null);
            Field profileField = headMeta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(headMeta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            Main.getMainLogger().severe("An error approached while create head!");
        }
        head.setItemMeta((ItemMeta)headMeta);
        return head;
    }

    public ItemBuilder getHeadBuilder(String url, String name) {
        this.item = new ItemStack(Material.PLAYER_HEAD, 1);
        if (url.isEmpty()) {
            return null;
        }
        this.meta = this.item.getItemMeta();
        GameProfile profile = new GameProfile(UUID.randomUUID(), name);
        profile.properties().put((Object)"textures", (Object)new Property("textures", url));
        try {
            assert (this.meta != null);
            Field profileField = this.meta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(this.meta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            Main.getMainLogger().severe("An error approached while create head!");
        }
        this.item.setItemMeta(this.meta);
        return this;
    }

    public static ItemStack getHead(String name) {
        for (Heads head : Heads.values()) {
            if (!head.getName().equalsIgnoreCase(name)) continue;
            return head.getItemStack();
        }
        Main.getMainLogger().severe("An error appeared in while getting a head");
        return null;
    }
}

