/*
 * Decompiled with CFR 0.152.
 */
package com.example.serveranalytics;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class DataManager {
    private final Path dataDirectory;
    private final Gson gson;
    private final Path playerDataFile;
    private final Path playerCountFile;
    private final Path playTimeFile;
    private Map<String, PlayerData> playerData = new ConcurrentHashMap<String, PlayerData>();
    private List<PlayerCountEntry> playerCountHistory = Collections.synchronizedList(new ArrayList());
    private Map<UUID, Long> totalPlayTimes = new ConcurrentHashMap<UUID, Long>();
    private int peakPlayerCount = 0;
    private LocalDate peakPlayerDate;
    private long serverStartTime;

    public DataManager(Path dataDirectory) {
        this.dataDirectory = dataDirectory;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.playerDataFile = dataDirectory.resolve("playerData.json");
        this.playerCountFile = dataDirectory.resolve("playerCounts.json");
        this.playTimeFile = dataDirectory.resolve("playTimes.json");
        this.serverStartTime = System.currentTimeMillis();
    }

    public void initialize() throws IOException {
        BufferedReader reader;
        if (!Files.exists(this.dataDirectory, new LinkOption[0])) {
            Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
        }
        if (Files.exists(this.playerDataFile, new LinkOption[0])) {
            reader = Files.newBufferedReader(this.playerDataFile);
            try {
                this.playerData = (Map)this.gson.fromJson((Reader)reader, new TypeToken<Map<String, PlayerData>>(this){}.getType());
                if (this.playerData == null) {
                    this.playerData = new ConcurrentHashMap<String, PlayerData>();
                }
            }
            finally {
                if (reader != null) {
                    ((Reader)reader).close();
                }
            }
        }
        if (Files.exists(this.playerCountFile, new LinkOption[0])) {
            reader = Files.newBufferedReader(this.playerCountFile);
            try {
                Optional<PlayerCountEntry> peak;
                this.playerCountHistory = (List)this.gson.fromJson((Reader)reader, new TypeToken<List<PlayerCountEntry>>(this){}.getType());
                if (this.playerCountHistory == null) {
                    this.playerCountHistory = Collections.synchronizedList(new ArrayList());
                }
                if ((peak = this.playerCountHistory.stream().max(Comparator.comparingInt(entry -> entry.count))).isPresent()) {
                    this.peakPlayerCount = peak.get().count;
                    this.peakPlayerDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(peak.get().timestamp), ZoneId.systemDefault()).toLocalDate();
                }
            }
            finally {
                if (reader != null) {
                    ((Reader)reader).close();
                }
            }
        }
        if (Files.exists(this.playTimeFile, new LinkOption[0])) {
            reader = Files.newBufferedReader(this.playTimeFile);
            try {
                this.totalPlayTimes = (Map)this.gson.fromJson((Reader)reader, new TypeToken<Map<UUID, Long>>(this){}.getType());
                if (this.totalPlayTimes == null) {
                    this.totalPlayTimes = new ConcurrentHashMap<UUID, Long>();
                }
            }
            finally {
                if (reader != null) {
                    ((Reader)reader).close();
                }
            }
        }
    }

    public void saveData() {
        try {
            try (BufferedWriter writer = Files.newBufferedWriter(this.playerDataFile, new OpenOption[0]);){
                this.gson.toJson(this.playerData, (Appendable)writer);
            }
            writer = Files.newBufferedWriter(this.playerCountFile, new OpenOption[0]);
            try {
                this.gson.toJson(this.playerCountHistory, (Appendable)writer);
            }
            finally {
                if (writer != null) {
                    ((Writer)writer).close();
                }
            }
            writer = Files.newBufferedWriter(this.playTimeFile, new OpenOption[0]);
            try {
                this.gson.toJson(this.totalPlayTimes, (Appendable)writer);
            }
            finally {
                if (writer != null) {
                    ((Writer)writer).close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void recordPlayerLogin(UUID playerId, String username) {
        String playerIdStr = playerId.toString();
        PlayerData data = this.playerData.getOrDefault(playerIdStr, new PlayerData(playerId, username));
        data.lastLogin = System.currentTimeMillis();
        ++data.loginCount;
        this.playerData.put(playerIdStr, data);
        this.saveData();
    }

    public void recordPlayerSession(UUID playerId, String username, long sessionTimeSeconds) {
        System.out.println("=== Recording Player Session ===");
        System.out.println("Player: " + username + " (UUID: " + String.valueOf(playerId) + ")");
        System.out.println("Session time: " + sessionTimeSeconds + " seconds");
        Long currentTime = this.totalPlayTimes.getOrDefault(playerId, 0L);
        System.out.println("Current total time: " + currentTime + " seconds");
        this.totalPlayTimes.put(playerId, currentTime + sessionTimeSeconds);
        System.out.println("New total time: " + String.valueOf(this.totalPlayTimes.get(playerId)) + " seconds");
        System.out.println("Total playtimes map now has " + this.totalPlayTimes.size() + " entries");
        this.totalPlayTimes.put(playerId, this.totalPlayTimes.getOrDefault(playerId, 0L) + sessionTimeSeconds);
        String playerIdStr = playerId.toString();
        PlayerData data = this.playerData.getOrDefault(playerIdStr, new PlayerData(playerId, username));
        data.totalPlayTime += sessionTimeSeconds;
        data.username = username;
        this.playerData.put(playerIdStr, data);
        this.saveData();
    }

    public void recordPlayerCount(int count) {
        long timestamp = System.currentTimeMillis();
        PlayerCountEntry entry = new PlayerCountEntry(timestamp, count);
        this.playerCountHistory.add(entry);
        if (count > this.peakPlayerCount) {
            this.peakPlayerCount = count;
            this.peakPlayerDate = LocalDate.now();
        }
        long yearAgo = System.currentTimeMillis() - 31536000000L;
        this.playerCountHistory.removeIf(e -> e.timestamp < yearAgo);
        this.saveData();
    }

    public List<PlayerCountEntry> getPlayerCountHistory() {
        return new ArrayList<PlayerCountEntry>(this.playerCountHistory);
    }

    public List<PlayerCountEntry> getPlayerCountHistory(String period) {
        long now = System.currentTimeMillis();
        return this.playerCountHistory.stream().filter(arg_0 -> DataManager.lambda$getPlayerCountHistory$2(switch (period.toLowerCase()) {
            case "day" -> now - 86400000L;
            case "week" -> now - 604800000L;
            case "month" -> now - 2592000000L;
            case "year" -> now - 31536000000L;
            default -> now - 86400000L;
        }, arg_0)).sorted(Comparator.comparingLong(entry -> entry.timestamp)).collect(Collectors.toList());
    }

    public Map<String, Long> getTopPlaytimes(int limit) {
        if (this.totalPlayTimes.isEmpty()) {
            return new LinkedHashMap<String, Long>();
        }
        return this.totalPlayTimes.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(limit).collect(Collectors.toMap(entry -> this.getPlayerNameById((UUID)entry.getKey()), Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private String getPlayerNameById(UUID id) {
        PlayerData data = this.playerData.get(id.toString());
        return data != null && data.username != null ? data.username : "Player_" + id.toString().substring(0, 8);
    }

    public long getTotalPlaytime() {
        return this.totalPlayTimes.values().stream().mapToLong(Long::longValue).sum();
    }

    public int getPeakPlayerCount() {
        return this.peakPlayerCount;
    }

    public String getPeakPlayerDate() {
        return this.peakPlayerDate != null ? this.peakPlayerDate.format(DateTimeFormatter.ISO_LOCAL_DATE) : "N/A";
    }

    public int getCurrentPlayerCount() {
        if (this.playerCountHistory.isEmpty()) {
            return 0;
        }
        return this.playerCountHistory.stream().max(Comparator.comparing(entry -> entry.timestamp)).map(entry -> entry.count).orElse(0);
    }

    public long getServerStartTime() {
        return this.serverStartTime;
    }

    private static /* synthetic */ boolean lambda$getPlayerCountHistory$2(long cutoff, PlayerCountEntry entry) {
        return entry.timestamp >= cutoff;
    }

    public static class PlayerCountEntry {
        public long timestamp;
        public int count;

        public PlayerCountEntry(long timestamp, int count) {
            this.timestamp = timestamp;
            this.count = count;
        }
    }

    public static class PlayerData {
        public UUID playerId;
        public String username;
        public long lastLogin;
        public int loginCount;
        public long totalPlayTime;

        public PlayerData(UUID playerId, String username) {
            this.playerId = playerId;
            this.username = username;
            this.lastLogin = System.currentTimeMillis();
            this.loginCount = 0;
            this.totalPlayTime = 0L;
        }
    }
}

