/*
 * Decompiled with CFR 0.152.
 */
package com.example.serveranalytics;

import com.example.serveranalytics.DataManager;
import com.example.serveranalytics.WebGenerator;
import com.example.serveranalytics.WebSocketManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ServerAnalytics
extends JavaPlugin
implements Listener {
    private WebSocketManager webSocketManager;
    private static final int DEFAULT_WEB_PORT = 8580;
    private final DataManager dataManager;
    private final long startTimeMs;
    private Map<UUID, Instant> playerJoinTimes = new ConcurrentHashMap<UUID, Instant>();

    public ServerAnalytics() {
        this.startTimeMs = System.currentTimeMillis();
        this.dataManager = new DataManager(this.getDataFolder().toPath());
    }

    public void onEnable() {
        try {
            Path dataDirectory = this.getDataFolder().toPath();
            if (!Files.exists(dataDirectory, new LinkOption[0])) {
                Files.createDirectories(dataDirectory, new FileAttribute[0]);
            }
            this.saveDefaultConfig();
            this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
            this.getLogger().info("Data directory path: " + String.valueOf(dataDirectory.toAbsolutePath()));
            this.getLogger().info("Server start time: " + String.valueOf(new Date(this.startTimeMs)) + " (" + this.startTimeMs + ")");
            this.copyResources();
            this.dataManager.initialize();
            this.webSocketManager = new WebSocketManager(dataDirectory, this.getLogger(), (Plugin)this, this.dataManager, 8580, this.startTimeMs);
            this.webSocketManager.start();
            this.updatePlayerCount();
            Bukkit.getScheduler().runTaskTimer((Plugin)this, this::updatePlayerCount, 100L, 100L);
            Bukkit.getScheduler().runTaskTimer((Plugin)this, this::generateWebPage, 100L, 100L);
            this.getLogger().info("ServerAnalytics initialized!");
            this.getLogger().info("ServerAnalytics dashboard available at: http://localhost:8580");
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to initialize ServerAnalytics: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.playerJoinTimes.put(player.getUniqueId(), Instant.now());
        this.dataManager.recordPlayerLogin(player.getUniqueId(), player.getName());
        this.updatePlayerCount();
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.playerJoinTimes.containsKey(playerId)) {
            Instant joinTime = this.playerJoinTimes.get(playerId);
            Instant leaveTime = Instant.now();
            long sessionTime = Duration.between(joinTime, leaveTime).getSeconds();
            this.dataManager.recordPlayerSession(playerId, player.getName(), sessionTime);
            this.playerJoinTimes.remove(playerId);
            this.updatePlayerCount();
        }
    }

    public void onDisable() {
        for (Player player : this.getServer().getOnlinePlayers()) {
            UUID playerId = player.getUniqueId();
            if (!this.playerJoinTimes.containsKey(playerId)) continue;
            Instant joinTime = this.playerJoinTimes.get(playerId);
            Instant leaveTime = Instant.now();
            long sessionTime = Duration.between(joinTime, leaveTime).getSeconds();
            this.dataManager.recordPlayerSession(playerId, player.getName(), sessionTime);
        }
        if (this.webSocketManager != null) {
            this.webSocketManager.stop();
        }
        this.dataManager.saveData();
        this.getLogger().info("ServerAnalytics shutting down!");
    }

    private void updatePlayerCount() {
        int currentCount = Bukkit.getOnlinePlayers().size();
        this.dataManager.recordPlayerCount(currentCount);
    }

    private void generateWebPage() {
        WebGenerator webGenerator = new WebGenerator(this.getDataFolder().toPath(), this.dataManager, this.startTimeMs);
        webGenerator.generateDashboard();
    }

    private void copyResources() {
        try {
            boolean webFolderExists;
            File webDir = new File(this.getDataFolder(), "web");
            if (!webDir.exists()) {
                webDir.mkdirs();
            }
            boolean bl = webFolderExists = this.getResource("web/index.html") != null;
            if (webFolderExists) {
                this.saveResource("web/index.html", false);
                this.saveResource("web/styles.css", false);
                this.saveResource("web/script.js", false);
                this.getLogger().info("Resources copied from web subfolder");
            } else {
                try {
                    this.saveResource("index.html", false);
                    this.saveResource("styles.css", false);
                    this.saveResource("script.js", false);
                    Files.move(new File(this.getDataFolder(), "index.html").toPath(), new File(webDir, "index.html").toPath(), StandardCopyOption.REPLACE_EXISTING);
                    Files.move(new File(this.getDataFolder(), "styles.css").toPath(), new File(webDir, "styles.css").toPath(), StandardCopyOption.REPLACE_EXISTING);
                    Files.move(new File(this.getDataFolder(), "script.js").toPath(), new File(webDir, "script.js").toPath(), StandardCopyOption.REPLACE_EXISTING);
                    this.getLogger().info("Resources copied from root and moved to web folder");
                }
                catch (Exception e) {
                    this.getLogger().warning("Could not find resources: " + e.getMessage());
                    this.createEmptyWebFiles(webDir);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Error copying resources: " + e.getMessage());
            e.printStackTrace();
        }
        this.getLogger().info("Resources should be available at: " + new File(this.getDataFolder(), "web").getAbsolutePath());
    }

    private void createEmptyWebFiles(File webDir) throws IOException {
        File indexFile = new File(webDir, "index.html");
        try (FileWriter writer = new FileWriter(indexFile);){
            writer.write("<!DOCTYPE html>\n<html>\n<head>\n<title>Minecraft Server Analytics</title>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"styles.css\">\n</head>\n<body>\n<h1>Minecraft Server Analytics</h1>\n<p>Server is running. Web interface initialization in progress...</p>\n<script src=\"script.js\"></script>\n</body>\n</html>");
        }
        File cssFile = new File(webDir, "styles.css");
        try (FileWriter writer = new FileWriter(cssFile);){
            writer.write("body { font-family: Arial, sans-serif; margin: 20px; }\nh1 { color: #333; }");
        }
        File jsFile = new File(webDir, "script.js");
        try (FileWriter writer = new FileWriter(jsFile);){
            writer.write("console.log('Server analytics initializing...');");
        }
        this.getLogger().info("Created basic web files as fallback");
    }

    public long getUptimeSeconds() {
        return Duration.between(Instant.ofEpochMilli(this.startTimeMs), Instant.now()).getSeconds();
    }
}

