/*
 * Decompiled with CFR 0.152.
 */
package com.example.serveranalytics;

import com.example.serveranalytics.DataManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public class WebGenerator {
    private final Path dataDirectory;
    private final DataManager dataManager;
    private final long serverStartTime;

    public WebGenerator(Path dataDirectory, DataManager dataManager, long serverStartTime) {
        this.dataDirectory = dataDirectory;
        this.dataManager = dataManager;
        this.serverStartTime = serverStartTime;
    }

    public void generateDashboard() {
        try {
            String playerCountData = this.generatePlayerCountData();
            String playtimeData = this.generatePlaytimeData();
            Path dataJsPath = this.dataDirectory.resolve("data.js");
            String dataJs = this.generateDataJs(playerCountData, playtimeData);
            Files.writeString(dataJsPath, (CharSequence)dataJs, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String generatePlayerCountData() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        List<DataManager.PlayerCountEntry> entries = this.dataManager.getPlayerCountHistory();
        if (entries.isEmpty()) {
            LocalDateTime startDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.serverStartTime), ZoneId.systemDefault());
            sb.append("  { \"time\": \"").append(startDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME)).append("\", \"count\": 0 }");
        } else {
            if (entries.get((int)0).timestamp > this.serverStartTime) {
                LocalDateTime startDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.serverStartTime), ZoneId.systemDefault());
                sb.append("  { \"time\": \"").append(startDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME)).append("\", \"count\": 0 },\n");
            }
            for (int i = 0; i < entries.size(); ++i) {
                DataManager.PlayerCountEntry entry = entries.get(i);
                LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(entry.timestamp), ZoneId.systemDefault());
                sb.append("  { \"time\": \"").append(dateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME)).append("\", \"count\": ").append(entry.count).append(" }");
                if (i < entries.size() - 1) {
                    sb.append(",\n");
                    continue;
                }
                sb.append("\n");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private String generatePlaytimeData() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        Map<String, Long> topPlaytimes = this.dataManager.getTopPlaytimes(10);
        if (topPlaytimes.isEmpty()) {
            sb.append("  { \"player\": \"No player data\", \"time\": 0 }");
        } else {
            int i = 0;
            for (Map.Entry<String, Long> entry : topPlaytimes.entrySet()) {
                String escapedName = entry.getKey().replace("\"", "\\\"");
                sb.append("  { \"player\": \"").append(escapedName).append("\", \"time\": ").append(entry.getValue()).append(" }");
                if (i < topPlaytimes.size() - 1) {
                    sb.append(",\n");
                } else {
                    sb.append("\n");
                }
                ++i;
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private String generateDataJs(String playerCountData, String playtimeData) {
        String peakDate = this.dataManager.getPeakPlayerDate();
        if (peakDate == null || peakDate.equals("N/A")) {
            peakDate = "No data";
        }
        return "// Auto-generated data file - Do not edit manually\nconst playerCountData = " + playerCountData + ";\n\nconst playerPlaytimeData = " + playtimeData + ";\n\nconst serverStats = {\n  currentPlayerCount: " + this.dataManager.getCurrentPlayerCount() + ",\n  totalPlaytime: " + this.dataManager.getTotalPlaytime() + ",\n  peakPlayerCount: " + this.dataManager.getPeakPlayerCount() + ",\n  peakPlayerDate: \"" + peakDate + "\",\n  lastRestartTime: " + this.serverStartTime + "\n};\n";
    }
}

