/*
 * Decompiled with CFR 0.152.
 */
package com.example.serveranalytics;

import com.example.serveranalytics.DataManager;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.bukkit.plugin.Plugin;

public class WebSocketManager {
    private final Path dataDirectory;
    private final Logger logger;
    private final Plugin plugin;
    private final DataManager dataManager;
    private HttpServer httpServer;
    private final int port;
    private List<ClientConnection> connections = new ArrayList<ClientConnection>();
    private final long serverStartTime;

    public WebSocketManager(Path dataDirectory, Logger logger, Plugin plugin, DataManager dataManager, int port, long serverStartTime) {
        this.dataDirectory = dataDirectory.resolve("web");
        this.logger = logger;
        this.plugin = plugin;
        this.dataManager = dataManager;
        this.port = port;
        this.serverStartTime = serverStartTime;
    }

    public void start() {
        try {
            this.httpServer = HttpServer.create(new InetSocketAddress(this.port), 0);
            this.httpServer.setExecutor(Executors.newCachedThreadPool());
            this.httpServer.createContext("/", new FileHandler(this.dataDirectory, "index.html", "text/html"));
            this.httpServer.createContext("/styles.css", new FileHandler(this.dataDirectory, "styles.css", "text/css"));
            this.httpServer.createContext("/script.js", new FileHandler(this.dataDirectory, "script.js", "text/javascript"));
            this.httpServer.createContext("/data.js", new DataJsHandler(this.dataManager, this.serverStartTime));
            this.httpServer.start();
            this.logger.info("WebSocket server started on port " + this.port);
            this.logger.info("Dashboard available at: http://localhost:" + this.port);
        }
        catch (IOException e) {
            this.logger.severe("Failed to start WebSocket server: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void stop() {
        if (this.httpServer != null) {
            this.httpServer.stop(0);
            this.logger.info("WebSocket server stopped");
        }
    }

    private static class FileHandler
    implements HttpHandler {
        private final Path dataDirectory;
        private final String fileName;
        private final String contentType;

        public FileHandler(Path dataDirectory, String fileName, String contentType) {
            this.dataDirectory = dataDirectory;
            this.fileName = fileName;
            this.contentType = contentType;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            Path filePath = this.dataDirectory.resolve(this.fileName);
            if (Files.exists(filePath, new LinkOption[0])) {
                exchange.getResponseHeaders().set("Content-Type", this.contentType);
                exchange.getResponseHeaders().set("Cache-Control", "no-cache");
                byte[] fileContent = Files.readAllBytes(filePath);
                exchange.sendResponseHeaders(200, fileContent.length);
                try (OutputStream os = exchange.getResponseBody();){
                    os.write(fileContent);
                }
            }
            String response = "File not found: " + this.fileName;
            exchange.sendResponseHeaders(404, response.length());
            try (OutputStream os = exchange.getResponseBody();){
                os.write(response.getBytes());
            }
        }
    }

    private static class DataJsHandler
    implements HttpHandler {
        private final DataManager dataManager;
        private final long serverStartTime;

        public DataJsHandler(DataManager dataManager, long serverStartTime) {
            this.dataManager = dataManager;
            this.serverStartTime = serverStartTime;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            exchange.getResponseHeaders().set("Content-Type", "text/javascript");
            exchange.getResponseHeaders().set("Cache-Control", "no-cache");
            String dataJs = this.generateDataJs();
            byte[] response = dataJs.getBytes(StandardCharsets.UTF_8);
            exchange.sendResponseHeaders(200, response.length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(response);
            }
        }

        private String generateDataJs() {
            StringBuilder playerCountDataSb = new StringBuilder("[\n");
            List<DataManager.PlayerCountEntry> entries = this.dataManager.getPlayerCountHistory();
            if (entries.isEmpty()) {
                playerCountDataSb.append("  { \"time\": \"").append(LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME)).append("\", \"count\": 0 }");
            } else {
                for (int i = 0; i < entries.size(); ++i) {
                    DataManager.PlayerCountEntry entry = entries.get(i);
                    LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(entry.timestamp), ZoneId.systemDefault());
                    playerCountDataSb.append("  { \"time\": \"").append(dateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME)).append("\", \"count\": ").append(entry.count).append(" }");
                    if (i < entries.size() - 1) {
                        playerCountDataSb.append(",\n");
                        continue;
                    }
                    playerCountDataSb.append("\n");
                }
            }
            playerCountDataSb.append("]");
            StringBuilder playtimeDataSb = new StringBuilder("[\n");
            Map<String, Long> topPlaytimes = this.dataManager.getTopPlaytimes(10);
            if (topPlaytimes.isEmpty()) {
                playtimeDataSb.append("  { \"player\": \"No player data\", \"time\": 0 }");
            } else {
                int i = 0;
                for (Map.Entry<String, Long> entry : topPlaytimes.entrySet()) {
                    String escapedName = entry.getKey().replace("\"", "\\\"");
                    playtimeDataSb.append("  { \"player\": \"").append(escapedName).append("\", \"time\": ").append(entry.getValue()).append(" }");
                    if (i < topPlaytimes.size() - 1) {
                        playtimeDataSb.append(",\n");
                    } else {
                        playtimeDataSb.append("\n");
                    }
                    ++i;
                }
            }
            playtimeDataSb.append("]");
            String peakDate = this.dataManager.getPeakPlayerDate();
            if (peakDate == null || peakDate.equals("N/A")) {
                peakDate = "No data";
            }
            return "// Auto-generated data file - Do not edit manually\nconst playerCountData = " + playerCountDataSb.toString() + ";\n\nconst playerPlaytimeData = " + playtimeDataSb.toString() + ";\n\nconst serverStats = {\n  currentPlayerCount: " + this.dataManager.getCurrentPlayerCount() + ",\n  totalPlaytime: " + this.dataManager.getTotalPlaytime() + ",\n  peakPlayerCount: " + this.dataManager.getPeakPlayerCount() + ",\n  peakPlayerDate: \"" + peakDate + "\",\n  lastRestartTime: " + this.serverStartTime + "\n};\n";
        }
    }

    private static class ClientConnection {
        private ClientConnection() {
        }
    }
}

