/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block;

import dev.aaronhowser.mods.irregular_implements.EnderAnchorCarrier;
import dev.aaronhowser.mods.irregular_implements.block.block_entity.EnderAnchorBlockEntity;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlocks;
import dev.aaronhowser.mods.irregular_implements.registry.ModSounds;
import dev.aaronhowser.mods.irregular_implements.util.ServerScheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\u000bH\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J8\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/EnderBridgeBlock;", "Lnet/minecraft/world/level/block/Block;", "distancePerTick", "", "<init>", "(I)V", "getDistancePerTick", "()I", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/state/BlockState;", "getStateForPlacement", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "neighborChanged", "state", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "block", "fromPos", "isMoving", "", "Companion", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nEnderBridgeBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnderBridgeBlock.kt\ndev/aaronhowser/mods/irregular_implements/block/EnderBridgeBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n774#2:177\n865#2,2:178\n*S KotlinDebug\n*F\n+ 1 EnderBridgeBlock.kt\ndev/aaronhowser/mods/irregular_implements/block/EnderBridgeBlock\n*L\n73#1:177\n73#1:178,2\n*E\n"})
public final class EnderBridgeBlock
extends Block {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int distancePerTick;
    @NotNull
    private static final BooleanProperty ENABLED;
    @NotNull
    private static final DirectionProperty FACING;

    public EnderBridgeBlock(int distancePerTick) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.OBSIDIAN)));
        this.distancePerTick = distancePerTick;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    public final int getDistancePerTick() {
        return this.distancePerTick;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{FACING, ENABLED};
        builder.add(propertyArray);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    protected void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        Iterator $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)fromPos, (String)"fromPos");
        if (!(level instanceof ServerLevel) || !(level instanceof EnderAnchorCarrier)) {
            return;
        }
        boolean isPowered = level.hasNeighborSignal(pos);
        Boolean wasPowered = (Boolean)state.getValue((Property)ENABLED);
        if (Intrinsics.areEqual((Object)isPowered, (Object)wasPowered)) {
            return;
        }
        BlockState newState = (BlockState)state.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(isPowered));
        level.setBlockAndUpdate(pos, newState);
        if (!isPowered) {
            return;
        }
        Direction direction = (Direction)state.getValue((Property)FACING);
        List<BlockPos> anchors = EnderAnchorBlockEntity.Companion.getEnderAnchorPositions((EnderAnchorCarrier)level);
        Iterable $this$filter$iv = anchors;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            BlockPos anchorPos = (BlockPos)element$iv$iv;
            boolean bl = false;
            Direction.Axis axis = direction.getAxis();
            if (!(switch (axis == null ? -1 : WhenMappings.$EnumSwitchMapping$0[axis.ordinal()]) {
                case 1 -> {
                    if (anchorPos.getZ() == pos.getZ() && anchorPos.getY() == pos.getY()) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (anchorPos.getX() == pos.getX() && anchorPos.getY() == pos.getY()) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (anchorPos.getX() == pos.getX() && anchorPos.getZ() == pos.getZ()) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new NoWhenBranchMatchedException();
            })) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List anchorsOnAxis = (List)destination$iv$iv;
        Ref.ObjectRef closestAnchor = new Ref.ObjectRef();
        int closestDistance = Integer.MAX_VALUE;
        for (BlockPos anchorPos : anchorsOnAxis) {
            int distance;
            Direction direction2 = direction;
            if ((distance = (switch (direction2 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[direction2.ordinal()]) {
                case 1 -> pos.getZ() - anchorPos.getZ();
                case 2 -> anchorPos.getZ() - pos.getZ();
                case 3 -> pos.getX() - anchorPos.getX();
                case 4 -> anchorPos.getX() - pos.getX();
                case 5 -> anchorPos.getY() - pos.getY();
                case 6 -> pos.getY() - anchorPos.getY();
                default -> throw new NoWhenBranchMatchedException();
            })) < 0 || distance >= closestDistance) continue;
            closestDistance = distance;
            closestAnchor.element = anchorPos;
        }
        int tickDuration = closestAnchor.element == null ? 100 : closestDistance / this.distancePerTick;
        ServerScheduler.INSTANCE.scheduleTaskInTicks(tickDuration, () -> EnderBridgeBlock.neighborChanged$lambda$1(level, pos, closestAnchor));
    }

    private static final void neighborChanged$lambda$1(Level $level, BlockPos $pos, Ref.ObjectRef $closestAnchor) {
        if (((Boolean)((ServerLevel)$level).getBlockState($pos).getValue((Property)ENABLED)).booleanValue()) {
            if ($closestAnchor.element != null && ((ServerLevel)$level).getBlockState((BlockPos)$closestAnchor.element).is((Holder)ModBlocks.INSTANCE.getENDER_ANCHOR())) {
                EnderBridgeBlock.Companion.foundAnchor($level, $pos, (BlockPos)$closestAnchor.element);
            } else {
                EnderBridgeBlock.Companion.turnOffBridge($level, $pos, true);
            }
        }
    }

    static {
        BooleanProperty booleanProperty = BlockStateProperties.ENABLED;
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"ENABLED");
        ENABLED = booleanProperty;
        DirectionProperty directionProperty = BlockStateProperties.FACING;
        Intrinsics.checkNotNullExpressionValue((Object)directionProperty, (String)"FACING");
        FACING = directionProperty;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J \u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/EnderBridgeBlock$Companion;", "", "<init>", "()V", "ENABLED", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getENABLED", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "FACING", "Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "getFACING", "()Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "getEntities", "", "Lnet/minecraft/world/entity/Entity;", "level", "Lnet/minecraft/world/level/Level;", "bridgePos", "Lnet/minecraft/core/BlockPos;", "foundAnchor", "", "anchorPos", "turnOffBridge", "bridgeFailed", "", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BooleanProperty getENABLED() {
            return ENABLED;
        }

        @NotNull
        public final DirectionProperty getFACING() {
            return FACING;
        }

        private final List<Entity> getEntities(Level level, BlockPos bridgePos) {
            List list = level.getEntities(null, AABB.ofSize((Vec3)bridgePos.getCenter(), (double)1.25, (double)2.5, (double)1.25));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
            return list;
        }

        private final void foundAnchor(Level level, BlockPos bridgePos, BlockPos anchorPos) {
            for (Entity entity : this.getEntities(level, bridgePos)) {
                entity.teleportTo((double)anchorPos.getX() + 0.5, (double)anchorPos.getY() + 1.0, (double)anchorPos.getZ() + 0.5);
            }
            level.playSound(null, anchorPos.above(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS);
            this.turnOffBridge(level, bridgePos, false);
        }

        private final void turnOffBridge(Level level, BlockPos bridgePos, boolean bridgeFailed) {
            BlockState state = level.getBlockState(bridgePos);
            if (!((Boolean)state.getValue((Property)this.getENABLED())).booleanValue()) {
                return;
            }
            BlockState newState = (BlockState)state.setValue((Property)this.getENABLED(), (Comparable)Boolean.valueOf(false));
            level.setBlockAndUpdate(bridgePos, newState);
            SoundEvent soundEvent = bridgeFailed ? (SoundEvent)ModSounds.INSTANCE.getFART().get() : SoundEvents.ENDERMAN_TELEPORT;
            level.playSound(null, bridgePos.above(), soundEvent, SoundSource.BLOCKS);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Direction.Axis.values().length];
            try {
                nArray[Direction.Axis.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Axis.Z.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Axis.Y.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

