/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block;

import dev.aaronhowser.mods.irregular_implements.block.block_entity.SpecialChestBlockEntity;
import dev.aaronhowser.mods.irregular_implements.datagen.loot.ModChestLootSubprovider;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntityTypes;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlocks;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentPieces;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J8\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/SpecialChestBlock;", "Lnet/minecraft/world/level/block/ChestBlock;", "chestType", "Ldev/aaronhowser/mods/irregular_implements/block/SpecialChestBlock$Type;", "<init>", "(Ldev/aaronhowser/mods/irregular_implements/block/SpecialChestBlock$Type;)V", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "getStateForPlacement", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "updateShape", "facing", "Lnet/minecraft/core/Direction;", "facingState", "level", "Lnet/minecraft/world/level/LevelAccessor;", "currentPos", "facingPos", "Type", "Companion", "irregular-implements-1.21.1"})
public final class SpecialChestBlock
extends ChestBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Type chestType;

    private SpecialChestBlock(Type chestType) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.CHEST)), chestType.getBlockEntityType());
        this.chestType = chestType;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return switch (WhenMappings.$EnumSwitchMapping$0[this.chestType.ordinal()]) {
            case 1 -> (BlockEntity)new SpecialChestBlockEntity.NatureChestBlockEntity(pos, state);
            case 2 -> (BlockEntity)new SpecialChestBlockEntity.WaterChestBlockEntity(pos, state);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BlockState blockState = super.getStateForPlacement(context);
        return blockState != null ? (BlockState)blockState.setValue((Property)ChestBlock.TYPE, (Comparable)ChestType.SINGLE) : null;
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        Intrinsics.checkNotNullParameter((Object)facingState, (String)"facingState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)currentPos, (String)"currentPos");
        Intrinsics.checkNotNullParameter((Object)facingPos, (String)"facingPos");
        if (((Boolean)state.getValue((Property)ChestBlock.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return state;
    }

    @JvmStatic
    public static final void addToOceanMonument(@NotNull WorldGenLevel level, @NotNull RandomSource random, @NotNull BoundingBox boundingBox, @NotNull OceanMonumentPieces.OceanMonumentCoreRoom coreRoom) {
        Companion.addToOceanMonument(level, random, boundingBox, coreRoom);
    }

    public /* synthetic */ SpecialChestBlock(Type chestType, DefaultConstructorMarker $constructor_marker) {
        this(chestType);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/SpecialChestBlock$Companion;", "", "<init>", "()V", "addToOceanMonument", "", "level", "Lnet/minecraft/world/level/WorldGenLevel;", "random", "Lnet/minecraft/util/RandomSource;", "boundingBox", "Lnet/minecraft/world/level/levelgen/structure/BoundingBox;", "coreRoom", "Lnet/minecraft/world/level/levelgen/structure/structures/OceanMonumentPieces$OceanMonumentCoreRoom;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void addToOceanMonument(@NotNull WorldGenLevel level, @NotNull RandomSource random, @NotNull BoundingBox boundingBox, @NotNull OceanMonumentPieces.OceanMonumentCoreRoom coreRoom) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            Intrinsics.checkNotNullParameter((Object)boundingBox, (String)"boundingBox");
            Intrinsics.checkNotNullParameter((Object)coreRoom, (String)"coreRoom");
            int x = 6;
            int y = 1;
            int z = 6;
            coreRoom.placeBlock(level, ((SpecialChestBlock)((Object)ModBlocks.INSTANCE.getWATER_CHEST().get())).defaultBlockState(), x, y, z, boundingBox);
            BlockPos.MutableBlockPos chestPosition = coreRoom.getWorldPos(x, y, z);
            RandomizableContainer.setBlockEntityLootTable((BlockGetter)((BlockGetter)level), (RandomSource)random, (BlockPos)((BlockPos)chestPosition), ModChestLootSubprovider.Companion.getOCEAN_MONUMENT_CHEST());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\b\u0002\u0012\u0014\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001f\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\u0010"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/SpecialChestBlock$Type;", "", "blockEntityType", "Ljava/util/function/Supplier;", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "Lnet/minecraft/world/level/block/entity/ChestBlockEntity;", "<init>", "(Ljava/lang/String;ILjava/util/function/Supplier;)V", "getBlockEntityType", "()Ljava/util/function/Supplier;", "NATURE", "WATER", "block", "Ldev/aaronhowser/mods/irregular_implements/block/SpecialChestBlock;", "getBlock", "()Ldev/aaronhowser/mods/irregular_implements/block/SpecialChestBlock;", "irregular-implements-1.21.1"})
    public static final class Type
    extends Enum<Type> {
        @NotNull
        private final Supplier<BlockEntityType<? extends ChestBlockEntity>> blockEntityType;
        @NotNull
        private final SpecialChestBlock block;
        public static final /* enum */ Type NATURE = new Type(Type::_init_$lambda$0);
        public static final /* enum */ Type WATER = new Type(Type::_init_$lambda$1);
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Type(Supplier<BlockEntityType<? extends ChestBlockEntity>> blockEntityType) {
            this.blockEntityType = blockEntityType;
            this.block = new SpecialChestBlock(this, null);
        }

        @NotNull
        public final Supplier<BlockEntityType<? extends ChestBlockEntity>> getBlockEntityType() {
            return this.blockEntityType;
        }

        @NotNull
        public final SpecialChestBlock getBlock() {
            return this.block;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        private static final BlockEntityType _init_$lambda$0() {
            return (BlockEntityType)ModBlockEntityTypes.NATURE_CHEST.get();
        }

        private static final BlockEntityType _init_$lambda$1() {
            return (BlockEntityType)ModBlockEntityTypes.WATER_CHEST.get();
        }

        static {
            $VALUES = typeArray = new Type[]{Type.NATURE, Type.WATER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.NATURE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.WATER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

