/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block.block_entity;

import dev.aaronhowser.mods.irregular_implements.config.ServerConfig;
import dev.aaronhowser.mods.irregular_implements.datagen.tag.ModBlockTagsProvider;
import dev.aaronhowser.mods.irregular_implements.datagen.tag.ModEntityTypeTagsProvider;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntityTypes;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import dev.aaronhowser.mods.irregular_implements.util.StructureSchematics;
import dev.aaronhowser.mods.irregular_implements.world.feature.NatureCoreFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\tH\u0002J\b\u0010\u000b\u001a\u00020\tH\u0002J\b\u0010\f\u001a\u00020\tH\u0002J\b\u0010\r\u001a\u00020\tH\u0002J\b\u0010\u000e\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/NatureCoreBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "tick", "", "replaceSand", "spawnAnimals", "boneMealCrops", "plantSaplings", "rebuild", "Companion", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nNatureCoreBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NatureCoreBlockEntity.kt\ndev/aaronhowser/mods/irregular_implements/block/block_entity/NatureCoreBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,256:1\n774#2:257\n865#2,2:258\n827#2:260\n855#2,2:261\n774#2:263\n865#2,2:264\n*S KotlinDebug\n*F\n+ 1 NatureCoreBlockEntity.kt\ndev/aaronhowser/mods/irregular_implements/block/block_entity/NatureCoreBlockEntity\n*L\n90#1:257\n90#1:258,2\n133#1:260\n133#1:261,2\n201#1:263\n201#1:264,2\n*E\n"})
public final class NatureCoreBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public NatureCoreBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super((BlockEntityType)ModBlockEntityTypes.INSTANCE.getNATURE_CORE().get(), pos, blockState);
    }

    private final void tick() {
        Level level = this.level;
        if (level == null || (level = level.random) == null) {
            return;
        }
        Level random = level;
        if (random.nextInt(40) == 0) {
            this.replaceSand();
        }
        if (random.nextInt(400) == 0) {
            this.spawnAnimals();
        }
        if (random.nextInt(100) == 0) {
            this.boneMealCrops();
        }
        if (random.nextInt(600) == 0) {
            this.plantSaplings();
        }
        if (random.nextInt(600) == 0) {
            this.rebuild();
        }
    }

    private final void replaceSand() {
        boolean foundSand;
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        Integer radius = (Integer)ServerConfig.Companion.getCONFIG().getNatureCoreReplaceSandRadius().get();
        int attempts = 0;
        BlockPos.MutableBlockPos pos = this.getBlockPos().mutable();
        do {
            BlockPos blockPos = this.getBlockPos();
            RandomSource randomSource = level2.random;
            Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"random");
            int n = OtherUtil.INSTANCE.nextRange(randomSource, -radius.intValue(), radius + 1);
            RandomSource randomSource2 = level2.random;
            Intrinsics.checkNotNullExpressionValue((Object)randomSource2, (String)"random");
            int n2 = OtherUtil.INSTANCE.nextRange(randomSource2, -radius.intValue(), radius + 1);
            RandomSource randomSource3 = level2.random;
            Intrinsics.checkNotNullExpressionValue((Object)randomSource3, (String)"random");
            pos.set((Vec3i)blockPos.offset(n, n2, OtherUtil.INSTANCE.nextRange(randomSource3, -radius.intValue(), radius + 1)));
            BlockState blockStateThere = level2.getBlockState((BlockPos)pos);
            boolean bl = foundSand = blockStateThere.is(BlockTags.SAND) && !blockStateThere.is(ModBlockTagsProvider.Companion.getNATURE_CORE_IMMUNE());
        } while (foundSand && ++attempts < 50);
        BlockState stateThere = level2.getBlockState((BlockPos)pos);
        if (stateThere.is(BlockTags.SAND) && !stateThere.is(ModBlockTagsProvider.Companion.getNATURE_CORE_IMMUNE())) {
            boolean belowAir = level2.isEmptyBlock(pos.above());
            Block place = belowAir ? Blocks.GRASS_BLOCK : Blocks.DIRT;
            level2.setBlockAndUpdate((BlockPos)pos, place.defaultBlockState());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void spawnAnimals() {
        EntityType entityType;
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        boolean foundValidSpot;
        Object it;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level2 = serverLevel;
        Double radius = (Double)ServerConfig.Companion.getCONFIG().getNatureCoreSpawnAnimalRadius().get();
        List list = level2.getEntitiesOfClass(Mob.class, new AABB(this.getBlockPos()).inflate(radius * (double)3));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Mob)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof Animal || it instanceof WaterAnimal)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List animalsNearby = (List)destination$iv$iv;
        if (animalsNearby.size() > 2) {
            return;
        }
        Intrinsics.checkNotNull((Object)radius);
        int radCeil = Mth.ceil((double)radius);
        int attempts = 0;
        BlockPos.MutableBlockPos pos = this.getBlockPos().mutable();
        do {
            BlockPos blockPos = this.getBlockPos();
            RandomSource randomSource = level2.random;
            Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"random");
            int n = OtherUtil.INSTANCE.nextRange(randomSource, -radCeil, radCeil + 1);
            RandomSource randomSource2 = level2.random;
            Intrinsics.checkNotNullExpressionValue((Object)randomSource2, (String)"random");
            int n2 = OtherUtil.INSTANCE.nextRange(randomSource2, -radCeil, radCeil + 1);
            RandomSource randomSource3 = level2.random;
            Intrinsics.checkNotNullExpressionValue((Object)randomSource3, (String)"random");
            pos.set((Vec3i)blockPos.offset(n, n2, OtherUtil.INSTANCE.nextRange(randomSource3, -radCeil, radCeil + 1)));
            FluidState fluidStateThere = level2.getFluidState((BlockPos)pos);
            BlockState blockStateThere = level2.getBlockState((BlockPos)pos);
            boolean bl = foundValidSpot = !blockStateThere.getCollisionShape((BlockGetter)level2, (BlockPos)pos).isEmpty() || !fluidStateThere.isEmpty() && !fluidStateThere.is((Fluid)Fluids.WATER);
        } while (foundValidSpot && ++attempts < 50);
        while (level2.isEmptyBlock((BlockPos)pos) && level2.isEmptyBlock(pos.below())) {
            pos.move(Direction.DOWN);
        }
        boolean isUnderWater = level2.getFluidState((BlockPos)pos).is((Fluid)Fluids.WATER);
        MobCategory mobCategory = isUnderWater ? (level2.random.nextBoolean() ? MobCategory.WATER_AMBIENT : MobCategory.WATER_CREATURE) : MobCategory.CREATURE;
        WeightedRandomList entitiesThatCanSpawnHere = ((Biome)level2.getBiome((BlockPos)pos).value()).getMobSettings().getMobs(mobCategory);
        List list2 = entitiesThatCanSpawnHere.unwrap();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"unwrap(...)");
        it = list2;
        boolean $i$f$filterNot = false;
        MobSpawnSettings.SpawnerData spawnerData = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            MobSpawnSettings.SpawnerData it2 = (MobSpawnSettings.SpawnerData)element$iv$iv;
            boolean bl = false;
            if (it2.type.is(ModEntityTypeTagsProvider.Companion.getNATURE_CORE_IMMUNE())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List filtered = (List)destination$iv$iv2;
        if (filtered.isEmpty()) {
            return;
        }
        WeightedRandomList newWeightedList = WeightedRandomList.create((List)filtered);
        Optional optional = newWeightedList.getRandom(level2.random);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getRandom(...)");
        spawnerData = (MobSpawnSettings.SpawnerData)OptionalsKt.getOrNull((Optional)optional);
        if (spawnerData == null || (entityType = spawnerData.type) == null) {
            return;
        }
        EntityType randomEntityType = entityType;
        randomEntityType.spawn(level2, (BlockPos)pos, MobSpawnType.SPAWNER);
    }

    private final void boneMealCrops() {
        boolean success;
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level2 = serverLevel;
        Integer radius = (Integer)ServerConfig.Companion.getCONFIG().getNatureCoreBoneMealCropRadius().get();
        int attempts = 0;
        BlockPos pos = null;
        do {
            BlockPos blockPos = this.getBlockPos();
            RandomSource randomSource = level2.random;
            Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"random");
            int n = OtherUtil.INSTANCE.nextRange(randomSource, -radius.intValue(), radius + 1);
            RandomSource randomSource2 = level2.random;
            Intrinsics.checkNotNullExpressionValue((Object)randomSource2, (String)"random");
            int n2 = OtherUtil.INSTANCE.nextRange(randomSource2, -radius.intValue(), radius + 1);
            RandomSource randomSource3 = level2.random;
            Intrinsics.checkNotNullExpressionValue((Object)randomSource3, (String)"random");
            BlockPos blockPos2 = blockPos.offset(n, n2, OtherUtil.INSTANCE.nextRange(randomSource3, -radius.intValue(), radius + 1));
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"offset(...)");
            pos = blockPos2;
            BlockState blockStateThere = level2.getBlockState(pos);
            Block blockThere = blockStateThere.getBlock();
            boolean bl = success = !blockStateThere.is(ModBlockTagsProvider.Companion.getNATURE_CORE_IMMUNE()) && blockThere instanceof BonemealableBlock && ((BonemealableBlock)blockThere).isValidBonemealTarget((LevelReader)level2, pos, blockStateThere) && ((BonemealableBlock)blockThere).isBonemealSuccess((Level)level2, level2.random, pos, blockStateThere);
        } while (success && ++attempts < 50);
        BlockState state = level2.getBlockState(pos);
        Block block = state.getBlock();
        BonemealableBlock bonemealableBlock = block instanceof BonemealableBlock ? (BonemealableBlock)block : null;
        if (bonemealableBlock == null) {
            return;
        }
        BonemealableBlock block2 = bonemealableBlock;
        block2.performBonemeal(level2, level2.random, pos, state);
    }

    /*
     * WARNING - void declaration
     */
    private final void plantSaplings() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level2 = serverLevel;
        Integer maxRadius = (Integer)ServerConfig.Companion.getCONFIG().getNatureCorePlantSaplingRadius().get();
        int radius = (int)Mth.lerp((double)level2.random.nextDouble(), (double)10.0, (double)maxRadius.intValue());
        double rads = level2.random.nextDouble() * (double)((float)Math.PI * 2);
        int x = Mth.floor((double)((double)this.getBlockPos().getX() + (double)radius * Math.cos(rads)));
        int z = Mth.floor((double)((double)this.getBlockPos().getZ() + (double)radius * Math.sin(rads)));
        int y = this.getBlockPos().getY() + 10;
        BlockPos.MutableBlockPos pos = new BlockPos(x, y, z).mutable();
        do {
            pos.move(Direction.DOWN);
        } while (level2.isInWorldBounds((BlockPos)pos) && level2.isEmptyBlock((BlockPos)pos));
        pos.move(Direction.UP);
        DefaultedRegistry defaultedRegistry = BuiltInRegistries.BLOCK;
        Intrinsics.checkNotNullExpressionValue((Object)defaultedRegistry, (String)"BLOCK");
        Iterable iterable = (Iterable)defaultedRegistry;
        boolean $i$f$filter = false;
        void var13_14 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Block it = (Block)element$iv$iv;
            boolean bl = false;
            BlockState state = it.defaultBlockState();
            if (!(state.is(ModBlockTagsProvider.Companion.getNATURE_CORE_POSSIBLE_SAPLINGS()) && state.canSurvive((LevelReader)level2, (BlockPos)pos))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List saplings = (List)destination$iv$iv;
        if (saplings.isEmpty()) {
            return;
        }
        int index = level2.random.nextInt(saplings.size());
        Block block = (Block)CollectionsKt.getOrNull((List)saplings, (int)index);
        if (block == null || (block = block.defaultBlockState()) == null) {
            return;
        }
        Block randomSapling = block;
        level2.levelEvent(null, 1505, (BlockPos)pos, Block.getId((BlockState)randomSapling));
        level2.setBlockAndUpdate((BlockPos)pos, (BlockState)randomSapling);
    }

    private final void rebuild() {
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level2 = serverLevel;
        Holder biome = level2.getBiome(this.getBlockPos());
        Intrinsics.checkNotNull((Object)biome);
        BlockState log = NatureCoreFeature.Companion.getLogFromBiome((Holder<Biome>)biome);
        BlockState leaves = NatureCoreFeature.Companion.getLeavesFromBiome((Holder<Biome>)biome);
        Map<BlockPos, BlockState> schematic = StructureSchematics.INSTANCE.getNatureCore(log, leaves);
        if (schematic.entrySet().isEmpty()) {
            return;
        }
        int index = level2.random.nextInt(schematic.entrySet().size());
        Map.Entry entry2 = (Map.Entry)CollectionsKt.elementAtOrNull((Iterable)schematic.entrySet(), (int)index);
        if (entry2 == null) {
            return;
        }
        Map.Entry entry3 = entry2;
        BlockPos offset = (BlockPos)entry3.getKey();
        BlockState state = (BlockState)entry3.getValue();
        if (Intrinsics.areEqual((Object)offset, (Object)BlockPos.ZERO)) {
            return;
        }
        BlockPos pos = this.getBlockPos().offset((Vec3i)offset);
        if (level2.isOutsideBuildHeight(pos) || !level2.isEmptyBlock(pos)) {
            return;
        }
        level2.setBlockAndUpdate(pos, state);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/NatureCoreBlockEntity$Companion;", "", "<init>", "()V", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/NatureCoreBlockEntity;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull NatureCoreBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            if (level.isClientSide) {
                return;
            }
            blockEntity.tick();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

