/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block.block_entity;

import dev.aaronhowser.mods.irregular_implements.SlimeCubeCarrier;
import dev.aaronhowser.mods.irregular_implements.block.RainShieldBlock;
import dev.aaronhowser.mods.irregular_implements.config.ServerConfig;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntityTypes;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/SlimeCubeBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "onLoad", "", "setRemoved", "clearRemoved", "Companion", "irregular-implements-1.21.1"})
public final class SlimeCubeBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public SlimeCubeBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super((BlockEntityType)ModBlockEntityTypes.INSTANCE.getSLIME_CUBE().get(), pos, blockState);
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.level;
        if (level instanceof SlimeCubeCarrier) {
            Companion.getSlimeCubePositions((SlimeCubeCarrier)level).add(this.worldPosition.asLong());
        }
    }

    public void setRemoved() {
        super.setRemoved();
        Level level = this.level;
        if (level instanceof SlimeCubeCarrier) {
            Companion.getSlimeCubePositions((SlimeCubeCarrier)level).remove(this.worldPosition.asLong());
        }
    }

    public void clearRemoved() {
        super.clearRemoved();
        Level level = this.level;
        if (level instanceof SlimeCubeCarrier) {
            Companion.getSlimeCubePositions((SlimeCubeCarrier)level).add(this.worldPosition.asLong());
        }
    }

    @JvmStatic
    @NotNull
    public static final Optional<Boolean> slimeCubeResult(@NotNull LevelAccessor level, @NotNull BlockPos pos) {
        return Companion.slimeCubeResult(level, pos);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bJ\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0007J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u00a8\u0006\u0018"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/SlimeCubeBlockEntity$Companion;", "", "<init>", "()V", "getSlimeCubePositions", "Lit/unimi/dsi/fastutil/longs/LongOpenHashSet;", "Ldev/aaronhowser/mods/irregular_implements/SlimeCubeCarrier;", "chunkHasCube", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "powered", "slimeCubeResult", "Ljava/util/Optional;", "Lnet/minecraft/world/level/LevelAccessor;", "tick", "", "blockPos", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/SlimeCubeBlockEntity;", "irregular-implements-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nSlimeCubeBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlimeCubeBlockEntity.kt\ndev/aaronhowser/mods/irregular_implements/block/block_entity/SlimeCubeBlockEntity$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1563#2:97\n1634#2,3:98\n774#2:101\n865#2,2:102\n1761#2,3:104\n*S KotlinDebug\n*F\n+ 1 SlimeCubeBlockEntity.kt\ndev/aaronhowser/mods/irregular_implements/block/block_entity/SlimeCubeBlockEntity$Companion\n*L\n55#1:97\n55#1:98,3\n56#1:101\n56#1:102,2\n60#1:104,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LongOpenHashSet getSlimeCubePositions(@NotNull SlimeCubeCarrier $this$getSlimeCubePositions) {
            Intrinsics.checkNotNullParameter((Object)$this$getSlimeCubePositions, (String)"<this>");
            LongOpenHashSet longOpenHashSet = $this$getSlimeCubePositions.irregular_implements$getSlimeCubePositions();
            Intrinsics.checkNotNullExpressionValue((Object)longOpenHashSet, (String)"irregular_implements$getSlimeCubePositions(...)");
            return longOpenHashSet;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean chunkHasCube(@NotNull Level level, @NotNull BlockPos pos, boolean powered) {
            boolean bl;
            block7: {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                if (!(level instanceof SlimeCubeCarrier)) {
                    return false;
                }
                long chunkPosLong = ChunkPos.asLong((BlockPos)pos);
                Iterable iterable = (Iterable)this.getSlimeCubePositions((SlimeCubeCarrier)level);
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    long l = ((Number)item$iv$iv).longValue();
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(BlockPos.of((long)p0));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    BlockPos it = (BlockPos)element$iv$iv;
                    boolean bl3 = false;
                    if (!(ChunkPos.asLong((BlockPos)it) == chunkPosLong)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List cubesInThatChunk = (List)destination$iv$iv;
                if (cubesInThatChunk.isEmpty()) {
                    return false;
                }
                Iterable $this$any$iv = cubesInThatChunk;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BlockPos it = (BlockPos)element$iv;
                        boolean bl4 = false;
                        if (!(level.hasNeighborSignal(it) == powered)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @JvmStatic
        @NotNull
        public final Optional<Boolean> slimeCubeResult(@NotNull LevelAccessor level, @NotNull BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            if (level instanceof Level && ((Level)level).getDifficulty() != Difficulty.PEACEFUL) {
                if (this.chunkHasCube((Level)level, pos, true)) {
                    Optional<Boolean> optional = Optional.of(false);
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                    return optional;
                }
                if (this.chunkHasCube((Level)level, pos, false)) {
                    Optional<Boolean> optional = Optional.of(true);
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                    return optional;
                }
            }
            Optional<Boolean> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull SlimeCubeBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            if (!(level instanceof SlimeCubeCarrier)) {
                return;
            }
            if (((Boolean)blockState.getValue((Property)RainShieldBlock.Companion.getENABLED())).booleanValue()) {
                ChunkPos chunkPos = new ChunkPos(blockPos.getX() >> 4, blockPos.getZ() >> 4);
                Integer checkRadius = (Integer)ServerConfig.Companion.getCONFIG().getSlimeCubeChunkRadius().get();
                int chunkX = chunkPos.x;
                int chunkZ = chunkPos.z;
                Intrinsics.checkNotNull((Object)checkRadius);
                int x = chunkX - checkRadius;
                int n = chunkX + checkRadius;
                if (x <= n) {
                    while (true) {
                        int n2;
                        int z;
                        if ((z = chunkZ - checkRadius) <= (n2 = chunkZ + checkRadius)) {
                            while (true) {
                                this.getSlimeCubePositions((SlimeCubeCarrier)level).add(ChunkPos.asLong((int)x, (int)z));
                                if (z == n2) break;
                                ++z;
                            }
                        }
                        if (x == n) break;
                        ++x;
                    }
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

