/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.aaronhowser.mods.irregular_implements.util.RenderUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0014\u001a\u00020\bH\u0002J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/aaronhowser/mods/irregular_implements/client/render/LineIndicatorRenderer;", "", "<init>", "()V", "lineIndicators", "", "Ldev/aaronhowser/mods/irregular_implements/client/render/LineIndicatorRenderer$LineIndicator;", "addIndicator", "", "start", "Lnet/minecraft/world/phys/Vec3;", "end", "duration", "", "color", "removeIndicators", "afterClientTick", "event", "Lnet/neoforged/neoforge/client/event/ClientTickEvent$Post;", "collectIndicators", "tickIndicators", "onRenderLevel", "Lnet/neoforged/neoforge/client/event/RenderLevelStageEvent;", "LineIndicator", "irregular-implements-1.21.1"})
public final class LineIndicatorRenderer {
    @NotNull
    public static final LineIndicatorRenderer INSTANCE = new LineIndicatorRenderer();
    @NotNull
    private static final List<LineIndicator> lineIndicators = new ArrayList();

    private LineIndicatorRenderer() {
    }

    public final void addIndicator(@NotNull Vec3 start, @NotNull Vec3 end, int duration, int color) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        lineIndicators.add(new LineIndicator(start, end, duration, color));
    }

    public final void removeIndicators(@NotNull Vec3 start, @NotNull Vec3 end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        lineIndicators.removeIf(arg_0 -> LineIndicatorRenderer.removeIndicators$lambda$1(arg_0 -> LineIndicatorRenderer.removeIndicators$lambda$0(start, end, arg_0), arg_0));
    }

    public final void afterClientTick(@NotNull ClientTickEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        this.tickIndicators();
        this.collectIndicators(event);
    }

    public final void collectIndicators(@NotNull ClientTickEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    private final void tickIndicators() {
        Iterator<LineIndicator> iterator = lineIndicators.iterator();
        while (iterator.hasNext()) {
            LineIndicator indicator = iterator.next();
            int n = indicator.getTicksLeft();
            indicator.setTicksLeft(n + -1);
            if (indicator.getTicksLeft() > 0) continue;
            iterator.remove();
        }
    }

    public final void onRenderLevel(@NotNull RenderLevelStageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event.getStage(), (Object)RenderLevelStageEvent.Stage.AFTER_WEATHER)) {
            return;
        }
        if (lineIndicators.isEmpty()) {
            return;
        }
        Vec3 cameraPos = event.getCamera().getPosition();
        PoseStack poseStack = event.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        for (LineIndicator indicator : lineIndicators) {
            Intrinsics.checkNotNull((Object)poseStack);
            RenderUtil.INSTANCE.renderLineThroughWalls(poseStack, indicator.getStart(), indicator.getEnd(), indicator.getColor());
        }
        poseStack.popPose();
    }

    private static final boolean removeIndicators$lambda$0(Vec3 $start, Vec3 $end, LineIndicator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getStart(), (Object)$start) && Intrinsics.areEqual((Object)it.getEnd(), (Object)$end);
    }

    private static final boolean removeIndicators$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0012"}, d2={"Ldev/aaronhowser/mods/irregular_implements/client/render/LineIndicatorRenderer$LineIndicator;", "", "start", "Lnet/minecraft/world/phys/Vec3;", "end", "ticksLeft", "", "color", "<init>", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;II)V", "getStart", "()Lnet/minecraft/world/phys/Vec3;", "getEnd", "getTicksLeft", "()I", "setTicksLeft", "(I)V", "getColor", "irregular-implements-1.21.1"})
    private static final class LineIndicator {
        @NotNull
        private final Vec3 start;
        @NotNull
        private final Vec3 end;
        private int ticksLeft;
        private final int color;

        public LineIndicator(@NotNull Vec3 start, @NotNull Vec3 end, int ticksLeft, int color) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            this.start = start;
            this.end = end;
            this.ticksLeft = ticksLeft;
            this.color = color;
        }

        @NotNull
        public final Vec3 getStart() {
            return this.start;
        }

        @NotNull
        public final Vec3 getEnd() {
            return this.end;
        }

        public final int getTicksLeft() {
            return this.ticksLeft;
        }

        public final void setTicksLeft(int n) {
            this.ticksLeft = n;
        }

        public final int getColor() {
            return this.color;
        }
    }
}

