/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.entity;

import dev.aaronhowser.mods.irregular_implements.registry.ModEntityTypes;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalBlock;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0014R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Ldev/aaronhowser/mods/irregular_implements/entity/ArtificialEndPortalEntity;", "Lnet/minecraft/world/entity/Entity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "blockPos", "Lnet/minecraft/core/BlockPos;", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V", "value", "", "actionTimer", "getActionTimer", "()I", "setActionTimer", "(I)V", "tick", "", "teleportEntitiesToEnd", "playerTouch", "player", "Lnet/minecraft/world/entity/player/Player;", "spawnParticles", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "readAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "addAdditionalSaveData", "Companion", "irregular-implements-1.21.1"})
public final class ArtificialEndPortalEntity
extends Entity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int MAX_ACTION_TIMER = 200;
    @NotNull
    private static final EntityDataAccessor<Integer> ACTION_TIMER;
    @NotNull
    public static final String ACTION_TIMER_NBT = "ActionTimer";

    public ArtificialEndPortalEntity(@NotNull EntityType<?> entityType, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(entityType, level);
    }

    public ArtificialEndPortalEntity(@NotNull Level level, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Object object = ModEntityTypes.INSTANCE.getARTIFICIAL_END_PORTAL().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this((EntityType)object, level);
        this.setPos((double)blockPos.getX() + 0.5, blockPos.getY(), (double)blockPos.getZ() + 0.5);
    }

    public final int getActionTimer() {
        Object object = this.entityData.get(ACTION_TIMER);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    private final void setActionTimer(int value) {
        this.entityData.set(ACTION_TIMER, (Object)value);
    }

    public void tick() {
        super.tick();
        if (this.getActionTimer() < 200) {
            int n = this.getActionTimer();
            this.setActionTimer(n + 1);
            if (this.level().isClientSide && this.getActionTimer() > 40) {
                this.spawnParticles();
            }
        }
        if (this.level().isClientSide) {
            if (this.getActionTimer() == 85) {
                this.level().playSound(null, this.blockPosition(), SoundEvents.PORTAL_TRAVEL, SoundSource.BLOCKS);
            }
        } else if (this.tickCount % 40 == 0) {
            Level level = this.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            BlockPos blockPos = this.blockPosition();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
            if (!Companion.isValidPosition(level, blockPos, false)) {
                this.kill();
            }
        }
        if (this.getActionTimer() >= 200 && this.tickCount % 20 == 0) {
            this.teleportEntitiesToEnd();
        }
    }

    private final void teleportEntitiesToEnd() {
        List entities = this.level().getEntitiesOfClass(Entity.class, this.getBoundingBox());
        for (Entity entity : entities) {
            if (entity instanceof ArtificialEndPortalEntity) continue;
            Block block = Blocks.END_PORTAL;
            Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.EndPortalBlock");
            entity.setAsInsidePortal((Portal)((EndPortalBlock)block), this.blockPosition());
        }
    }

    public void playerTouch(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.getActionTimer() >= 200) {
            Block block = Blocks.END_PORTAL;
            Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.EndPortalBlock");
            player.setAsInsidePortal((Portal)((EndPortalBlock)block), this.blockPosition());
        }
    }

    private final void spawnParticles() {
        for (int i = 0; i < 6; ++i) {
            float modX = this.random.nextFloat() * 0.05f - 0.025f;
            float modZ = this.random.nextFloat() * 0.05f - 0.025f;
            this.level().addParticle((ParticleOptions)ParticleTypes.ENCHANT, this.getX() + (double)modX, this.getY() + (double)2, this.getZ() + (double)modZ, (double)modX * (double)2, 1.0, (double)modZ * (double)2);
        }
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.define(ACTION_TIMER, (Object)0);
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.setActionTimer(compound.getInt(ACTION_TIMER_NBT));
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        compound.putInt(ACTION_TIMER_NBT, this.getActionTimer());
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(ArtificialEndPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        ACTION_TIMER = entityDataAccessor;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/aaronhowser/mods/irregular_implements/entity/ArtificialEndPortalEntity$Companion;", "", "<init>", "()V", "isValidPosition", "", "level", "Lnet/minecraft/world/level/Level;", "entityCenterPos", "Lnet/minecraft/core/BlockPos;", "checkForOtherPortals", "MAX_ACTION_TIMER", "", "ACTION_TIMER", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "getACTION_TIMER", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "ACTION_TIMER_NBT", "", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isValidPosition(@NotNull Level level, @NotNull BlockPos entityCenterPos, boolean checkForOtherPortals) {
            BlockPos endRodPos;
            BlockState endRodState;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)entityCenterPos, (String)"entityCenterPos");
            if (checkForOtherPortals) {
                List entities = level.getEntitiesOfClass(ArtificialEndPortalEntity.class, AABB.ofSize((Vec3)entityCenterPos.getBottomCenter(), (double)3.0, (double)1.0, (double)3.0));
                Intrinsics.checkNotNull((Object)entities);
                if (!((Collection)entities).isEmpty()) {
                    return false;
                }
            }
            if (!(endRodState = level.getBlockState(endRodPos = entityCenterPos.above(3))).is(Blocks.END_ROD) || endRodState.getValue((Property)EndRodBlock.FACING) != Direction.DOWN) {
                return false;
            }
            if (!level.getBlockState(endRodPos.above()).is(Tags.Blocks.END_STONES)) {
                return false;
            }
            for (int dX = -1; dX < 2; ++dX) {
                for (int dZ = -1; dZ < 2; ++dZ) {
                    BlockPos posDz;
                    BlockState stateDz;
                    BlockPos posDx;
                    BlockState stateDx;
                    BlockPos posThere = entityCenterPos.offset(dX, 0, dZ);
                    boolean isAir = level.getBlockState(posThere).isAir();
                    boolean isAboveEndStone = level.getBlockState(posThere.below()).is(Tags.Blocks.END_STONES);
                    if (!isAir || !isAboveEndStone) {
                        return false;
                    }
                    if (dX != 0 && !(stateDx = level.getBlockState(posDx = posThere.offset(dX, 0, 0))).is(Tags.Blocks.OBSIDIANS)) {
                        return false;
                    }
                    if (dZ == 0 || (stateDz = level.getBlockState(posDz = posThere.offset(0, 0, dZ))).is(Tags.Blocks.OBSIDIANS)) continue;
                    return false;
                }
            }
            return true;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getACTION_TIMER() {
            return ACTION_TIMER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

