/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.handler;

import dev.aaronhowser.mods.irregular_implements.config.ServerConfig;
import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.packet.server_to_client.AddIndicatorsPacket;
import dev.aaronhowser.mods.irregular_implements.registry.ModItems;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\tR\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/EscapeRopeHandler;", "", "<init>", "()V", "runningTasks", "Ljava/util/ArrayList;", "Ldev/aaronhowser/mods/irregular_implements/handler/EscapeRopeHandler$Task;", "Lkotlin/collections/ArrayList;", "addTask", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "tick", "directionPriority", "", "Lnet/minecraft/core/Direction;", "Task", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nEscapeRopeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EscapeRopeHandler.kt\ndev/aaronhowser/mods/irregular_implements/handler/EscapeRopeHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n1761#2,3:193\n*S KotlinDebug\n*F\n+ 1 EscapeRopeHandler.kt\ndev/aaronhowser/mods/irregular_implements/handler/EscapeRopeHandler\n*L\n27#1:193,3\n*E\n"})
public final class EscapeRopeHandler {
    @NotNull
    public static final EscapeRopeHandler INSTANCE = new EscapeRopeHandler();
    @NotNull
    private static final ArrayList<Task> runningTasks = new ArrayList();
    @NotNull
    private static final List<Direction> directionPriority;

    private EscapeRopeHandler() {
    }

    public final void addTask(@NotNull ServerPlayer player) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Iterable $this$any$iv = runningTasks;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Task it = (Task)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getPlayerReference().get(), (Object)player)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        Task task = new Task(new WeakReference<ServerPlayer>(player));
        runningTasks.add(task);
    }

    public final void tick() {
        Iterator<Task> iterator = runningTasks.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Task> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Task task;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (!task.tick()) continue;
            iterator2.remove();
        }
    }

    static {
        Object[] objectArray = new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.DOWN};
        directionPriority = ArraysKt.reversed((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0012\u001a\u00020\u0013J\n\u0010\u0014\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J(\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000bH\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u000ej\b\u0012\u0004\u0012\u00020\u000b`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/EscapeRopeHandler$Task;", "", "playerReference", "Ljava/lang/ref/WeakReference;", "Lnet/minecraft/server/level/ServerPlayer;", "<init>", "(Ljava/lang/ref/WeakReference;)V", "getPlayerReference", "()Ljava/lang/ref/WeakReference;", "toCheck", "Ljava/util/ArrayList;", "Lnet/minecraft/core/BlockPos;", "Lkotlin/collections/ArrayList;", "alreadyChecked", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "levelAtStart", "Lnet/minecraft/world/level/Level;", "tick", "", "getNextPositionToCheck", "isEmptySpace", "level", "pos", "expandSearchFrom", "", "teleportPlayerToSurface", "player", "item", "Lnet/minecraft/world/item/ItemStack;", "targetPos", "findGroundBelow", "irregular-implements-1.21.1"})
    private static final class Task {
        @NotNull
        private final WeakReference<ServerPlayer> playerReference;
        @NotNull
        private final ArrayList<BlockPos> toCheck;
        @NotNull
        private final HashSet<BlockPos> alreadyChecked;
        @Nullable
        private final Level levelAtStart;

        public Task(@NotNull WeakReference<ServerPlayer> playerReference) {
            Intrinsics.checkNotNullParameter(playerReference, (String)"playerReference");
            this.playerReference = playerReference;
            this.toCheck = new ArrayList();
            this.alreadyChecked = new HashSet();
            ServerPlayer serverPlayer = (ServerPlayer)this.playerReference.get();
            this.levelAtStart = serverPlayer != null ? serverPlayer.level() : null;
            ServerPlayer actualPlayer = (ServerPlayer)this.playerReference.get();
            if (actualPlayer != null) {
                this.toCheck.add(actualPlayer.blockPosition());
            }
        }

        @NotNull
        public final WeakReference<ServerPlayer> getPlayerReference() {
            return this.playerReference;
        }

        public final boolean tick() {
            ServerPlayer serverPlayer = (ServerPlayer)this.playerReference.get();
            if (serverPlayer == null) {
                return true;
            }
            ServerPlayer player = serverPlayer;
            ServerLevel level = player.serverLevel();
            ItemStack usedItem = player.getUseItem();
            if (!Intrinsics.areEqual((Object)level, (Object)this.levelAtStart) || !usedItem.is((Holder)ModItems.INSTANCE.getESCAPE_ROPE())) {
                return true;
            }
            Integer limit = (Integer)ServerConfig.Companion.getCONFIG().getEscapeRopeMaxBlocks().get();
            Integer maxRuns = (Integer)ServerConfig.Companion.getCONFIG().getEscapeRopeBlocksPerTick().get();
            boolean shouldSpawnIndicator = true;
            Set positionsToIndicate = new LinkedHashSet();
            Intrinsics.checkNotNull((Object)maxRuns);
            int n = maxRuns;
            for (int run = 0; run < n; ++run) {
                BlockPos nextPos;
                float progressToMaxColor = (float)Mth.clamp((int)this.alreadyChecked.size(), (int)0, (int)100000) / 100000.0f;
                int color = OtherUtil.INSTANCE.lerpColor(progressToMaxColor, DyeColor.LIME.getTextColor(), DyeColor.RED.getTextColor());
                String string = "%,d";
                Object[] objectArray = new Object[]{this.alreadyChecked.size()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                MutableComponent sizeComponent = Component.literal((String)string2).withColor(color);
                Object[] objectArray2 = new Object[]{sizeComponent};
                OtherUtil.INSTANCE.status((Player)player, (Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.escape_rope_handler.progress", objectArray2));
                if (this.toCheck.isEmpty() || limit > 1 && this.alreadyChecked.size() >= limit) {
                    boolean dropped;
                    boolean bl = dropped = player.drop(usedItem, true) != null;
                    if (dropped) {
                        player.stopUsingItem();
                        player.setItemInHand(player.getUsedItemHand(), ItemStack.EMPTY);
                    }
                    return true;
                }
                if (this.getNextPositionToCheck() == null) {
                    return true;
                }
                positionsToIndicate.add(nextPos);
                Intrinsics.checkNotNull((Object)level);
                if (!this.isEmptySpace((Level)level, nextPos)) {
                    this.alreadyChecked.add(nextPos);
                    continue;
                }
                if (!level.canSeeSky(nextPos)) {
                    this.expandSearchFrom(nextPos);
                    continue;
                }
                Level level2 = (Level)level;
                Intrinsics.checkNotNull((Object)usedItem);
                this.teleportPlayerToSurface(level2, player, usedItem, nextPos);
                return true;
            }
            AddIndicatorsPacket packet = new AddIndicatorsPacket(CollectionsKt.toList((Iterable)positionsToIndicate), 20, 0x8FFFFFF, null, 8, null);
            packet.messagePlayer(player);
            return false;
        }

        private final BlockPos getNextPositionToCheck() {
            while (!((Collection)this.toCheck).isEmpty()) {
                BlockPos pos;
                Intrinsics.checkNotNullExpressionValue((Object)this.toCheck.removeLast(), (String)"removeLast(...)");
                if (this.alreadyChecked.contains(pos)) continue;
                return pos;
            }
            return null;
        }

        private final boolean isEmptySpace(Level level, BlockPos pos) {
            return level.isLoaded(pos) && level.getBlockState(pos).getCollisionShape((BlockGetter)level, pos).isEmpty();
        }

        private final void expandSearchFrom(BlockPos pos) {
            this.alreadyChecked.add(pos);
            for (Direction direction : directionPriority) {
                BlockPos offset = pos.relative(direction);
                if (this.alreadyChecked.contains(offset)) continue;
                this.toCheck.add(offset);
            }
        }

        private final void teleportPlayerToSurface(Level level, ServerPlayer player, ItemStack item, BlockPos targetPos) {
            level.playSound(null, player.blockPosition(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 0.5f, 1.0f);
            BlockPos blockPos = this.findGroundBelow(level, targetPos);
            if (blockPos == null) {
                blockPos = targetPos.above();
            }
            BlockPos teleportPos = blockPos;
            player.teleportTo((double)teleportPos.getX() + 0.5, (double)teleportPos.getY(), (double)teleportPos.getZ() + 0.5);
            player.stopUsingItem();
            level.playSound(null, player.blockPosition(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 0.5f, 1.0f);
            item.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(item));
        }

        private final BlockPos findGroundBelow(Level level, BlockPos pos) {
            BlockPos.MutableBlockPos mutable = pos.mutable();
            int y = pos.getY();
            int n = level.getMinBuildHeight();
            if (n <= y) {
                while (true) {
                    boolean canStand;
                    mutable.setY(y);
                    BlockState state = level.getBlockState((BlockPos)mutable);
                    boolean bl = canStand = state.isFaceSturdy((BlockGetter)level, (BlockPos)mutable, Direction.UP) || state.isCollisionShapeFullBlock((BlockGetter)level, (BlockPos)mutable);
                    if (canStand) {
                        return mutable.above().immutable();
                    }
                    if (y == n) break;
                    --y;
                }
            }
            return null;
        }
    }
}

