/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.handler;

import dev.aaronhowser.mods.irregular_implements.client.ClientSpectreIllumination;
import dev.aaronhowser.mods.irregular_implements.packet.server_to_client.UpdateSpectreIlluminationPacket;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/SpectreIlluminationHandler;", "Lnet/minecraft/world/level/saveddata/SavedData;", "<init>", "()V", "illuminatedChunkLongs", "", "", "save", "Lnet/minecraft/nbt/CompoundTag;", "tag", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "isChunkIlluminated", "", "blockPos", "Lnet/minecraft/core/BlockPos;", "chunkPos", "Lnet/minecraft/world/level/ChunkPos;", "Companion", "irregular-implements-1.21.1"})
public final class SpectreIlluminationHandler
extends SavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Long> illuminatedChunkLongs = new LinkedHashSet();
    @NotNull
    public static final String CHUNK_LONGS = "chunk_longs";

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        tag.putLongArray(CHUNK_LONGS, CollectionsKt.toLongArray((Collection)this.illuminatedChunkLongs));
        return tag;
    }

    public final boolean isChunkIlluminated(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        long chunkPosLong = ChunkPos.asLong((BlockPos)blockPos);
        return this.illuminatedChunkLongs.contains(chunkPosLong);
    }

    public final boolean isChunkIlluminated(@NotNull ChunkPos chunkPos) {
        Intrinsics.checkNotNullParameter((Object)chunkPos, (String)"chunkPos");
        long chunkPosLong = chunkPos.toLong();
        return this.illuminatedChunkLongs.contains(chunkPosLong);
    }

    @JvmStatic
    public static final boolean isChunkIlluminated(@NotNull BlockAndTintGetter blockAndTintGetter, @NotNull BlockPos blockPos) {
        return Companion.isChunkIlluminated(blockAndTintGetter, blockPos);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0017J\u0016\u0010\u001e\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/SpectreIlluminationHandler$Companion;", "", "<init>", "()V", "CHUNK_LONGS", "", "load", "Ldev/aaronhowser/mods/irregular_implements/handler/SpectreIlluminationHandler;", "tag", "Lnet/minecraft/nbt/CompoundTag;", "provider", "Lnet/minecraft/core/HolderLookup$Provider;", "get", "level", "Lnet/minecraft/server/level/ServerLevel;", "watchChunk", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "chunkPos", "Lnet/minecraft/world/level/ChunkPos;", "stopWatchingChunk", "isChunkIlluminated", "", "blockAndTintGetter", "Lnet/minecraft/world/level/BlockAndTintGetter;", "blockPos", "Lnet/minecraft/core/BlockPos;", "setChunkIlluminated", "newValue", "forceLightUpdates", "Lnet/minecraft/world/level/Level;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        private final SpectreIlluminationHandler load(CompoundTag tag, HolderLookup.Provider provider) {
            SpectreIlluminationHandler data = new SpectreIlluminationHandler();
            long[] chunkLongs = tag.getLongArray(SpectreIlluminationHandler.CHUNK_LONGS);
            Set set = data.illuminatedChunkLongs;
            Intrinsics.checkNotNull((Object)chunkLongs);
            set.addAll(ArraysKt.toList((long[])chunkLongs));
            return data;
        }

        @NotNull
        public final SpectreIlluminationHandler get(@NotNull ServerLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            SavedData savedData = level.getDataStorage().computeIfAbsent(new SavedData.Factory(SpectreIlluminationHandler::new, this::load), "spectre_illumination_handler");
            Intrinsics.checkNotNullExpressionValue((Object)savedData, (String)"computeIfAbsent(...)");
            return (SpectreIlluminationHandler)savedData;
        }

        public final void watchChunk(@NotNull ServerPlayer player, @NotNull ChunkPos chunkPos) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)chunkPos, (String)"chunkPos");
            ServerLevel serverLevel = player.serverLevel();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"serverLevel(...)");
            SpectreIlluminationHandler handler = this.get(serverLevel);
            if (handler.isChunkIlluminated(chunkPos)) {
                UpdateSpectreIlluminationPacket packet = new UpdateSpectreIlluminationPacket(chunkPos.toLong(), true);
                packet.messagePlayer(player);
            }
        }

        public final void stopWatchingChunk(@NotNull ServerPlayer player, @NotNull ChunkPos chunkPos) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)chunkPos, (String)"chunkPos");
            ServerLevel serverLevel = player.serverLevel();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"serverLevel(...)");
            SpectreIlluminationHandler handler = this.get(serverLevel);
            if (handler.isChunkIlluminated(chunkPos)) {
                UpdateSpectreIlluminationPacket packet = new UpdateSpectreIlluminationPacket(chunkPos.toLong(), false);
                packet.messagePlayer(player);
            }
        }

        @JvmStatic
        public final boolean isChunkIlluminated(@NotNull BlockAndTintGetter blockAndTintGetter, @NotNull BlockPos blockPos) {
            boolean bl;
            boolean isClientSide;
            Intrinsics.checkNotNullParameter((Object)blockAndTintGetter, (String)"blockAndTintGetter");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            boolean bl2 = blockAndTintGetter instanceof Level ? ((Level)blockAndTintGetter).isClientSide : (isClientSide = !FMLEnvironment.dist.isDedicatedServer());
            if (isClientSide) {
                bl = ClientSpectreIllumination.isChunkIlluminated(blockPos);
            } else {
                ServerLevel serverLevel = blockAndTintGetter instanceof ServerLevel ? (ServerLevel)blockAndTintGetter : null;
                if (serverLevel == null) {
                    return false;
                }
                ServerLevel level = serverLevel;
                bl = this.isChunkIlluminated(level, blockPos);
            }
            return bl;
        }

        public final boolean isChunkIlluminated(@NotNull ServerLevel level, @NotNull BlockPos blockPos) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            SpectreIlluminationHandler handler = this.get(level);
            return handler.isChunkIlluminated(blockPos);
        }

        public final void setChunkIlluminated(@NotNull ServerLevel level, @NotNull BlockPos blockPos, boolean newValue) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            SpectreIlluminationHandler handler = this.get(level);
            ChunkPos chunkPos = new ChunkPos(blockPos);
            long chunkPosLong = chunkPos.toLong();
            boolean bl = newValue ? handler.illuminatedChunkLongs.add(chunkPosLong) : handler.illuminatedChunkLongs.remove(chunkPosLong);
            UpdateSpectreIlluminationPacket packet = new UpdateSpectreIlluminationPacket(chunkPosLong, newValue);
            packet.messageAllPlayersTrackingChunk(level, chunkPos);
            this.forceLightUpdates((Level)level, chunkPos);
            level.getChunk(blockPos).setUnsaved(true);
            handler.setDirty();
        }

        public final void forceLightUpdates(@NotNull Level level, @NotNull ChunkPos chunkPos) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)chunkPos, (String)"chunkPos");
            if (!level.isLoaded(chunkPos.getWorldPosition())) {
                return;
            }
            int minX = chunkPos.getMinBlockX() - 1;
            int maxX = chunkPos.getMaxBlockX() + 1;
            int minZ = chunkPos.getMinBlockZ() - 1;
            int maxZ = chunkPos.getMaxBlockZ() + 1;
            int minY = level.getMinBuildHeight();
            int maxY = level.getMaxBuildHeight();
            Iterable iterable = BlockPos.betweenClosed((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ);
            for (BlockPos pos : iterable) {
                level.getChunkSource().getLightEngine().checkBlock(pos.immutable());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

