/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.handler.redstone_signal;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 %2\u00020\u0001:\u0001%B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003JA\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010 \u001a\u00020\u00182\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\bH\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006&"}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/redstone_signal/SavedSignal;", "", "blockPos", "", "dimension", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/Level;", "duration", "", "strength", "startTick", "<init>", "(JLnet/minecraft/resources/ResourceKey;IIJ)V", "getBlockPos", "()J", "getDimension", "()Lnet/minecraft/resources/ResourceKey;", "getDuration", "()I", "getStrength", "getStartTick", "toTag", "Lnet/minecraft/nbt/CompoundTag;", "isExpired", "", "currentTick", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "irregular-implements-1.21.1"})
public final class SavedSignal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long blockPos;
    @NotNull
    private final ResourceKey<Level> dimension;
    private final int duration;
    private final int strength;
    private final long startTick;
    @NotNull
    public static final String TAG_BLOCK_POS = "block_pos";
    @NotNull
    public static final String TAG_DIMENSION = "dimension";
    @NotNull
    public static final String TAG_DURATION = "duration";
    @NotNull
    public static final String TAG_STRENGTH = "strength";
    @NotNull
    public static final String TAG_START_TICK = "start_tick";

    public SavedSignal(long blockPos, @NotNull ResourceKey<Level> dimension, int duration, int strength, long startTick) {
        Intrinsics.checkNotNullParameter(dimension, (String)TAG_DIMENSION);
        this.blockPos = blockPos;
        this.dimension = dimension;
        this.duration = duration;
        this.strength = strength;
        this.startTick = startTick;
    }

    public final long getBlockPos() {
        return this.blockPos;
    }

    @NotNull
    public final ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public final int getDuration() {
        return this.duration;
    }

    public final int getStrength() {
        return this.strength;
    }

    public final long getStartTick() {
        return this.startTick;
    }

    @NotNull
    public final CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.putLong(TAG_BLOCK_POS, this.blockPos);
        tag.putString(TAG_DIMENSION, this.dimension.location().toString());
        tag.putInt(TAG_DURATION, this.duration);
        tag.putInt(TAG_STRENGTH, this.strength);
        tag.putLong(TAG_START_TICK, this.startTick);
        return tag;
    }

    public final boolean isExpired(long currentTick) {
        return currentTick - this.startTick >= (long)this.duration;
    }

    public final long component1() {
        return this.blockPos;
    }

    @NotNull
    public final ResourceKey<Level> component2() {
        return this.dimension;
    }

    public final int component3() {
        return this.duration;
    }

    public final int component4() {
        return this.strength;
    }

    public final long component5() {
        return this.startTick;
    }

    @NotNull
    public final SavedSignal copy(long blockPos, @NotNull ResourceKey<Level> dimension, int duration, int strength, long startTick) {
        Intrinsics.checkNotNullParameter(dimension, (String)TAG_DIMENSION);
        return new SavedSignal(blockPos, dimension, duration, strength, startTick);
    }

    public static /* synthetic */ SavedSignal copy$default(SavedSignal savedSignal, long l, ResourceKey resourceKey, int n, int n2, long l2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            l = savedSignal.blockPos;
        }
        if ((n3 & 2) != 0) {
            resourceKey = savedSignal.dimension;
        }
        if ((n3 & 4) != 0) {
            n = savedSignal.duration;
        }
        if ((n3 & 8) != 0) {
            n2 = savedSignal.strength;
        }
        if ((n3 & 0x10) != 0) {
            l2 = savedSignal.startTick;
        }
        return savedSignal.copy(l, resourceKey, n, n2, l2);
    }

    @NotNull
    public String toString() {
        return "SavedSignal(blockPos=" + this.blockPos + ", dimension=" + this.dimension + ", duration=" + this.duration + ", strength=" + this.strength + ", startTick=" + this.startTick + ")";
    }

    public int hashCode() {
        int result = Long.hashCode(this.blockPos);
        result = result * 31 + this.dimension.hashCode();
        result = result * 31 + Integer.hashCode(this.duration);
        result = result * 31 + Integer.hashCode(this.strength);
        result = result * 31 + Long.hashCode(this.startTick);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SavedSignal)) {
            return false;
        }
        SavedSignal savedSignal = (SavedSignal)other;
        if (this.blockPos != savedSignal.blockPos) {
            return false;
        }
        if (!Intrinsics.areEqual(this.dimension, savedSignal.dimension)) {
            return false;
        }
        if (this.duration != savedSignal.duration) {
            return false;
        }
        if (this.strength != savedSignal.strength) {
            return false;
        }
        return this.startTick == savedSignal.startTick;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/redstone_signal/SavedSignal$Companion;", "", "<init>", "()V", "TAG_BLOCK_POS", "", "TAG_DIMENSION", "TAG_DURATION", "TAG_STRENGTH", "TAG_START_TICK", "fromTag", "Ldev/aaronhowser/mods/irregular_implements/handler/redstone_signal/SavedSignal;", "tag", "Lnet/minecraft/nbt/CompoundTag;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SavedSignal fromTag(@NotNull CompoundTag tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            long blockPos = tag.getLong(SavedSignal.TAG_BLOCK_POS);
            ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)tag.getString(SavedSignal.TAG_DIMENSION)));
            int duration = tag.getInt(SavedSignal.TAG_DURATION);
            int strength = tag.getInt(SavedSignal.TAG_STRENGTH);
            long startTick = tag.getLong(SavedSignal.TAG_START_TICK);
            Intrinsics.checkNotNull((Object)dimension);
            return new SavedSignal(blockPos, (ResourceKey<Level>)dimension, duration, strength, startTick);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

