/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.handler.spectre_cube;

import dev.aaronhowser.mods.irregular_implements.datagen.datapack.ModDimensions;
import dev.aaronhowser.mods.irregular_implements.handler.spectre_cube.SpectreCube;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/spectre_cube/SpectreCubeSavedData;", "Lnet/minecraft/world/level/saveddata/SavedData;", "<init>", "()V", "cubes", "", "Ljava/util/UUID;", "Ldev/aaronhowser/mods/irregular_implements/handler/spectre_cube/SpectreCube;", "positionCounter", "", "save", "Lnet/minecraft/nbt/CompoundTag;", "tag", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "teleportPlayerToSpectreCube", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "generateSpectreCube", "uuid", "spectreLevel", "Lnet/minecraft/server/level/ServerLevel;", "getSpectreCubeFromBlockPos", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "verifyPosition", "teleportPlayerBack", "Companion", "irregular-implements-1.21.1"})
public final class SpectreCubeSavedData
extends SavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<UUID, SpectreCube> cubes = new LinkedHashMap();
    private int positionCounter;
    @NotNull
    public static final String CUBES_NBT = "cubes";
    @NotNull
    public static final String CUBE_NBT = "cube";
    @NotNull
    public static final String UUID_NBT = "uuid";
    @NotNull
    public static final String POSITION_COUNTER_NBT = "position_counter";
    @NotNull
    public static final String PLAYER_SPECTRE_INFO = "ii_spectre_cube_info";
    @NotNull
    public static final String FROM_X = "from_x";
    @NotNull
    public static final String FROM_Y = "from_y";
    @NotNull
    public static final String FROM_Z = "from_z";
    @NotNull
    public static final String FROM_DIMENSION = "from_dimension";

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        ListTag listTag = tag.getList(CUBES_NBT, 10);
        for (Map.Entry<UUID, SpectreCube> entry2 : this.cubes.entrySet()) {
            UUID uuid = entry2.getKey();
            SpectreCube cube = entry2.getValue();
            CompoundTag cubeTag = new CompoundTag();
            cubeTag.putUUID(UUID_NBT, uuid);
            cubeTag.put(CUBE_NBT, (Tag)cube.toTag());
            listTag.add((Object)cubeTag);
        }
        tag.put(CUBES_NBT, (Tag)listTag);
        tag.putInt(POSITION_COUNTER_NBT, this.positionCounter);
        return tag;
    }

    public final void teleportPlayerToSpectreCube(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ServerLevel serverLevel = player.serverLevel();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"serverLevel(...)");
        ServerLevel spectreLevel = Companion.getSpectreLevel(serverLevel);
        CompoundTag pData = player.getPersistentData();
        CompoundTag tag = new CompoundTag();
        tag.putDouble(FROM_X, player.getX());
        tag.putDouble(FROM_Y, player.getY());
        tag.putDouble(FROM_Z, player.getZ());
        tag.putString(FROM_DIMENSION, player.level().dimension().location().toString());
        pData.put(PLAYER_SPECTRE_INFO, (Tag)tag);
        UUID uuid = player.getUUID();
        SpectreCube cube = this.cubes.get(uuid);
        if (cube == null) {
            Intrinsics.checkNotNull((Object)uuid);
            cube = this.generateSpectreCube(uuid, spectreLevel);
        }
        BlockPos spawnPos = cube.getSpawnPos();
        player.teleportTo(spectreLevel, (double)spawnPos.getX() + 0.5, (double)spawnPos.getY() + 1.0, (double)spawnPos.getZ() + 0.5, player.getYRot(), player.getXRot());
    }

    private final SpectreCube generateSpectreCube(UUID uuid, ServerLevel spectreLevel) {
        SpectreCube cube = new SpectreCube(this, uuid, this.positionCounter);
        int n = this.positionCounter;
        this.positionCounter = n + 1;
        cube.generate((Level)spectreLevel);
        this.cubes.put(uuid, cube);
        this.setDirty();
        return cube;
    }

    @Nullable
    public final SpectreCube getSpectreCubeFromBlockPos(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (!Intrinsics.areEqual((Object)level.dimension(), ModDimensions.INSTANCE.getSPECTRE_LEVEL_KEY())) {
            return null;
        }
        int n = pos.getZ();
        if (!(0 <= n ? n < 17 : false)) {
            return null;
        }
        LevelChunk chunk = level.getChunkAt(pos);
        int cubeIndex = chunk.getPos().x;
        for (SpectreCube cube : this.cubes.values()) {
            if (cube.getCubeIndex() != cubeIndex) continue;
            int cubeOriginX = cube.getOriginPos().getX();
            if (pos.getY() < 0 || pos.getY() > cube.getInteriorHeight() + 1 || pos.getX() < cubeOriginX || pos.getX() >= cubeOriginX + 15) {
                return null;
            }
            return cube;
        }
        return null;
    }

    public final void verifyPosition(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.isCreative() || player.isSpectator()) {
            return;
        }
        BlockPos pos = player.blockPosition();
        ServerLevel serverLevel = player.serverLevel();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"serverLevel(...)");
        Level level = (Level)serverLevel;
        Intrinsics.checkNotNull((Object)pos);
        SpectreCube cube = this.getSpectreCubeFromBlockPos(level, pos);
        UUID playerUuid = player.getUUID();
        if (cube != null && Intrinsics.areEqual((Object)cube.getOwner(), (Object)playerUuid)) {
            return;
        }
        SpectreCube playersCube = this.cubes.get(playerUuid);
        if (playersCube == null) {
            this.teleportPlayerBack(player);
            return;
        }
        BlockPos spawn = playersCube.getSpawnPos();
        player.teleportTo((double)spawn.getX() + 0.5, (double)spawn.getY() + 1.0, (double)spawn.getZ() + 0.5);
    }

    public final void teleportPlayerBack(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        CompoundTag pData = player.getPersistentData();
        if (!pData.contains(PLAYER_SPECTRE_INFO)) {
            return;
        }
        CompoundTag tag = pData.getCompound(PLAYER_SPECTRE_INFO);
        double fromX = tag.getDouble(FROM_X);
        double fromY = tag.getDouble(FROM_Y);
        double fromZ = tag.getDouble(FROM_Z);
        String fromDimension = tag.getString(FROM_DIMENSION);
        ResourceLocation dimRl = ResourceLocation.parse((String)fromDimension);
        ResourceKey dimRk = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimRl);
        ServerLevel serverLevel = player.server.getLevel(dimRk);
        if (serverLevel == null) {
            return;
        }
        ServerLevel level = serverLevel;
        player.teleportTo(level, fromX, fromY, fromZ, player.getYRot(), player.getXRot());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/spectre_cube/SpectreCubeSavedData$Companion;", "", "<init>", "()V", "CUBES_NBT", "", "CUBE_NBT", "UUID_NBT", "POSITION_COUNTER_NBT", "PLAYER_SPECTRE_INFO", "FROM_X", "FROM_Y", "FROM_Z", "FROM_DIMENSION", "load", "Ldev/aaronhowser/mods/irregular_implements/handler/spectre_cube/SpectreCubeSavedData;", "tag", "Lnet/minecraft/nbt/CompoundTag;", "provider", "Lnet/minecraft/core/HolderLookup$Provider;", "get", "level", "Lnet/minecraft/server/level/ServerLevel;", "getSpectreLevel", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        private final SpectreCubeSavedData load(CompoundTag tag, HolderLookup.Provider provider) {
            SpectreCubeSavedData data = new SpectreCubeSavedData();
            ListTag listTag = tag.getList(SpectreCubeSavedData.CUBES_NBT, 10);
            int n = ((Collection)listTag).size();
            for (int i = 0; i < n; ++i) {
                UUID ownerTag;
                CompoundTag ownerAndCubeTag = listTag.getCompound(i);
                Intrinsics.checkNotNull((Object)ownerAndCubeTag);
                if (OtherUtil.INSTANCE.getUuidOrNull(ownerAndCubeTag, SpectreCubeSavedData.UUID_NBT) == null) continue;
                CompoundTag cubeTag = ownerAndCubeTag.getCompound(SpectreCubeSavedData.CUBE_NBT);
                Intrinsics.checkNotNull((Object)cubeTag);
                SpectreCube cube = SpectreCube.Companion.fromTag(data, cubeTag);
                data.cubes.put(ownerTag, cube);
            }
            data.positionCounter = tag.getInt(SpectreCubeSavedData.POSITION_COUNTER_NBT);
            return data;
        }

        @NotNull
        public final SpectreCubeSavedData get(@NotNull ServerLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            if (!Intrinsics.areEqual((Object)level, (Object)level.getServer().overworld())) {
                ServerLevel serverLevel = level.getServer().overworld();
                Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"overworld(...)");
                return this.get(serverLevel);
            }
            SpectreCubeSavedData savedData = (SpectreCubeSavedData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(SpectreCubeSavedData::new, this::load), "spectre_cube");
            Intrinsics.checkNotNull((Object)((Object)savedData));
            return savedData;
        }

        @NotNull
        public final ServerLevel getSpectreLevel(@NotNull ServerLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            ServerLevel serverLevel = level.getServer().getLevel(ModDimensions.INSTANCE.getSPECTRE_LEVEL_KEY());
            if (serverLevel == null) {
                throw new IllegalStateException("Spectre dimension not found");
            }
            return serverLevel;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

