/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import dev.aaronhowser.mods.irregular_implements.config.ServerConfig;
import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.datagen.tag.ModBlockTagsProvider;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J8\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J.\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a8\u0006\""}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/BlockReplacerItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "overrideOtherStackedOnMe", "", "thisStack", "Lnet/minecraft/world/item/ItemStack;", "other", "slot", "Lnet/minecraft/world/inventory/Slot;", "action", "Lnet/minecraft/world/inventory/ClickAction;", "player", "Lnet/minecraft/world/entity/player/Player;", "access", "Lnet/minecraft/world/entity/SlotAccess;", "overrideStackedOnOther", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Companion", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nBlockReplacerItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockReplacerItem.kt\ndev/aaronhowser/mods/irregular_implements/item/BlockReplacerItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,312:1\n1761#2,3:313\n*S KotlinDebug\n*F\n+ 1 BlockReplacerItem.kt\ndev/aaronhowser/mods/irregular_implements/item/BlockReplacerItem\n*L\n116#1:313,3\n*E\n"})
public final class BlockReplacerItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Item.Properties DEFAULT_PROPERTIES;

    public BlockReplacerItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return InteractionResult.PASS;
        }
        ServerLevel level2 = serverLevel;
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Player player2 = player;
        ItemStack usedStack = context.getItemInHand();
        BlockPos clickedPos = context.getClickedPos();
        BlockState clickedState = level2.getBlockState(clickedPos);
        Intrinsics.checkNotNull((Object)usedStack);
        Intrinsics.checkNotNull((Object)clickedPos);
        Direction direction = context.getClickedFace();
        Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"getClickedFace(...)");
        if (!Companion.canRemoveBlock(player2, usedStack, clickedPos, direction)) {
            return InteractionResult.FAIL;
        }
        List<ItemStack> storedStacks = Companion.getStoredStacks(usedStack);
        if (storedStacks.isEmpty()) {
            return InteractionResult.PASS;
        }
        Intrinsics.checkNotNull((Object)clickedState);
        Pair<BlockState, ItemStack> pair = Companion.getStateToPlace(storedStacks, context, clickedState, clickedPos, level2, player2);
        if (pair == null) {
            return InteractionResult.FAIL;
        }
        Pair<BlockState, ItemStack> pair2 = pair;
        BlockState stateToPlace = (BlockState)pair2.component1();
        ItemStack stackToPlace = (ItemStack)pair2.component2();
        boolean successfullyPlaced = Companion.tryPlaceBlock((Level)level2, clickedPos, clickedState, stateToPlace, player2);
        if (!successfullyPlaced) {
            return InteractionResult.FAIL;
        }
        SoundType originalStateSoundType = clickedState.getSoundType((LevelReader)level2, clickedPos, (Entity)player2);
        level2.playSound(null, clickedPos, originalStateSoundType.getBreakSound(), SoundSource.BLOCKS, (originalStateSoundType.volume + 1.0f) / 2.0f, originalStateSoundType.pitch * 0.8f);
        SoundType newStateSoundType = stateToPlace.getSoundType((LevelReader)level2, clickedPos, (Entity)player2);
        level2.playSound(null, clickedPos, newStateSoundType.getPlaceSound(), SoundSource.BLOCKS, (newStateSoundType.volume + 1.0f) / 2.0f, newStateSoundType.pitch * 0.8f);
        Vec3 vec3 = context.getClickLocation();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getClickLocation(...)");
        List<ItemStack> drops = Companion.getLoot(player2, level2, vec3, clickedState, clickedPos);
        for (ItemStack drop : drops) {
            Block.popResourceFromFace((Level)((Level)level2), (BlockPos)clickedPos, (Direction)context.getClickedFace(), (ItemStack)drop);
        }
        stackToPlace.consume(1, (LivingEntity)player2);
        usedStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(storedStacks));
        return InteractionResult.SUCCESS;
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack thisStack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        boolean mayInsert;
        boolean bl;
        List storedStacks;
        block6: {
            Intrinsics.checkNotNullParameter((Object)thisStack, (String)"thisStack");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)access, (String)"access");
            if (action != ClickAction.SECONDARY || !slot.allowModification(player) || !(other.getItem() instanceof BlockItem)) {
                return false;
            }
            ItemContainerContents itemContainerContents = (ItemContainerContents)thisStack.get(DataComponents.CONTAINER);
            if (itemContainerContents == null) {
                itemContainerContents = ItemContainerContents.fromItems((List)CollectionsKt.emptyList());
            }
            ItemContainerContents currentContents = itemContainerContents;
            Iterable iterable = currentContents.nonEmptyItems();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"nonEmptyItems(...)");
            storedStacks = CollectionsKt.toList((Iterable)iterable);
            Iterable $this$any$iv = storedStacks;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getItem(), (Object)other.getItem())) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean bl3 = mayInsert = bl || storedStacks.size() + 1 <= ((Number)ServerConfig.Companion.getCONFIG().getBlockReplacerUniqueBlocks().get()).intValue();
        if (!mayInsert) {
            return false;
        }
        List<ItemStack> newContents = OtherUtil.INSTANCE.flattenStacks(CollectionsKt.plus((Collection)storedStacks, (Object)other.copy()));
        thisStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(newContents));
        other.setCount(0);
        player.level().playSound((Player)(player.level().isClientSide ? player : null), player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 0.33f);
        return true;
    }

    public boolean overrideStackedOnOther(@NotNull ItemStack thisStack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)thisStack, (String)"thisStack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (action != ClickAction.SECONDARY || !slot.allowModification(player)) {
            return false;
        }
        ItemStack otherStack = slot.getItem();
        if (!otherStack.isEmpty()) {
            return false;
        }
        ItemContainerContents itemContainerContents = (ItemContainerContents)thisStack.get(DataComponents.CONTAINER);
        if (itemContainerContents == null) {
            return false;
        }
        ItemContainerContents currentContents = itemContainerContents;
        Iterable iterable = currentContents.nonEmptyItems();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"nonEmptyItems(...)");
        List storedStacks = CollectionsKt.toMutableList((Iterable)iterable);
        if (storedStacks.isEmpty()) {
            return false;
        }
        ItemStack stackToInsert = (ItemStack)storedStacks.removeLast();
        slot.set(stackToInsert.copy());
        thisStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)storedStacks));
        player.level().playSound((Player)(player.level().isClientSide ? player : null), player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 0.33f);
        return true;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        if (!tooltipFlag.hasShiftDown()) {
            MutableComponent controlsComponent = ModLanguageProvider.Companion.toGrayComponent("tooltip.irregular_implements.shift_for_more", new Object[0]);
            v0 = tooltipComponents.add((Component)controlsComponent);
        } else {
            MutableComponent loadingComponent = ModLanguageProvider.Companion.toGrayComponent("tooltip.irregular_implements.block_replacer_loading", new Object[0]);
            MutableComponent unloadingComponent = ModLanguageProvider.Companion.toGrayComponent("tooltip.irregular_implements.block_replacer_unloading", new Object[0]);
            tooltipComponents.add((Component)loadingComponent);
            v0 = tooltipComponents.add((Component)unloadingComponent);
        }
        if ((object = (ItemContainerContents)stack.get(DataComponents.CONTAINER)) == null || (object = object.nonEmptyItems()) == null || (object = CollectionsKt.toList((Iterable)object)) == null) {
            return;
        }
        Object storedStacks = object;
        if (!tooltipFlag.hasAltDown()) {
            MutableComponent altComponent = ModLanguageProvider.Companion.toGrayComponent("tooltip.irregular_implements.block_replacer_alt_for_list", new Object[0]);
            tooltipComponents.add((Component)altComponent);
        } else {
            Map map = new LinkedHashMap();
            Iterator<Object> iterator = storedStacks.iterator();
            while (iterator.hasNext()) {
                ItemStack entry2 = (ItemStack)iterator.next();
                Item item = entry2.getItem();
                Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
                int count = ((Number)map.getOrDefault(item, 0)).intValue();
                map.put(entry2.getItem(), count + entry2.getCount());
            }
            for (Map.Entry entry2 : map.entrySet()) {
                Item item = (Item)entry2.getKey();
                int count = ((Number)entry2.getValue()).intValue();
                Component itemComponent = item.getDefaultInstance().getDisplayName();
                Object[] objectArray = new Object[]{itemComponent, count};
                MutableComponent component = ModLanguageProvider.Companion.toGrayComponent("tooltip.irregular_implements.item_count", objectArray);
                tooltipComponents.add((Component)component);
            }
        }
    }

    static {
        Item.Properties properties = new Item.Properties().stacksTo(1);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        DEFAULT_PROPERTIES = properties;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\f\u001a\u00020\rJJ\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\r\u0018\u00010\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u000bJ.\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bJ4\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006$"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/BlockReplacerItem$Companion;", "", "<init>", "()V", "DEFAULT_PROPERTIES", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "canRemoveBlock", "", "player", "Lnet/minecraft/world/entity/player/Player;", "replacerStack", "Lnet/minecraft/world/item/ItemStack;", "pos", "Lnet/minecraft/core/BlockPos;", "face", "Lnet/minecraft/core/Direction;", "getStoredStacks", "", "getStateToPlace", "Lkotlin/Pair;", "Lnet/minecraft/world/level/block/state/BlockState;", "storedStacks", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "clickedState", "clickedPos", "level", "Lnet/minecraft/server/level/ServerLevel;", "tryPlaceBlock", "Lnet/minecraft/world/level/Level;", "stateToPlace", "getLoot", "clickLocation", "Lnet/minecraft/world/phys/Vec3;", "irregular-implements-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nBlockReplacerItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockReplacerItem.kt\ndev/aaronhowser/mods/irregular_implements/item/BlockReplacerItem$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,312:1\n774#2:313\n865#2,2:314\n774#2:316\n865#2,2:317\n*S KotlinDebug\n*F\n+ 1 BlockReplacerItem.kt\ndev/aaronhowser/mods/irregular_implements/item/BlockReplacerItem$Companion\n*L\n242#1:313\n242#1:314,2\n243#1:316\n243#1:317,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Item.Properties getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        public final boolean canRemoveBlock(@NotNull Player player, @NotNull ItemStack replacerStack, @NotNull BlockPos pos, @NotNull Direction face) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)replacerStack, (String)"replacerStack");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)face, (String)"face");
            Level level = player.level();
            BlockState state = level.getBlockState(pos);
            return !(state.getDestroySpeed((BlockGetter)level, pos) == 1.0f) && !state.is(ModBlockTagsProvider.Companion.getBLOCK_REPLACER_BLACKLIST()) && player.mayUseItemAt(pos, face, replacerStack);
        }

        @NotNull
        public final List<ItemStack> getStoredStacks(@NotNull ItemStack replacerStack) {
            Intrinsics.checkNotNullParameter((Object)replacerStack, (String)"replacerStack");
            Object object = (ItemContainerContents)replacerStack.get(DataComponents.CONTAINER);
            if (object == null || (object = object.nonEmptyItems()) == null || (object = CollectionsKt.toList((Iterable)object)) == null) {
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Pair<BlockState, ItemStack> getStateToPlace(@NotNull List<ItemStack> storedStacks, @NotNull UseOnContext context, @NotNull BlockState clickedState, @NotNull BlockPos clickedPos, @NotNull ServerLevel level, @NotNull Player player) {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullParameter(storedStacks, (String)"storedStacks");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)clickedState, (String)"clickedState");
            Intrinsics.checkNotNullParameter((Object)clickedPos, (String)"clickedPos");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Iterable $this$filter$iv = storedStacks;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                ItemStack it = (ItemStack)element$iv$iv;
                boolean bl = false;
                if (!(it.getItem() instanceof BlockItem)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List storedBlockStacks = (List)destination$iv$iv;
            Iterable $this$filter$iv2 = storedBlockStacks;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ItemStack it = (ItemStack)element$iv$iv;
                boolean bl = false;
                Item item = it.getItem();
                Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.minecraft.world.item.BlockItem");
                Block block = ((BlockItem)item).getBlock();
                if (!(!clickedState.is(block) && block.getStateForPlacement(new BlockPlaceContext(context)) != null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List possibleBlocksToPlace = (List)destination$iv$iv2;
            ItemStack itemStack = (ItemStack)CollectionsKt.randomOrNull((Collection)possibleBlocksToPlace, (Random)((Random)Random.Default));
            if (itemStack == null) {
                return null;
            }
            ItemStack stackToPlace = itemStack;
            Item item = stackToPlace.getItem();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.minecraft.world.item.BlockItem");
            BlockState blockState = ((BlockItem)item).getBlock().getStateForPlacement(new BlockPlaceContext(context));
            if (blockState == null) {
                return null;
            }
            BlockState stateToPlace = blockState;
            if (!stateToPlace.canSurvive((LevelReader)level, clickedPos) && ((BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent((Level)level, clickedPos, clickedState, player))).isCanceled()) {
                return null;
            }
            return new Pair((Object)stateToPlace, (Object)stackToPlace);
        }

        public final boolean tryPlaceBlock(@NotNull Level level, @NotNull BlockPos clickedPos, @NotNull BlockState clickedState, @NotNull BlockState stateToPlace, @NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)clickedPos, (String)"clickedPos");
            Intrinsics.checkNotNullParameter((Object)clickedState, (String)"clickedState");
            Intrinsics.checkNotNullParameter((Object)stateToPlace, (String)"stateToPlace");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            level.captureBlockSnapshots = true;
            level.setBlockAndUpdate(clickedPos, stateToPlace);
            level.captureBlockSnapshots = false;
            ArrayList arrayList = level.capturedBlockSnapshots;
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"capturedBlockSnapshots");
            List snapshots = CollectionsKt.toList((Iterable)arrayList);
            level.capturedBlockSnapshots.clear();
            for (BlockSnapshot snapshot : snapshots) {
                if (!((BlockEvent.EntityPlaceEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.EntityPlaceEvent(snapshot, clickedState, (Entity)player))).isCanceled()) continue;
                level.restoringBlockSnapshots = true;
                snapshot.restore(snapshot.getFlags() | 2);
                level.restoringBlockSnapshots = false;
                return false;
            }
            return true;
        }

        @NotNull
        public final List<ItemStack> getLoot(@NotNull Player player, @NotNull ServerLevel level, @NotNull Vec3 clickLocation, @NotNull BlockState clickedState, @NotNull BlockPos clickedPos) {
            List list;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)clickLocation, (String)"clickLocation");
            Intrinsics.checkNotNullParameter((Object)clickedState, (String)"clickedState");
            Intrinsics.checkNotNullParameter((Object)clickedPos, (String)"clickedPos");
            if (player.hasInfiniteMaterials()) {
                list = CollectionsKt.emptyList();
            } else {
                LootParams.Builder lootParams = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)clickLocation).withParameter(LootContextParams.BLOCK_STATE, (Object)clickedState).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)level.getBlockEntity(clickedPos)).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.TOOL, (Object)Items.IRON_PICKAXE.getDefaultInstance());
                List list2 = clickedState.getDrops(lootParams);
                Intrinsics.checkNotNull((Object)list2);
                list = list2;
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

