/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import dev.aaronhowser.mods.irregular_implements.util.RenderUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0016J.\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001c"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/EnderBucketItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "getMaxStackSize", "", "stack", "appendHoverText", "", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Companion", "irregular-implements-1.21.1"})
public final class EnderBucketItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Item.Properties DEFAULT_PROPERTIES;
    @NotNull
    private static final ResourceLocation HAS_FLUID;

    public EnderBucketItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        InteractionResultHolder interactionResultHolder;
        SimpleFluidContent currentContents;
        BlockHitResult blockHitResult;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack usedStack = player.getItemInHand(usedHand);
        SimpleFluidContent simpleFluidContent = (SimpleFluidContent)usedStack.get((Supplier)ModDataComponents.INSTANCE.getSIMPLE_FLUID_CONTENT());
        if (simpleFluidContent == null) {
            simpleFluidContent = SimpleFluidContent.EMPTY;
        }
        if ((blockHitResult = Item.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)((currentContents = simpleFluidContent).isEmpty() ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE))).getType() != HitResult.Type.BLOCK) {
            InteractionResultHolder interactionResultHolder2 = InteractionResultHolder.pass((Object)usedStack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder2, (String)"pass(...)");
            return interactionResultHolder2;
        }
        BlockPos clickedPos = blockHitResult.getBlockPos();
        Direction clickedFace = blockHitResult.getDirection();
        BlockPos blockPos = clickedPos.relative(clickedFace);
        if (!level.mayInteract(player, clickedPos) || !player.mayUseItemAt(blockPos, clickedFace, usedStack)) {
            InteractionResultHolder interactionResultHolder3 = InteractionResultHolder.fail((Object)usedStack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder3, (String)"fail(...)");
            return interactionResultHolder3;
        }
        if (currentContents.isEmpty()) {
            Intrinsics.checkNotNull((Object)usedStack);
            Intrinsics.checkNotNull((Object)clickedPos);
            interactionResultHolder = EnderBucketItem.Companion.tryFill(level, player, usedStack, clickedPos);
        } else {
            Intrinsics.checkNotNull((Object)usedStack);
            Intrinsics.checkNotNull((Object)clickedPos);
            Intrinsics.checkNotNull((Object)blockPos);
            Intrinsics.checkNotNull((Object)blockHitResult);
            interactionResultHolder = EnderBucketItem.Companion.tryEmpty(level, player, usedStack, clickedPos, blockPos, blockHitResult);
        }
        return interactionResultHolder;
    }

    public int getMaxStackSize(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return stack.has((Supplier)ModDataComponents.INSTANCE.getSIMPLE_FLUID_CONTENT()) ? 1 : 16;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        SimpleFluidContent fluidContent;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        SimpleFluidContent simpleFluidContent = (SimpleFluidContent)stack.get((Supplier)ModDataComponents.INSTANCE.getSIMPLE_FLUID_CONTENT());
        if (simpleFluidContent == null) {
            simpleFluidContent = SimpleFluidContent.EMPTY;
        }
        if ((fluidContent = simpleFluidContent).isEmpty()) {
            return;
        }
        FluidStack fluidStack = fluidContent.copy();
        FluidType fluidType = fluidStack.getFluidType();
        Component fluidName = fluidType.getDescription(fluidStack);
        Intrinsics.checkNotNull((Object)fluidName);
        tooltipComponents.add(fluidName);
    }

    static {
        Item.Properties properties = new Item.Properties().stacksTo(16);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        DEFAULT_PROPERTIES = properties;
        HAS_FLUID = OtherUtil.modResource("has_fluid");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0015J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020#J>\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020(H\u0002J2\u0010)\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010+\u001a\u00020\u000fH\u0002J&\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00060"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/EnderBucketItem$Companion;", "", "<init>", "()V", "DEFAULT_PROPERTIES", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "HAS_FLUID", "Lnet/minecraft/resources/ResourceLocation;", "getHAS_FLUID", "()Lnet/minecraft/resources/ResourceLocation;", "getHasFluidPredicate", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "localLevel", "Lnet/minecraft/client/multiplayer/ClientLevel;", "holdingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "int", "", "getItemColor", "tintIndex", "tryFill", "Lnet/minecraft/world/InteractionResultHolder;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedStack", "blockPos", "Lnet/minecraft/core/BlockPos;", "getNearestSource", "fluidType", "Lnet/neoforged/neoforge/fluids/FluidType;", "tryEmpty", "clickedPos", "relativePos", "blockHitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "attemptPlace", "", "container", "playSound", "", "fluidStack", "Lnet/neoforged/neoforge/fluids/FluidStack;", "irregular-implements-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nEnderBucketItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnderBucketItem.kt\ndev/aaronhowser/mods/irregular_implements/item/EnderBucketItem$Companion\n+ 2 OtherUtil.kt\ndev/aaronhowser/mods/irregular_implements/util/OtherUtil\n*L\n1#1,272:1\n49#2:273\n49#2:274\n*S KotlinDebug\n*F\n+ 1 EnderBucketItem.kt\ndev/aaronhowser/mods/irregular_implements/item/EnderBucketItem$Companion\n*L\n197#1:273\n228#1:274\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Item.Properties getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        @NotNull
        public final ResourceLocation getHAS_FLUID() {
            return HAS_FLUID;
        }

        public final float getHasFluidPredicate(@NotNull ItemStack stack, @Nullable ClientLevel localLevel, @Nullable LivingEntity holdingEntity, int n) {
            SimpleFluidContent fluidContent;
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            SimpleFluidContent simpleFluidContent = (SimpleFluidContent)stack.get((Supplier)ModDataComponents.INSTANCE.getSIMPLE_FLUID_CONTENT());
            if (simpleFluidContent == null) {
                simpleFluidContent = SimpleFluidContent.EMPTY;
            }
            return (fluidContent = simpleFluidContent).isEmpty() ? 0.0f : 1.0f;
        }

        public final int getItemColor(@NotNull ItemStack stack, int tintIndex) {
            SimpleFluidContent fluidContent;
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            if (tintIndex != 1) {
                return -1;
            }
            SimpleFluidContent simpleFluidContent = (SimpleFluidContent)stack.get((Supplier)ModDataComponents.INSTANCE.getSIMPLE_FLUID_CONTENT());
            if (simpleFluidContent == null) {
                simpleFluidContent = SimpleFluidContent.EMPTY;
            }
            if ((fluidContent = simpleFluidContent).isEmpty()) {
                return -1;
            }
            FluidStack fluidStack = fluidContent.copy();
            Intrinsics.checkNotNull((Object)fluidStack);
            return RenderUtil.INSTANCE.getColorFromFluid(fluidStack);
        }

        private final InteractionResultHolder<ItemStack> tryFill(Level level, Player player, ItemStack usedStack, BlockPos blockPos) {
            FluidStack fluidStack;
            IFluidHandlerItem pickupFluidStack;
            BlockState blockState = level.getBlockState(blockPos);
            Block block = blockState.getBlock();
            if (!(block instanceof BucketPickup)) {
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)usedStack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
                return interactionResultHolder;
            }
            FluidType fluidType = blockState.getFluidState().getFluidType();
            Intrinsics.checkNotNullExpressionValue((Object)fluidType, (String)"getFluidType(...)");
            BlockPos blockPos2 = this.getNearestSource(level, blockPos, fluidType);
            if (blockPos2 == null) {
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)usedStack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
                return interactionResultHolder;
            }
            BlockPos sourcePos = blockPos2;
            BlockState sourceState = level.getBlockState(sourcePos);
            Block block2 = sourceState.getBlock();
            BucketPickup bucketPickup = block2 instanceof BucketPickup ? (BucketPickup)block2 : null;
            if (bucketPickup == null) {
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)usedStack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
                return interactionResultHolder;
            }
            BucketPickup sourceBlock = bucketPickup;
            ItemStack pickup = sourceBlock.pickupBlock(player, (LevelAccessor)level, sourcePos, sourceState);
            IFluidHandlerItem iFluidHandlerItem = pickupFluidStack = (IFluidHandlerItem)pickup.getCapability(Capabilities.FluidHandler.ITEM);
            FluidStack fluidStack2 = fluidStack = iFluidHandlerItem != null ? iFluidHandlerItem.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE) : null;
            if (pickup.isEmpty() || fluidStack == null) {
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)usedStack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
                return interactionResultHolder;
            }
            sourceBlock.getPickupSound(sourceState).ifPresent(arg_0 -> Companion.tryFill$lambda$1(arg_0 -> Companion.tryFill$lambda$0(player, arg_0), arg_0));
            level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, sourcePos);
            ItemStack newStack = usedStack.copyWithCount(1);
            newStack.set((Supplier)ModDataComponents.INSTANCE.getSIMPLE_FLUID_CONTENT(), (Object)SimpleFluidContent.copyOf((FluidStack)fluidStack));
            ItemStack resultStack = ItemUtils.createFilledResult((ItemStack)usedStack, (Player)player, (ItemStack)newStack);
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.sidedSuccess((Object)resultStack, (boolean)level.isClientSide);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"sidedSuccess(...)");
            return interactionResultHolder;
        }

        @Nullable
        public final BlockPos getNearestSource(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull FluidType fluidType) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)fluidType, (String)"fluidType");
            List positionsToCheck = new ArrayList();
            List checkedPositions = new ArrayList();
            positionsToCheck.add(blockPos);
            while (!((Collection)positionsToCheck).isEmpty() && checkedPositions.size() < 2000) {
                BlockPos currentPos = (BlockPos)positionsToCheck.remove(0);
                checkedPositions.add(currentPos);
                if (!level.isLoaded(currentPos)) continue;
                FluidState checkedFluidState = level.getFluidState(currentPos);
                if (checkedFluidState.isSource() && Intrinsics.areEqual((Object)checkedFluidState.getFluidType(), (Object)fluidType)) {
                    return currentPos;
                }
                for (Direction direction : EntriesMappings.entries$0) {
                    FluidState fluidThere;
                    BlockPos nextPos = currentPos.relative(direction);
                    if (checkedPositions.contains(nextPos) || positionsToCheck.contains(nextPos) || (fluidThere = level.getFluidState(nextPos)).isEmpty()) continue;
                    Intrinsics.checkNotNull((Object)nextPos);
                    positionsToCheck.add(nextPos);
                }
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private final InteractionResultHolder<ItemStack> tryEmpty(Level level, Player player, ItemStack usedStack, BlockPos clickedPos, BlockPos relativePos, BlockHitResult blockHitResult) {
            BlockPos posToPlace;
            void $this$isTrue$iv;
            SimpleFluidContent simpleFluidContent = (SimpleFluidContent)usedStack.get((Supplier)ModDataComponents.INSTANCE.getSIMPLE_FLUID_CONTENT());
            if (simpleFluidContent == null) {
                simpleFluidContent = SimpleFluidContent.EMPTY;
            }
            SimpleFluidContent currentContents = simpleFluidContent;
            Fluid contentFluid = currentContents.getFluid();
            BlockState clickedState = level.getBlockState(clickedPos);
            OtherUtil otherUtil = OtherUtil.INSTANCE;
            Block block = clickedState.getBlock();
            LiquidBlockContainer liquidBlockContainer = block instanceof LiquidBlockContainer ? (LiquidBlockContainer)block : null;
            liquidBlockContainer = liquidBlockContainer != null ? Boolean.valueOf(liquidBlockContainer.canPlaceLiquid(player, (BlockGetter)level, clickedPos, clickedState, contentFluid)) : null;
            boolean $i$f$isTrue = false;
            boolean clickedStateCanContainFluid = Intrinsics.areEqual((Object)$this$isTrue$iv, (Object)true);
            BlockPos blockPos = posToPlace = clickedStateCanContainFluid ? clickedPos : relativePos;
            if (!this.attemptPlace(player, level, posToPlace, blockHitResult, usedStack)) {
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)usedStack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
                return interactionResultHolder;
            }
            usedStack.remove((Supplier)ModDataComponents.INSTANCE.getSIMPLE_FLUID_CONTENT());
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.sidedSuccess((Object)usedStack, (boolean)level.isClientSide);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"sidedSuccess(...)");
            return interactionResultHolder;
        }

        private final boolean attemptPlace(Player player, Level level, BlockPos blockPos, BlockHitResult blockHitResult, ItemStack container2) {
            boolean bl;
            boolean isPlaceable;
            SimpleFluidContent fluidContent;
            FluidStack fluidStack;
            Fluid fluid;
            SimpleFluidContent simpleFluidContent = (SimpleFluidContent)container2.get((Supplier)ModDataComponents.INSTANCE.getSIMPLE_FLUID_CONTENT());
            if (simpleFluidContent == null) {
                simpleFluidContent = SimpleFluidContent.EMPTY;
            }
            if (!((fluid = (fluidStack = (fluidContent = simpleFluidContent).copy()).getFluid()) instanceof FlowingFluid)) {
                return false;
            }
            BlockState blockState = level.getBlockState(blockPos);
            Block block = blockState.getBlock();
            boolean canBeReplaced = blockState.canBeReplaced(fluid);
            if (!blockState.isAir() && !canBeReplaced) {
                OtherUtil otherUtil = OtherUtil.INSTANCE;
                LiquidBlockContainer liquidBlockContainer = block instanceof LiquidBlockContainer ? (LiquidBlockContainer)block : null;
                Boolean $this$isTrue$iv = liquidBlockContainer != null ? Boolean.valueOf(liquidBlockContainer.canPlaceLiquid(player, (BlockGetter)level, blockPos, blockState, fluid)) : null;
                boolean $i$f$isTrue = false;
                v2 = Intrinsics.areEqual((Object)$this$isTrue$iv, (Object)true);
            } else {
                v2 = isPlaceable = true;
            }
            if (!isPlaceable) {
                boolean bl2;
                if (blockHitResult != null) {
                    BlockPos blockPos2 = blockPos.relative(blockHitResult.getDirection());
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"relative(...)");
                    bl2 = this.attemptPlace(player, level, blockPos2, null, container2);
                } else {
                    bl2 = false;
                }
                return bl2;
            }
            FluidType fluidType = ((FlowingFluid)fluid).getFluidType();
            if (fluidType.isVaporizedOnPlacement(level, blockPos, fluidStack)) {
                return true;
            }
            if (block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).canPlaceLiquid(player, (BlockGetter)level, blockPos, blockState, fluid)) {
                ((LiquidBlockContainer)block).placeLiquid((LevelAccessor)level, blockPos, blockState, ((FlowingFluid)fluid).getSource(false));
                Intrinsics.checkNotNull((Object)fluidStack);
                this.playSound(fluidStack, player, level, blockPos);
                return true;
            }
            if (OtherUtil.INSTANCE.isServerSide(level) && canBeReplaced && !blockState.liquid()) {
                level.destroyBlock(blockPos, true);
            }
            if (!level.setBlock(blockPos, ((FlowingFluid)fluid).defaultFluidState().createLegacyBlock(), 11) && !blockState.getFluidState().isSource()) {
                bl = false;
            } else {
                Intrinsics.checkNotNull((Object)fluidStack);
                this.playSound(fluidStack, player, level, blockPos);
                bl = true;
            }
            return bl;
        }

        public final void playSound(@NotNull FluidStack fluidStack, @NotNull Player player, @NotNull Level level, @NotNull BlockPos blockPos) {
            Intrinsics.checkNotNullParameter((Object)fluidStack, (String)"fluidStack");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            SoundEvent soundEvent = fluidStack.getFluidType().getSound(player, (BlockGetter)level, blockPos, SoundActions.BUCKET_EMPTY);
            if (soundEvent == null) {
                soundEvent = fluidStack.is(FluidTags.LAVA) ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY;
            }
            SoundEvent soundEvent2 = soundEvent;
            level.playSound(null, blockPos, soundEvent2, SoundSource.BLOCKS);
            level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PLACE, blockPos);
        }

        private static final Unit tryFill$lambda$0(Player $player, SoundEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $player.playSound(it);
            return Unit.INSTANCE;
        }

        private static final void tryFill$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class EntriesMappings {
            public static final /* synthetic */ EnumEntries<Direction> entries$0;

            static {
                entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
            }
        }
    }
}

