/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import com.mojang.serialization.Codec;
import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.entity.ThrownWeatherEggEntity;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.registry.ModItems;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0002\u0019\u001aB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u001b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/WeatherEggItem;", "Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/item/ProjectileItem;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "getName", "Lnet/minecraft/network/chat/Component;", "stack", "Lnet/minecraft/world/item/ItemStack;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "asProjectile", "Lnet/minecraft/world/entity/projectile/Projectile;", "pos", "Lnet/minecraft/core/Position;", "direction", "Lnet/minecraft/core/Direction;", "Weather", "Companion", "irregular-implements-1.21.1"})
public final class WeatherEggItem
extends Item
implements ProjectileItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Supplier<Item.Properties> DEFAULT_PROPERTIES = WeatherEggItem::DEFAULT_PROPERTIES$lambda$0;
    @NotNull
    private static final ResourceLocation WEATHER_PROPERTY = OtherUtil.modResource("weather");

    public WeatherEggItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Weather weather = (Weather)((Object)stack.get((Supplier)ModDataComponents.INSTANCE.getWEATHER()));
        if (weather == null) {
            weather = Weather.SUNNY;
        }
        Weather weather2 = weather;
        return switch (WhenMappings.$EnumSwitchMapping$0[weather2.ordinal()]) {
            case 1 -> (Component)ModLanguageProvider.Companion.toComponent("item.irregular_implements.weather_egg.sunny", new Object[0]);
            case 2 -> (Component)ModLanguageProvider.Companion.toComponent("item.irregular_implements.weather_egg.rainy", new Object[0]);
            case 3 -> (Component)ModLanguageProvider.Companion.toComponent("item.irregular_implements.weather_egg.stormy", new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack usedStack = player.getItemInHand(usedHand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EGG_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (OtherUtil.INSTANCE.isServerSide(level)) {
            ThrownWeatherEggEntity thrownWeatherEgg = new ThrownWeatherEggEntity(level, (LivingEntity)player);
            thrownWeatherEgg.setItem(usedStack);
            Weather weather = (Weather)((Object)usedStack.get((Supplier)ModDataComponents.INSTANCE.getWEATHER()));
            if (weather == null) {
                weather = Weather.SUNNY;
            }
            thrownWeatherEgg.setWeather(weather);
            thrownWeatherEgg.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            level.addFreshEntity((Entity)thrownWeatherEgg);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        usedStack.consume(1, (LivingEntity)player);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.sidedSuccess((Object)usedStack, (boolean)level.isClientSide());
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"sidedSuccess(...)");
        return interactionResultHolder;
    }

    @NotNull
    public Projectile asProjectile(@NotNull Level level, @NotNull Position pos, @NotNull ItemStack stack, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        ThrownWeatherEggEntity thrownWeatherEgg = new ThrownWeatherEggEntity(level, pos.x(), pos.y(), pos.z());
        thrownWeatherEgg.setItem(stack);
        Weather weather = (Weather)((Object)stack.get((Supplier)ModDataComponents.INSTANCE.getWEATHER()));
        if (weather == null) {
            weather = Weather.SUNNY;
        }
        thrownWeatherEgg.setWeather(weather);
        return (Projectile)thrownWeatherEgg;
    }

    private static final Item.Properties DEFAULT_PROPERTIES$lambda$0() {
        return new Item.Properties().component((Supplier)ModDataComponents.INSTANCE.getWEATHER(), (Object)Weather.SUNNY);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/WeatherEggItem$Companion;", "", "<init>", "()V", "DEFAULT_PROPERTIES", "Ljava/util/function/Supplier;", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Ljava/util/function/Supplier;", "WEATHER_PROPERTY", "Lnet/minecraft/resources/ResourceLocation;", "getWEATHER_PROPERTY", "()Lnet/minecraft/resources/ResourceLocation;", "getWeatherFloat", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "localLevel", "Lnet/minecraft/client/multiplayer/ClientLevel;", "holdingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "int", "", "fromWeather", "weather", "Ldev/aaronhowser/mods/irregular_implements/item/WeatherEggItem$Weather;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Supplier<Item.Properties> getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        @NotNull
        public final ResourceLocation getWEATHER_PROPERTY() {
            return WEATHER_PROPERTY;
        }

        public final float getWeatherFloat(@NotNull ItemStack stack, @Nullable ClientLevel localLevel, @Nullable LivingEntity holdingEntity, int n) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Weather weather = (Weather)((Object)stack.get((Supplier)ModDataComponents.INSTANCE.getWEATHER()));
            if (weather == null) {
                return 0.0f;
            }
            Weather weather2 = weather;
            return switch (WhenMappings.$EnumSwitchMapping$0[weather2.ordinal()]) {
                case 1 -> 0.0f;
                case 2 -> 1.0f;
                case 3 -> 2.0f;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @NotNull
        public final ItemStack fromWeather(@NotNull Weather weather) {
            Intrinsics.checkNotNullParameter((Object)((Object)weather), (String)"weather");
            ItemStack stack = ModItems.INSTANCE.getWEATHER_EGG().toStack();
            stack.set((Supplier)ModDataComponents.INSTANCE.getWEATHER(), (Object)weather);
            Intrinsics.checkNotNull((Object)stack);
            return stack;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Weather.values().length];
                try {
                    nArray[Weather.SUNNY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Weather.RAINY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Weather.STORMY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u0000 \u000b2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u000bB\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\f"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/WeatherEggItem$Weather;", "Lnet/minecraft/util/StringRepresentable;", "", "realName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "SUNNY", "RAINY", "STORMY", "getSerializedName", "Companion", "irregular-implements-1.21.1"})
    public static final class Weather
    extends Enum<Weather>
    implements StringRepresentable {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String realName;
        @NotNull
        private static final StringRepresentable.EnumCodec<Weather> CODEC;
        @NotNull
        private static final StreamCodec<ByteBuf, Weather> STREAM_CODEC;
        public static final /* enum */ Weather SUNNY;
        public static final /* enum */ Weather RAINY;
        public static final /* enum */ Weather STORMY;
        private static final /* synthetic */ Weather[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Weather(String realName) {
            this.realName = realName;
        }

        @NotNull
        public String getSerializedName() {
            return this.realName;
        }

        public static Weather[] values() {
            return (Weather[])$VALUES.clone();
        }

        public static Weather valueOf(String value) {
            return Enum.valueOf(Weather.class, value);
        }

        @NotNull
        public static EnumEntries<Weather> getEntries() {
            return $ENTRIES;
        }

        static {
            SUNNY = new Weather("sunny");
            RAINY = new Weather("rainy");
            STORMY = new Weather("stormy");
            $VALUES = weatherArray = new Weather[]{Weather.SUNNY, Weather.RAINY, Weather.STORMY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            StringRepresentable.EnumCodec enumCodec = StringRepresentable.fromEnum(Weather::values);
            Intrinsics.checkNotNullExpressionValue((Object)enumCodec, (String)"fromEnum(...)");
            CODEC = enumCodec;
            StreamCodec streamCodec = ByteBufCodecs.fromCodec((Codec)((Codec)CODEC));
            Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"fromCodec(...)");
            STREAM_CODEC = streamCodec;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/WeatherEggItem$Weather$Companion;", "", "<init>", "()V", "CODEC", "Lnet/minecraft/util/StringRepresentable$EnumCodec;", "Ldev/aaronhowser/mods/irregular_implements/item/WeatherEggItem$Weather;", "getCODEC", "()Lnet/minecraft/util/StringRepresentable$EnumCodec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lio/netty/buffer/ByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "irregular-implements-1.21.1"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final StringRepresentable.EnumCodec<Weather> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final StreamCodec<ByteBuf, Weather> getSTREAM_CODEC() {
                return STREAM_CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Weather.values().length];
            try {
                nArray[Weather.SUNNY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Weather.RAINY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Weather.STORMY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

