/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.registry.ModItems;
import dev.aaronhowser.mods.irregular_implements.registry.ModSounds;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0011H\u0016J.\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#H\u0016\u00a8\u0006%"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/WhiteStoneItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "inventoryTick", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/Entity;", "slotId", "", "isSelected", "", "onEntityItemUpdate", "Lnet/minecraft/world/entity/item/ItemEntity;", "isFoil", "getBarColor", "isBarVisible", "getBarWidth", "shouldCauseReequipAnimation", "oldStack", "newStack", "slotChanged", "appendHoverText", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Companion", "irregular-implements-1.21.1"})
public final class WhiteStoneItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Supplier<Item.Properties> DEFAULT_PROPERTIES = WhiteStoneItem::DEFAULT_PROPERTIES$lambda$0;
    public static final int MAX_CHARGE = 2000;

    public WhiteStoneItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Vec3 vec3 = entity.getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
        Companion.tryCharge(level, stack, vec3);
    }

    public boolean onEntityItemUpdate(@NotNull ItemStack stack, @NotNull ItemEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Level level = entity.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        Vec3 vec3 = entity.getEyePosition().add(0.0, 1.0, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        boolean charged = Companion.tryCharge(level, stack, vec3);
        entity.setNoGravity(charged);
        if (charged) {
            Vec3 motion = entity.getDeltaMovement();
            double newDy = Mth.lerp((double)0.1, (double)motion.y, (double)0.0);
            entity.setDeltaMovement(motion.x * 0.95, newDy, motion.z * 0.95);
            entity.lifespan = Integer.MAX_VALUE;
        }
        return false;
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return Companion.isChargedWhiteStone(stack);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return Color.WHITE.getRGB();
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Integer charge = (Integer)stack.get((DataComponentType)ModDataComponents.INSTANCE.getCHARGE().get());
        return charge != null && charge > 0 && charge < 2000;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Integer n = (Integer)stack.get((DataComponentType)ModDataComponents.INSTANCE.getCHARGE().get());
        if (n == null) {
            return 0;
        }
        int charge = n;
        return (int)((float)charge / 2000.0f * (float)13);
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        Intrinsics.checkNotNullParameter((Object)oldStack, (String)"oldStack");
        Intrinsics.checkNotNullParameter((Object)newStack, (String)"newStack");
        return slotChanged && super.shouldCauseReequipAnimation(oldStack, newStack, true);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        Integer n = (Integer)stack.get((DataComponentType)ModDataComponents.INSTANCE.getCHARGE().get());
        int charge = n != null ? n : 0;
        float percentCharge = (float)charge / 2000.0f * (float)100;
        String string = "%.2f";
        Object[] objectArray = new Object[]{Float.valueOf(percentCharge)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String formattedCharge = string2;
        Object[] objectArray2 = new Object[]{formattedCharge};
        tooltipComponents.add((Component)ModLanguageProvider.Companion.toGrayComponent("tooltip.irregular_implements.charge", objectArray2));
        if (charge < 2000) {
            tooltipComponents.add((Component)ModLanguageProvider.Companion.toGrayComponent("tooltip.irregular_implements.white_stone_full_moon", new Object[0]));
        }
    }

    private static final Item.Properties DEFAULT_PROPERTIES$lambda$0() {
        return new Item.Properties().rarity(Rarity.UNCOMMON).stacksTo(1).component((Supplier)ModDataComponents.INSTANCE.getCHARGE(), (Object)0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/WhiteStoneItem$Companion;", "", "<init>", "()V", "DEFAULT_PROPERTIES", "Ljava/util/function/Supplier;", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Ljava/util/function/Supplier;", "MAX_CHARGE", "", "tryCharge", "", "level", "Lnet/minecraft/world/level/Level;", "stack", "Lnet/minecraft/world/item/ItemStack;", "pos", "Lnet/minecraft/world/phys/Vec3;", "isChargedWhiteStone", "itemStack", "tryPreventDeath", "", "event", "Lnet/neoforged/neoforge/event/entity/living/LivingDeathEvent;", "irregular-implements-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nWhiteStoneItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WhiteStoneItem.kt\ndev/aaronhowser/mods/irregular_implements/item/WhiteStoneItem$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n1#2:176\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Supplier<Item.Properties> getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        public final boolean tryCharge(@NotNull Level level, @NotNull ItemStack stack, @NotNull Vec3 pos) {
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                    Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                    Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                    if (level.getMoonPhase() != 0) break block5;
                    long l = level.getDayTime();
                    if ((14000L <= l ? l < 23001L : false) && !this.isChargedWhiteStone(stack) && level.canSeeSky(BlockPos.containing((Position)((Position)pos)))) break block6;
                }
                return false;
            }
            Integer currentCharge = (Integer)stack.getOrDefault((DataComponentType)ModDataComponents.INSTANCE.getCHARGE().get(), (Object)0);
            int newCharge = currentCharge + 1;
            stack.set((Supplier)ModDataComponents.INSTANCE.getCHARGE(), (Object)newCharge);
            if (level instanceof ServerLevel) {
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.ENCHANT, pos.x, pos.y, pos.z, 1, 0.0, 0.0, 0.0, Mth.lerp((double)((double)newCharge / 2000.0), (double)3.0, (double)2.25));
                if (newCharge == 2000) {
                    level.playSound(null, BlockPos.containing((Position)((Position)pos)), SoundEvents.ZOMBIE_VILLAGER_CONVERTED, SoundSource.PLAYERS);
                }
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isChargedWhiteStone(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            if (!itemStack.is((Item)ModItems.INSTANCE.getWHITE_STONE().get())) return false;
            Integer n = (Integer)itemStack.get((DataComponentType)ModDataComponents.INSTANCE.getCHARGE().get());
            int n2 = 2000;
            if (n == null) return false;
            if (n != n2) return false;
            return true;
        }

        public final void tryPreventDeath(@NotNull LivingDeathEvent event) {
            ItemStack itemStack;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.isCanceled()) {
                return;
            }
            LivingEntity entity = event.getEntity();
            if (entity instanceof Player) {
                Object v1;
                block7: {
                    NonNullList nonNullList = ((Player)entity).getInventory().items;
                    Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"items");
                    var4_3 = (Iterable)nonNullList;
                    for (Object t : var4_3) {
                        it = (ItemStack)t;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!Companion.isChargedWhiteStone(it)) continue;
                        v1 = t;
                        break block7;
                    }
                    v1 = null;
                }
                if ((itemStack = (ItemStack)v1) == null) {
                    return;
                }
            } else {
                Object v4;
                block8: {
                    Iterable iterable = entity.getHandSlots();
                    Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getHandSlots(...)");
                    var4_3 = iterable;
                    for (Object t : var4_3) {
                        it = (ItemStack)t;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!Companion.isChargedWhiteStone(it)) continue;
                        v4 = t;
                        break block8;
                    }
                    v4 = null;
                }
                if ((itemStack = (ItemStack)v4) == null) {
                    return;
                }
            }
            ItemStack whiteStone = itemStack;
            event.setCanceled(true);
            whiteStone.set((Supplier)ModDataComponents.INSTANCE.getCHARGE(), (Object)0);
            entity.level().playSound(null, entity.blockPosition(), (SoundEvent)ModSounds.INSTANCE.getWHITE_STONE_ACTIVATE().get(), entity.getSoundSource());
            entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200));
            entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 200));
            entity.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 200, 1));
            entity.setHealth(entity.getMaxHealth());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

